/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.asciiart.Wcwidth;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

public class StringUtils {
    public static String getPlateformDependentAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    public static final List<String> getSplit(Pattern2 pattern, String line) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i));
        }
        return result;
    }

    public static boolean isNotEmpty(String input) {
        return input != null && StringUtils.trin(input).length() > 0;
    }

    public static boolean isNotEmpty(List<? extends CharSequence> input) {
        return input != null && input.size() > 0;
    }

    public static boolean isEmpty(String input) {
        return input == null || StringUtils.trin(input).length() == 0;
    }

    public static String manageHtml(String s) {
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        return s;
    }

    public static String unicode(String s) {
        StringBuilder result = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|') {
                char i = c;
                result.append("&#" + i + ";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String unicodeForHtml(String s) {
        StringBuilder result = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|' || c == '<' || c == '>') {
                char i = c;
                result.append("&#" + i + ";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String unicodeForHtml(Display display) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < display.size(); ++i) {
            result.append(StringUtils.unicodeForHtml(display.get(i).toString()));
            if (i >= display.size() - 1) continue;
            result.append("<br>");
        }
        return result.toString();
    }

    public static String manageArrowForSequence(String s) {
        s = s.replace('=', '-').toLowerCase();
        return s;
    }

    public static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String goUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    public static char goUpperCase(char c) {
        return StringUtils.goUpperCase("" + c).charAt(0);
    }

    public static String goLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static char goLowerCase(char c) {
        return StringUtils.goLowerCase("" + c).charAt(0);
    }

    public static String manageArrowForCuca(String s) {
        Direction dir = StringUtils.getArrowDirection(s);
        s = s.replace('=', '-');
        s = s.replaceAll("\\w*", "");
        if (dir == Direction.LEFT || dir == Direction.RIGHT) {
            s = s.replaceAll("-+", "-");
        }
        if (s.length() == 2 && (dir == Direction.UP || dir == Direction.DOWN)) {
            s = s.replaceFirst("-", "--");
        }
        return s;
    }

    public static String manageQueueForCuca(String s) {
        Direction dir = StringUtils.getQueueDirection(s);
        s = s.replace('=', '-');
        s = s.replaceAll("\\w*", "");
        if (dir == Direction.LEFT || dir == Direction.RIGHT) {
            s = s.replaceAll("-+", "-");
        }
        if (s.length() == 1 && (dir == Direction.UP || dir == Direction.DOWN)) {
            s = s.replaceFirst("-", "--");
        }
        return s;
    }

    public static Direction getArrowDirection(String s) {
        if (s.endsWith(">")) {
            return StringUtils.getQueueDirection(s.substring(0, s.length() - 1));
        }
        if (s.startsWith("<")) {
            if (s.length() == 2) {
                return Direction.LEFT;
            }
            return Direction.UP;
        }
        throw new IllegalArgumentException(s);
    }

    public static Direction getQueueDirection(String s) {
        if (s.indexOf(60) != -1 || s.indexOf(62) != -1) {
            throw new IllegalArgumentException(s);
        }
        if ((s = s.toLowerCase()).contains("left")) {
            return Direction.LEFT;
        }
        if (s.contains("right")) {
            return Direction.RIGHT;
        }
        if (s.contains("up")) {
            return Direction.UP;
        }
        if (s.contains("down")) {
            return Direction.DOWN;
        }
        if (s.contains("l")) {
            return Direction.LEFT;
        }
        if (s.contains("r")) {
            return Direction.RIGHT;
        }
        if (s.contains("u")) {
            return Direction.UP;
        }
        if (s.contains("d")) {
            return Direction.DOWN;
        }
        if (s.length() == 1) {
            return Direction.RIGHT;
        }
        return Direction.DOWN;
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String s, String format) {
        if (format.contains("\"") && s.length() > 1 && StringUtils.isDoubleQuote(s.charAt(0)) && StringUtils.isDoubleQuote(s.charAt(s.length() - 1))) {
            return s.substring(1, s.length() - 1);
        }
        if (format.contains("(") && s.startsWith("(") && s.endsWith(")")) {
            return s.substring(1, s.length() - 1);
        }
        if (format.contains("[") && s.startsWith("[") && s.endsWith("]")) {
            return s.substring(1, s.length() - 1);
        }
        if (format.contains(":") && s.startsWith(":") && s.endsWith(":")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String s) {
        if (s == null) {
            return s;
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s, "\"([:");
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"' || c == '\u201c' || c == '\u201d' || c == '\u00ab' || c == '\u00bb';
    }

    public static boolean isCJK(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        Log.println("block=" + block);
        return false;
    }

    public static char hiddenLesserThan() {
        return '\u0005';
    }

    public static char hiddenBiggerThan() {
        return '\u0006';
    }

    public static String hideComparatorCharacters(String s) {
        s = s.replace('<', StringUtils.hiddenLesserThan());
        s = s.replace('>', StringUtils.hiddenBiggerThan());
        return s;
    }

    public static String showComparatorCharacters(String s) {
        s = s.replace(StringUtils.hiddenLesserThan(), '<');
        s = s.replace(StringUtils.hiddenBiggerThan(), '>');
        return s;
    }

    private static int getWidth(Display stringsToDisplay) {
        int result = 1;
        for (CharSequence s : stringsToDisplay) {
            if (s == null || result >= s.length()) continue;
            result = s.length();
        }
        return result;
    }

    public static int getWcWidth(Display stringsToDisplay) {
        int result = 1;
        for (CharSequence s : stringsToDisplay) {
            int length;
            if (s == null || result >= (length = Wcwidth.length(s))) continue;
            result = length;
        }
        return result;
    }

    public static int getHeight(List<? extends CharSequence> stringsToDisplay) {
        return stringsToDisplay.size();
    }

    public static int getHeight(Display stringsToDisplay) {
        return stringsToDisplay.size();
    }

    public static boolean isDiagramCacheable(String uml) {
        if ((uml = uml.toLowerCase()).startsWith("@startuml\nversion\n")) {
            return false;
        }
        if (uml.startsWith("@startuml\nlicense\n")) {
            return false;
        }
        if (uml.startsWith("@startuml\nlicence\n")) {
            return false;
        }
        if (uml.startsWith("@startuml\nauthor\n")) {
            return false;
        }
        if (uml.startsWith("@startuml\ncheckversion")) {
            return false;
        }
        if (uml.startsWith("@startuml\ntestdot\n")) {
            return false;
        }
        return !uml.startsWith("@startuml\nsudoku\n");
    }

    public static int getPragmaRevision(String uml) {
        int x1;
        int x2;
        uml = uml.toLowerCase();
        String header = "@startuml\n!pragma revision ";
        if (!uml.startsWith("@startuml\n!pragma revision ")) {
            return -1;
        }
        for (x2 = x1 = "@startuml\n!pragma revision ".length(); x2 < uml.length() && Character.isDigit(uml.charAt(x2)); ++x2) {
        }
        if (x1 == x2) {
            return -1;
        }
        return Integer.parseInt(uml.substring(x1, x2));
    }

    public static List<String> splitComma(String s) {
        s = StringUtils.trin(s);
        ArrayList<String> result = new ArrayList<String>();
        Pattern2 p = MyPattern.cmpile("([\\p{L}0-9_.]+|[%g][^%g]+[%g])");
        Matcher2 m = p.matcher(s);
        while (m.find()) {
            result.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m.group(0)));
        }
        return Collections.unmodifiableList(result);
    }

    public static String getAsHtml(Color color) {
        if (color == null) {
            return null;
        }
        return StringUtils.getAsHtml(color.getRGB());
    }

    public static String getAsSvg(ColorMapper mapper, HtmlColor color) {
        if (color == null) {
            return "none";
        }
        if (color instanceof HtmlColorTransparent) {
            return "#FFFFFF";
        }
        return StringUtils.getAsHtml(mapper.getMappedColor(color));
    }

    public static String getAsHtml(int color) {
        int v = 0xFFFFFF & color;
        String s = "000000" + Integer.toHexString(v).toUpperCase();
        s = s.substring(s.length() - 6);
        return "#" + s;
    }

    public static String getUid(String uid1, int uid2) {
        return uid1 + String.format("%04d", uid2);
    }

    public static <O> List<O> merge(List<O> l1, List<O> l2) {
        ArrayList<O> result = new ArrayList<O>(l1);
        result.addAll(l2);
        return Collections.unmodifiableList(result);
    }

    public static boolean endsWithBackslash(String s) {
        return s.endsWith("\\") && !s.endsWith("\\\\");
    }

    public static String rot(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'm' || c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z' || c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            } else if (c > '~') {
                throw new IllegalArgumentException(s);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String manageUnicodeNotationUplus(String s) {
        Pattern pattern = Pattern.compile("\\<U\\+([0-9a-fA-F]{4,5})\\>");
        Matcher matcher = pattern.matcher(s);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String num = matcher.group(1);
            int value = Integer.parseInt(num, 16);
            String replace = new String(Character.toChars(value));
            matcher.appendReplacement(result, Matcher.quoteReplacement(replace));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String manageAmpDiese(String s) {
        Pattern pattern = Pattern.compile("\\&#([0-9]+);");
        Matcher matcher = pattern.matcher(s);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String num = matcher.group(1);
            char c = (char)Integer.parseInt(num);
            matcher.appendReplacement(result, "" + c);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String manageTildeArobaseStart(String s) {
        s = s.replaceAll("~@start", "@start");
        return s;
    }

    public static String trinNoTrace(CharSequence s) {
        return s.toString().trim();
    }

    public static String trin(String arg) {
        int j;
        int i;
        if (arg.length() == 0) {
            return arg;
        }
        for (i = 0; i < arg.length() && StringUtils.isSpaceOrTabOrNull(arg.charAt(i)); ++i) {
        }
        for (j = arg.length() - 1; j >= i && StringUtils.isSpaceOrTabOrNull(arg.charAt(j)); --j) {
        }
        if (i == 0 && j == arg.length() - 1) {
            return arg;
        }
        return arg.substring(i, j + 1);
    }

    private static boolean isSpaceOrTabOrNull(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000';
    }
}

