/*
 * Decompiled with CFR 0.152.
 */
package owl.command;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.command.AbstractOwlSubcommand;
import owl.command.Mixins;
import owl.ltl.LabelledFormula;
import owl.translations.LtlTranslationRepository;
import picocli.CommandLine;

final class LtlTranslationCommands {
    private LtlTranslationCommands() {
    }

    @CommandLine.Command(name="ltl2dela", description={"Translate a linear temporal logic (LTL) formula into a deterministic Emerson-Lei automaton (DELA).", "Usage Examples:", "  owl ltl2dela -f 'F (a & G b)'", "  owl ltl2dela -t MS17 -i input-file -o output-file", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ltl2DelaCommand
    extends AbstractLtl2AutomatonCommand<EmersonLeiAcceptance, EmersonLeiAcceptance> {
        @CommandLine.Option(names={"-t", "--translation"}, description={"The default translation is ${DEFAULT-VALUE} and the following translations are available: ${COMPLETION-CANDIDATES}.", "MS17: Translate the formula to a deterministic Emerson-Lei automaton using an specialised product construction and a portfolio of constructions for simple LTL fragments. This construction has been originally be implemented in 'delag' and presented in [MS17]. If a subformula is not in a supported fragment then [EKS20] is used as a fallback.", "SLM21: Translate the formula to a deterministic Emerson-Lei automaton by rewriting the formula locally into the \u0394\u2082-normalform using the procedure of [SE20], i.e., only temporal subformulas that are not in \u0394\u2082 are rewritten, and then use an specialised product construction [SLM21] to obtain a deterministic automaton. After rewriting each temporal subformula is in \u03a3\u2082 or \u03a0\u2082 and the direct translation to deterministic co-B\u00fcchi and B\u00fcchi automata from [SLM21] is sufficient.", "SMALLEST_AUTOMATON: Run all available DELA- and DGRA-translations with all optimisations turned on in parallel and return the smallest automaton."}, defaultValue="SLM21", showDefaultValue=CommandLine.Help.Visibility.NEVER)
        private LtlTranslationRepository.LtlToDelaTranslation translation = LtlTranslationRepository.LtlToDelaTranslation.DEFAULT;
        @CommandLine.Option(names={"--SLM21-lookahead"}, description={"The number of successor states that are explored in order to compute an exact semantic classification of a state, e.g., weak accepting. If the number of explored states exceeds this bound, a sound, but incomplete syntactic check is performed. If the value is 0, only syntactic checks are performed. If the value is negative, then all states are explored. The value is by default ${DEFAULT-VALUE}. If the construction times out, try setting this value to 0 and then increase it again in order to obtain smaller automata. This option only affects the SLM21-translation."}, defaultValue="-1")
        private int lookahead = -1;

        Ltl2DelaCommand() {
        }

        protected LtlTranslationRepository.LtlToDelaTranslation translation() {
            return this.translation;
        }

        @Override
        protected Class<? extends EmersonLeiAcceptance> acceptanceClass() {
            return EmersonLeiAcceptance.class;
        }

        protected EnumSet<LtlTranslationRepository.Option> extraOptions() {
            return EnumSet.noneOf(LtlTranslationRepository.Option.class);
        }

        @Override
        protected OptionalInt lookahead() {
            return this.lookahead < 0 ? OptionalInt.empty() : OptionalInt.of(this.lookahead);
        }
    }

    @CommandLine.Command(name="ltl2dgra", description={"Translate a linear temporal logic (LTL) formula into a deterministic generalized Rabin automaton (DGRA).", "Usage Examples:", "  owl ltl2dgra -f 'F (a & G b)'", "  owl ltl2dgra -t SE20 -i input-file -o output-file", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ltl2DgraCommand
    extends AbstractLtl2DraCommand {
        Ltl2DgraCommand() {
        }

        @Override
        protected Class<? extends GeneralizedRabinAcceptance> acceptanceClass() {
            return GeneralizedRabinAcceptance.class;
        }
    }

    @CommandLine.Command(name="ltl2dra", description={"Translate a linear temporal logic (LTL) formula into a deterministic Rabin automaton (DRA).", "Usage Examples:", "  owl ltl2dra -f 'F (a & G b)'", "  owl ltl2dra -t SE20 -i input-file -o output-file", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ltl2DraCommand
    extends AbstractLtl2DraCommand {
        Ltl2DraCommand() {
        }

        @Override
        protected Class<? extends GeneralizedRabinAcceptance> acceptanceClass() {
            return RabinAcceptance.class;
        }
    }

    private static abstract class AbstractLtl2DraCommand
    extends AbstractLtl2AutomatonCommand<RabinAcceptance, GeneralizedRabinAcceptance> {
        @CommandLine.Option(names={"-t", "--translation"}, description={"The default translation is ${DEFAULT-VALUE} and the following translations are available: ${COMPLETION-CANDIDATES}.", "EKS16: Translate the formula to a deterministic (generalised) Rabin automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton. This construction is also known as the original 'Rabinizer'-construction [EKS16] and used to be available through the '--asymmetric' option.", "EKS20: Translate the formula to a deterministic (generalised) Rabin automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton and the set of least fixed-point operators, i.e. F, M, and U, that is satisfied by infinitely many suffixes of the word read by the automaton. This construction has been initially proposed in [EKS18] and has been described in more detail and with optimisations in [S19]. The preferred reference to cite is the journal article [EKS20]. The translation used to be available through the '--symmetric' option.", "SE20: Translate the formula to a deterministic (generalised) Rabin automaton by rewriting the formula into the \u0394\u2082-normalform using the procedure of [SE20] and then by using the constructions for 'simple' LTL fragments from [SE20, S19].", "SMALLEST_AUTOMATON: Run all available D(G)RA-translations with all optimisations turned on in parallel and return the smallest automaton."}, defaultValue="EKS20", showDefaultValue=CommandLine.Help.Visibility.NEVER)
        private LtlTranslationRepository.LtlToDraTranslation translation = LtlTranslationRepository.LtlToDraTranslation.DEFAULT;
        @CommandLine.Option(names={"--SE20-no-dual-normal-form"}, description={"Do not use the dual normal form of [SE20] for the translation to deterministic automata. This option is only honoured if SE20 is selected as translation."})
        private boolean noSe20dual = true;

        private AbstractLtl2DraCommand() {
        }

        protected final LtlTranslationRepository.LtlToDraTranslation translation() {
            return this.translation;
        }

        @Override
        protected final Set<LtlTranslationRepository.Option> extraOptions() {
            return this.noSe20dual ? Set.of() : Set.of(LtlTranslationRepository.Option.X_DRA_NORMAL_FORM_USE_DUAL);
        }
    }

    @CommandLine.Command(name="ltl2dpa", description={"Translate a linear temporal logic (LTL) formula into a deterministic parity automaton (DPA).", "Usage Examples:", "  owl ltl2dpa -f 'F (a & G b)'", "  owl ltl2dpa -t SEJK16_EKRS17 -i input-file -o output-file", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ltl2DpaCommand
    extends AbstractLtl2AutomatonCommand<ParityAcceptance, ParityAcceptance> {
        @CommandLine.Option(names={"-t", "--translation"}, description={"The default translation is ${DEFAULT-VALUE} and the following translations are available: ${COMPLETION-CANDIDATES}.", "SEJK16_EKRS17: Translate the formula to a deterministic parity automaton by combining [SEJK16] with the LDBA-to-DPA translation of [EKRS17]. This translation used to be available through the '--asymmetric' option.", "EKS20_EKRS17: Translate the formula to a deterministic parity automaton by combining [EKS20] with the LDBA-to-DPA translation of [EKRS17]. This translation used to be available through the '--symmetric' option.", "SYMBOLIC_SE20_BKS10: Translate the formula to a deterministic parity automaton by combining the LTL-to-DRA translation of [SE20] with DRAxDSA-to-DPA result of [BKS10]. This translation has an _symbolic_ implementation and is provided for testing purposes through this interface. In order to benefit from the symbolic implementation users _must_ use the 'SymbolicAutomaton'-interface.", "SLM21: Translate the formula to a deterministic parity automaton by combining the LTL-to-DELA translation of [SLM21] with a DELW-to-DPW translation based on Zielonka-trees. Depending on the lookahead either [CCF21]  or [SLM21] is used.", "SMALLEST_AUTOMATON: Run all available DPA-translations with all optimisations turned on in parallel and return the smallest automaton."}, defaultValue="SLM21", showDefaultValue=CommandLine.Help.Visibility.NEVER)
        private LtlTranslationRepository.LtlToDpaTranslation translation = LtlTranslationRepository.LtlToDpaTranslation.DEFAULT;
        @CommandLine.Option(names={"--EKRS17-skip-complement"}, description={"Bypass the parallel computation of a DPA for the negation of the formula. If the parallel computation is enabled, then two DPAs are computed and the smaller one (in terms of number of states) is returned."})
        private boolean skipComplement = false;
        @CommandLine.Option(names={"--SLM21-lookahead"}, description={"The number of successor states that are explored in order to (1) compute an exact semantic classification of a state, e.g., weak accepting, and (2) in order to compute the 'Alternating Cycle Decomposition' [CCF21]. If the number of explored states exceeds this bound, a sound approximations are used as desribed in [SLM21]. If the value is 0, only approximations are used. If the value is negative, then all states are explored and exact semantic information is used. The value is by default ${DEFAULT-VALUE}. If the construction times out, try setting this value to 0 and then increase it again in order to obtain smaller automata. This option only affects the SLM21-translation."}, defaultValue="-1")
        private int lookahead = -1;

        Ltl2DpaCommand() {
        }

        protected LtlTranslationRepository.LtlToDpaTranslation translation() {
            return this.translation;
        }

        @Override
        protected Class<? extends ParityAcceptance> acceptanceClass() {
            return ParityAcceptance.class;
        }

        @Override
        protected Set<LtlTranslationRepository.Option> extraOptions() {
            return this.skipComplement ? Set.of() : Set.of(LtlTranslationRepository.Option.X_DPA_USE_COMPLEMENT);
        }

        @Override
        protected OptionalInt lookahead() {
            return this.lookahead < 0 ? OptionalInt.empty() : OptionalInt.of(this.lookahead);
        }
    }

    @CommandLine.Command(name="ltl2ldgba", description={"Translate a linear temporal logic (LTL) formula into a limit-deterministic generalized B\u00fcchi automaton (LDGBA).", "Usage Examples:", "  owl ltl2ldgba -f 'F (a & G b)'", "  owl ltl2ldgba -t EKS20 -i input-file -o output-file", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ltl2LdgbaCommand
    extends AbstractLtl2LdbaCommand {
        Ltl2LdgbaCommand() {
        }

        @Override
        protected Class<? extends GeneralizedBuchiAcceptance> acceptanceClass() {
            return GeneralizedBuchiAcceptance.class;
        }
    }

    @CommandLine.Command(name="ltl2ldba", description={"Translate a linear temporal logic (LTL) formula into a limit-deterministic B\u00fcchi automaton (LDBA).", "Usage Examples:", "  owl ltl2ldba -f 'F (a & G b)'", "  owl ltl2ldba -t EKS20 -i input-file -o output-file", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ltl2LdbaCommand
    extends AbstractLtl2LdbaCommand {
        Ltl2LdbaCommand() {
        }

        @Override
        protected Class<? extends GeneralizedBuchiAcceptance> acceptanceClass() {
            return BuchiAcceptance.class;
        }
    }

    private static abstract class AbstractLtl2LdbaCommand
    extends AbstractLtl2AutomatonCommand<BuchiAcceptance, GeneralizedBuchiAcceptance> {
        @CommandLine.Option(names={"-t", "--translation"}, description={"The default translation is ${DEFAULT-VALUE} and the following translations are available: ${COMPLETION-CANDIDATES}.", "SEJK16: Translate the formula to a limit-deterministic (generalised) B\u00fcchi automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton. The construction is an optimised version of the construction appearing in [SEJK16] and used to be available through the '--asymmetric' option.", "EKS20: Translate the formula to a limit-deterministic (generalised) B\u00fcchi automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton and the set of least fixed-point operators, i.e. F, M, and U, that is satisfied by infinitely many suffixes of the word read by the automaton. This construction has been initially proposed in [EKS18] and has been described in more detail and with optimisations in [S19]. The preferred reference to cite is the journal article [EKS20]. The translation used to be available through the '--symmetric' option.", "SMALLEST_AUTOMATON: Run all available LD(G)BA-translations in parallel and return the smallest automaton."}, defaultValue="SEJK16", showDefaultValue=CommandLine.Help.Visibility.NEVER)
        private LtlTranslationRepository.LtlToLdbaTranslation translation = LtlTranslationRepository.LtlToLdbaTranslation.DEFAULT;

        private AbstractLtl2LdbaCommand() {
        }

        protected final LtlTranslationRepository.LtlToLdbaTranslation translation() {
            return this.translation;
        }
    }

    @CommandLine.Command(name="ltl2ngba", description={"Translate a linear temporal logic (LTL) formula into a non-deterministic generalized B\u00fcchi automaton (NGBA).", "Usage Examples:", "  owl ltl2ngba -f 'F (a & G b)'", "  owl ltl2ngba -t EKS20 -i input-file -o output-file", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ltl2NgbaCommand
    extends AbstractLtl2NbaCommand {
        Ltl2NgbaCommand() {
        }

        @Override
        protected Class<? extends GeneralizedBuchiAcceptance> acceptanceClass() {
            return GeneralizedBuchiAcceptance.class;
        }
    }

    @CommandLine.Command(name="ltl2nba", description={"Translate a linear temporal logic (LTL) formula into a non-deterministic B\u00fcchi automaton (NBA).", "Usage Examples:", "  owl ltl2nba -f 'F (a & G b)'", "  owl ltl2nba -t EKS20 -i input-file -o output-file", "To look up a reference, e.g. [SE20], used in this help message please use 'owl bibliography'."})
    static final class Ltl2NbaCommand
    extends AbstractLtl2NbaCommand {
        Ltl2NbaCommand() {
        }

        @Override
        protected Class<? extends GeneralizedBuchiAcceptance> acceptanceClass() {
            return BuchiAcceptance.class;
        }
    }

    private static abstract class AbstractLtl2NbaCommand
    extends AbstractLtl2AutomatonCommand<BuchiAcceptance, GeneralizedBuchiAcceptance> {
        @CommandLine.Option(names={"-t", "--translation"}, description={"The default translation is ${DEFAULT-VALUE} and the following translations are available: ${COMPLETION-CANDIDATES}.", "EKS20: Translate the formula to a non-deterministic (generalised) B\u00fcchi automaton by guessing and checking the set of greatest fixed-point operators, i.e. G, R, and W, that is satisfied by almost all suffixes of the word read by the automaton and the set of least fixed-point operators, i.e. F, M, and U, that is satisfied by infinitely many suffixes of the word read by the automaton. This construction has been initially proposed in [EKS18] and has been described in more detail and with optimisations in [S19]. The preferred reference to cite is the journal article [EKS20]. The translation used to be available through the '--symmetric' option."}, defaultValue="EKS20", showDefaultValue=CommandLine.Help.Visibility.NEVER)
        private LtlTranslationRepository.LtlToNbaTranslation translation = LtlTranslationRepository.LtlToNbaTranslation.DEFAULT;

        private AbstractLtl2NbaCommand() {
        }

        protected final LtlTranslationRepository.LtlToNbaTranslation translation() {
            return this.translation;
        }
    }

    private static abstract class AbstractLtl2AutomatonCommand<L extends A, A extends EmersonLeiAcceptance>
    extends AbstractOwlSubcommand {
        protected static final String LIST_AVAILABLE_TRANSLATIONS = "The default translation is ${DEFAULT-VALUE} and the following translations are available: ${COMPLETION-CANDIDATES}.";
        @CommandLine.Mixin
        private Mixins.FormulaReader formulaReader = null;
        @CommandLine.Mixin
        private Mixins.AutomatonWriter automatonWriter = null;
        @CommandLine.Mixin
        private Mixins.FormulaSimplifier formulaSimplifier = null;
        @CommandLine.Mixin
        private Mixins.AcceptanceSimplifier acceptanceSimplifier = null;
        @CommandLine.Option(names={"--skip-translation-portfolio"}, description={"Bypass the portfolio of constructions from [S19, SE20] that directly translates 'simple' fragments of LTL to automata."})
        private boolean skipPortfolio = false;

        private AbstractLtl2AutomatonCommand() {
        }

        @Override
        protected int run() throws Exception {
            LtlTranslationRepository.LtlTranslation<L, A> translation = this.translation();
            Class<A> acceptanceClass = this.acceptanceClass();
            EnumSet<LtlTranslationRepository.Option> basicOptions = EnumSet.noneOf(LtlTranslationRepository.Option.class);
            if (!this.formulaSimplifier.skipSimplifier) {
                basicOptions.add(LtlTranslationRepository.Option.SIMPLIFY_FORMULA);
            }
            if (!this.acceptanceSimplifier.skipAcceptanceSimplifier) {
                basicOptions.add(LtlTranslationRepository.Option.SIMPLIFY_AUTOMATON);
            }
            if (this.automatonWriter.complete) {
                basicOptions.add(LtlTranslationRepository.Option.COMPLETE);
            }
            if (!this.skipPortfolio) {
                basicOptions.add(LtlTranslationRepository.Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS);
            }
            basicOptions.addAll(this.extraOptions());
            String subcommand = this.getClass().getAnnotation(CommandLine.Command.class).name();
            Function<LabelledFormula, Automaton<?, A>> translator = translation.translation(acceptanceClass, basicOptions, this.lookahead());
            try (Stream<LabelledFormula> source = this.formulaReader.source();
                 Mixins.AutomatonWriter.Sink sink = this.automatonWriter.sink(subcommand, this.rawArgs());){
                Iterator formulaIterator = source.iterator();
                while (formulaIterator.hasNext()) {
                    LabelledFormula formula = (LabelledFormula)formulaIterator.next();
                    sink.accept(translator.apply(formula), "Automaton for " + formula);
                }
            }
            return 0;
        }

        protected abstract LtlTranslationRepository.LtlTranslation<L, A> translation();

        protected abstract Class<? extends A> acceptanceClass();

        protected Set<LtlTranslationRepository.Option> extraOptions() {
            return Set.of();
        }

        protected OptionalInt lookahead() {
            return OptionalInt.empty();
        }
    }
}

