/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnegative;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;

public final class ParityAcceptance
extends EmersonLeiAcceptance {
    private final Parity parity;

    public ParityAcceptance(@Nonnegative int colours, Parity parity) {
        super(colours);
        this.parity = parity;
    }

    @Override
    public String name() {
        return "parity";
    }

    @Override
    public List<Object> nameExtra() {
        return List.of(this.parity.maxString(), this.parity.evenString(), Integer.valueOf(this.acceptanceSets()));
    }

    @Override
    public Optional<ImmutableBitSet> acceptingSet() {
        if (this.parity.even()) {
            return this.acceptanceSets() <= 0 ? Optional.empty() : Optional.of(ImmutableBitSet.of(0));
        }
        return this.acceptanceSets() <= 1 ? Optional.empty() : Optional.of(ImmutableBitSet.of(1));
    }

    @Override
    public Optional<ImmutableBitSet> rejectingSet() {
        if (this.parity.even()) {
            return this.acceptanceSets() <= 1 ? Optional.empty() : Optional.of(ImmutableBitSet.of(1));
        }
        return this.acceptanceSets() <= 0 ? Optional.empty() : Optional.of(ImmutableBitSet.of(0));
    }

    public Parity parity() {
        return this.parity;
    }

    public ParityAcceptance withParity(Parity parity) {
        return new ParityAcceptance(this.acceptanceSets(), parity);
    }

    public ParityAcceptance complement() {
        return new ParityAcceptance(this.acceptanceSets(), this.parity.flipEven());
    }

    public boolean emptyIsAccepting() {
        return this.parity == Parity.MIN_EVEN || this.parity == Parity.MAX_ODD;
    }

    @Override
    protected PropositionalFormula<Integer> lazyBooleanExpression() {
        PropositionalFormula<Integer> exp;
        if (this.acceptanceSets() == 0) {
            return PropositionalFormula.constant(this.emptyIsAccepting());
        }
        if (this.parity.max()) {
            exp = this.mkColor(0);
            for (int i = 1; i < this.acceptanceSets(); ++i) {
                exp = this.isAccepting(i) ? PropositionalFormula.Disjunction.of(this.mkColor(i), exp) : PropositionalFormula.Conjunction.of(this.mkColor(i), exp);
            }
        } else {
            exp = this.mkColor(this.acceptanceSets() - 1);
            for (int i = this.acceptanceSets() - 2; i >= 0; --i) {
                exp = this.isAccepting(i) ? PropositionalFormula.Disjunction.of(this.mkColor(i), exp) : PropositionalFormula.Conjunction.of(this.mkColor(i), exp);
            }
        }
        return exp;
    }

    private PropositionalFormula<Integer> mkColor(int priority) {
        return this.isAccepting(priority) ? PropositionalFormula.Variable.of(priority) : PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(priority));
    }

    public boolean isAccepting(int priority) {
        return this.parity.isAccepting(priority);
    }

    public ParityAcceptance withAcceptanceSets(@Nonnegative int colours) {
        return new ParityAcceptance(colours, this.parity);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParityAcceptance that = (ParityAcceptance)o;
        return this.acceptanceSets() == that.acceptanceSets() && this.parity == that.parity;
    }

    @Override
    public int hashCode() {
        return 31 * (31 + this.acceptanceSets()) + this.parity.hashCode();
    }

    public static enum Parity {
        MIN_EVEN,
        MIN_ODD,
        MAX_EVEN,
        MAX_ODD;


        public static Parity of(boolean max, boolean even) {
            if (max && even) {
                return MAX_EVEN;
            }
            if (max) {
                return MAX_ODD;
            }
            if (even) {
                return MIN_EVEN;
            }
            return MIN_ODD;
        }

        public Parity flipMax() {
            switch (this) {
                case MIN_ODD: {
                    return MAX_ODD;
                }
                case MIN_EVEN: {
                    return MAX_EVEN;
                }
                case MAX_EVEN: {
                    return MIN_EVEN;
                }
                case MAX_ODD: {
                    return MIN_ODD;
                }
            }
            throw new AssertionError();
        }

        public Parity flipEven() {
            switch (this) {
                case MIN_ODD: {
                    return MIN_EVEN;
                }
                case MIN_EVEN: {
                    return MIN_ODD;
                }
                case MAX_EVEN: {
                    return MAX_ODD;
                }
                case MAX_ODD: {
                    return MAX_EVEN;
                }
            }
            throw new AssertionError();
        }

        public boolean even() {
            return this.equals((Object)MIN_EVEN) || this.equals((Object)MAX_EVEN);
        }

        public boolean max() {
            return this.equals((Object)MAX_EVEN) || this.equals((Object)MAX_ODD);
        }

        public Parity setEven(boolean even) {
            return even == this.even() ? this : this.flipEven();
        }

        public Parity setMax(boolean max) {
            return max == this.max() ? this : this.flipMax();
        }

        public String evenString() {
            return this.even() ? "even" : "odd";
        }

        public String maxString() {
            return this.max() ? "max" : "min";
        }

        public boolean isAccepting(int priority) {
            return priority % 2 == 0 ^ !this.even();
        }
    }
}

