/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.collections.ImmutableBitSet;
import owl.collections.NullablePair;
import owl.collections.Pair;
import owl.logic.propositional.PropositionalFormula;

public final class BooleanOperations {
    private BooleanOperations() {
    }

    public static <S> Automaton<S, ?> deterministicComplementOfCompleteAutomaton(Automaton<S, ?> completeAutomaton) {
        return BooleanOperations.deterministicComplementOfCompleteAutomaton(completeAutomaton, EmersonLeiAcceptance.class);
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<S, ? extends A> deterministicComplementOfCompleteAutomaton(Automaton<S, ?> completeAutomaton, Class<? extends A> expectedAcceptance) {
        int initialStatesSize = completeAutomaton.initialStates().size();
        Preconditions.checkArgument((initialStatesSize >= 1 ? 1 : 0) != 0, (Object)"Automaton has no initial state");
        Preconditions.checkArgument((initialStatesSize <= 1 ? 1 : 0) != 0, (Object)"Automaton has multiple initial states");
        Object acceptance = completeAutomaton.acceptance();
        EmersonLeiAcceptance complementAcceptance = null;
        if (acceptance instanceof BuchiAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(CoBuchiAcceptance.class, expectedAcceptance));
            complementAcceptance = CoBuchiAcceptance.INSTANCE;
        } else if (acceptance instanceof CoBuchiAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(BuchiAcceptance.class, expectedAcceptance));
            complementAcceptance = BuchiAcceptance.INSTANCE;
        } else if (acceptance instanceof GeneralizedBuchiAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(GeneralizedCoBuchiAcceptance.class, expectedAcceptance));
            GeneralizedBuchiAcceptance castedAcceptance = (GeneralizedBuchiAcceptance)acceptance;
            complementAcceptance = GeneralizedCoBuchiAcceptance.of(castedAcceptance.acceptanceSets());
        } else if (acceptance instanceof GeneralizedCoBuchiAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(GeneralizedBuchiAcceptance.class, expectedAcceptance));
            GeneralizedCoBuchiAcceptance castedAcceptance = (GeneralizedCoBuchiAcceptance)acceptance;
            complementAcceptance = GeneralizedBuchiAcceptance.of(castedAcceptance.acceptanceSets());
        } else if (acceptance instanceof ParityAcceptance) {
            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(ParityAcceptance.class, expectedAcceptance));
            complementAcceptance = ((ParityAcceptance)completeAutomaton.acceptance()).complement();
        } else if (OmegaAcceptanceCast.isInstanceOf(EmersonLeiAcceptance.class, expectedAcceptance)) {
            complementAcceptance = EmersonLeiAcceptance.of(PropositionalFormula.Negation.of(((EmersonLeiAcceptance)acceptance).booleanExpression()));
        }
        if (complementAcceptance == null) {
            throw new UnsupportedOperationException("Cannot complement to " + expectedAcceptance);
        }
        return OmegaAcceptanceCast.cast(new OverrideAcceptanceCondition<S, CoBuchiAcceptance>(completeAutomaton, (CoBuchiAcceptance)complementAcceptance, true), expectedAcceptance);
    }

    public static <S> Automaton<Optional<S>, ?> deterministicComplement(Automaton<S, ?> automaton) {
        return BooleanOperations.deterministicComplement(automaton, EmersonLeiAcceptance.class);
    }

    public static <S, A extends EmersonLeiAcceptance> Automaton<Optional<S>, ? extends A> deterministicComplement(Automaton<S, ?> automaton, Class<? extends A> expectedAcceptance) {
        return BooleanOperations.deterministicComplementOfCompleteAutomaton(Views.complete(automaton), expectedAcceptance);
    }

    public static <S1, S2> Automaton<Pair<S1, S2>, ?> intersection(Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2) {
        return new PairIntersectionAutomaton<S1, S2>(BooleanOperations.unifyAtomicPropositions(List.of(automaton1, automaton2)), automaton1, automaton2);
    }

    public static <S> Automaton<List<S>, ?> intersection(List<? extends Automaton<S, ?>> automata) {
        return new ListIntersectionAutomaton(BooleanOperations.unifyAtomicPropositions(automata), automata);
    }

    public static <S1, S2> Automaton<NullablePair<S1, S2>, ?> deterministicUnion(Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2) {
        Automaton<S1, Object> normalizedAutomaton1 = ((EmersonLeiAcceptance)automaton1.acceptance()).rejectingSet().isEmpty() ? OmegaAcceptanceCast.cast(new OverrideAcceptanceCondition<S1, AllAcceptance>(automaton1, AllAcceptance.INSTANCE, false), BuchiAcceptance.class) : automaton1;
        Automaton<S2, Object> normalizedAutomaton2 = ((EmersonLeiAcceptance)automaton2.acceptance()).rejectingSet().isEmpty() ? OmegaAcceptanceCast.cast(new OverrideAcceptanceCondition<S2, AllAcceptance>(automaton2, AllAcceptance.INSTANCE, false), BuchiAcceptance.class) : automaton2;
        return new NullablePairDeterministicUnionAutomaton<S1, S2>(BooleanOperations.unifyAtomicPropositions(List.of(automaton1, automaton2)), normalizedAutomaton1, normalizedAutomaton2, ((EmersonLeiAcceptance)normalizedAutomaton1.acceptance()).rejectingSet().orElseThrow(), ((EmersonLeiAcceptance)normalizedAutomaton2.acceptance()).rejectingSet().orElseThrow());
    }

    public static <S> Automaton<Map<Integer, S>, ?> deterministicUnion(List<? extends Automaton<S, ?>> automata) {
        Preconditions.checkArgument((!automata.isEmpty() ? 1 : 0) != 0, (Object)"List of automata is empty.");
        ArrayList automataCopy = new ArrayList(automata.size());
        ArrayList<ImmutableBitSet> rejectingSets = new ArrayList<ImmutableBitSet>(automata.size());
        automata.forEach(automaton -> {
            Automaton normalisedAutomaton = ((EmersonLeiAcceptance)automaton.acceptance()).rejectingSet().isEmpty() ? OmegaAcceptanceCast.cast(new OverrideAcceptanceCondition(automaton, AllAcceptance.INSTANCE, false), BuchiAcceptance.class) : automaton;
            automataCopy.add(normalisedAutomaton);
            rejectingSets.add(((EmersonLeiAcceptance)normalisedAutomaton.acceptance()).rejectingSet().orElseThrow());
        });
        return new MapDeterministicUnionAutomaton(BooleanOperations.unifyAtomicPropositions(automata), automataCopy, rejectingSets);
    }

    private static List<String> unifyAtomicPropositions(List<? extends Automaton<?, ?>> automata) {
        List<String> atomicPropositions = List.of();
        for (Automaton<?, ?> automaton : automata) {
            List<String> otherAtomicPropositions = automaton.atomicPropositions();
            if (Collections.indexOfSubList(otherAtomicPropositions, atomicPropositions) == 0) {
                atomicPropositions = otherAtomicPropositions;
                continue;
            }
            if (Collections.indexOfSubList(atomicPropositions, otherAtomicPropositions) == 0) continue;
            throw new IllegalArgumentException("Could not find shared set of atomic propositions.");
        }
        return atomicPropositions;
    }

    private static EmersonLeiAcceptance intersectionAcceptance(List<? extends EmersonLeiAcceptance> acceptanceConditions) {
        ArrayList<PropositionalFormula<Integer>> intersectionConjuncts = new ArrayList<PropositionalFormula<Integer>>();
        int intersectionAcceptanceSets = 0;
        for (EmersonLeiAcceptance emersonLeiAcceptance : acceptanceConditions) {
            int fIntersectionAcceptanceSets = intersectionAcceptanceSets;
            PropositionalFormula<Integer> shiftedExpression = emersonLeiAcceptance.booleanExpression().map(x -> x + fIntersectionAcceptanceSets);
            intersectionConjuncts.add(shiftedExpression);
            intersectionAcceptanceSets += emersonLeiAcceptance.acceptanceSets();
        }
        PropositionalFormula<Integer> intersectionExpression = PropositionalFormula.Conjunction.of(intersectionConjuncts);
        return EmersonLeiAcceptance.of(intersectionExpression);
    }

    private static EmersonLeiAcceptance unionAcceptance(List<? extends EmersonLeiAcceptance> acceptanceConditions) {
        ArrayList<PropositionalFormula<Integer>> unionDisjuncts = new ArrayList<PropositionalFormula<Integer>>();
        int unionAcceptanceSets = 0;
        for (EmersonLeiAcceptance emersonLeiAcceptance : acceptanceConditions) {
            int fUnionAcceptanceSets = unionAcceptanceSets;
            PropositionalFormula<Integer> shiftedExpression = emersonLeiAcceptance.booleanExpression().map(x -> x + fUnionAcceptanceSets);
            unionDisjuncts.add(shiftedExpression);
            unionAcceptanceSets += emersonLeiAcceptance.acceptanceSets();
        }
        PropositionalFormula<Integer> unionExpression = PropositionalFormula.Disjunction.of(unionDisjuncts);
        return EmersonLeiAcceptance.of(unionExpression);
    }

    private static final class OverrideAcceptanceCondition<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<S, A> {
        @Nullable
        private Automaton<S, ?> backingAutomaton;
        private final boolean assertComplete;

        private OverrideAcceptanceCondition(Automaton<S, ?> backingAutomaton, A acceptance, boolean assertComplete) {
            super(backingAutomaton.atomicPropositions(), backingAutomaton.factory(), backingAutomaton.initialStates(), acceptance);
            this.backingAutomaton = backingAutomaton;
            this.assertComplete = assertComplete;
            if (assertComplete && this.initialStates().isEmpty()) {
                throw new IllegalArgumentException("Automaton is not complete.");
            }
            if (this.initialStates().size() > 1) {
                throw new IllegalArgumentException("Automaton is non-deterministic.");
            }
        }

        @Override
        protected MtBdd<Edge<S>> edgeTreeImpl(S state) {
            int acceptanceSets = ((EmersonLeiAcceptance)this.acceptance()).acceptanceSets();
            return Objects.requireNonNull(this.backingAutomaton, "freezeMemoizedEdgesNotify already called.").edgeTree(state).map(edges -> {
                switch (edges.size()) {
                    case 0: {
                        if (this.assertComplete) {
                            throw new IllegalArgumentException("Automaton is not complete.");
                        }
                        return Set.of();
                    }
                    case 1: {
                        return Set.of(((Edge)edges.iterator().next()).mapAcceptance(i -> i < acceptanceSets ? i : -1));
                    }
                }
                throw new IllegalArgumentException("Automaton is not deterministic.");
            });
        }

        @Override
        protected void explorationCompleted() {
            this.backingAutomaton = null;
        }

        @Override
        public boolean is(Automaton.Property property) {
            return property == Automaton.Property.DETERMINISTIC || property == Automaton.Property.SEMI_DETERMINISTIC || this.assertComplete && property == Automaton.Property.COMPLETE || super.is(property);
        }
    }

    private static class MapDeterministicUnionAutomaton<S>
    extends AbstractMemoizingAutomaton.EdgeImplementation<Map<Integer, S>, EmersonLeiAcceptance> {
        @Nullable
        private List<? extends Automaton<S, ?>> automata;
        private final List<ImmutableBitSet> rejectingSets;

        private MapDeterministicUnionAutomaton(List<String> atomicPropositions, List<? extends Automaton<S, ?>> automata, List<ImmutableBitSet> rejectingSets) {
            super(atomicPropositions, Set.of(MapDeterministicUnionAutomaton.initialState(automata)), BooleanOperations.unionAcceptance(automata.stream().map(Automaton::acceptance).collect(Collectors.toList())));
            this.automata = List.copyOf(automata);
            this.rejectingSets = List.copyOf(rejectingSets);
        }

        private static <S> Map<Integer, S> initialState(List<? extends Automaton<S, ?>> automata) {
            HashMap<Integer, S> initialStates = new HashMap<Integer, S>();
            int s = automata.size();
            for (int i = 0; i < s; ++i) {
                Set<S> localInitialStates = automata.get(i).initialStates();
                if (localInitialStates.isEmpty()) continue;
                if (localInitialStates.size() >= 2) {
                    throw new IllegalArgumentException("Given automaton is not deterministic.");
                }
                initialStates.put(i, localInitialStates.iterator().next());
            }
            return Map.copyOf(initialStates);
        }

        @Override
        public Edge<Map<Integer, S>> edgeImpl(Map<Integer, S> state, BitSet valuation) {
            HashMap edges = new HashMap();
            state.forEach((index, localState) -> edges.put(index, this.automata.get((int)index).edge(localState, valuation)));
            return this.combine(edges);
        }

        @Nullable
        private Edge<Map<Integer, S>> combine(Map<Integer, ? extends Edge<S>> edges) {
            HashMap<Integer, S> successor = new HashMap<Integer, S>();
            BitSet acceptance = new BitSet();
            int offset = 0;
            int s = this.automata.size();
            for (int i = 0; i < s; ++i) {
                Edge<S> edge = edges.get(i);
                int offsetFinal = offset;
                if (edge == null) {
                    this.rejectingSets.get(i).forEach(set -> acceptance.set(set + offsetFinal));
                } else {
                    successor.put(i, edge.successor());
                    edge.colours().forEach(set -> acceptance.set(set + offsetFinal));
                }
                offset += ((EmersonLeiAcceptance)this.automata.get(i).acceptance()).acceptanceSets();
            }
            if (successor.isEmpty()) {
                return null;
            }
            acceptance.clear(((EmersonLeiAcceptance)this.acceptance()).acceptanceSets(), Integer.MAX_VALUE);
            return Edge.of(Map.copyOf(successor), acceptance);
        }

        @Override
        protected void explorationCompleted() {
            this.automata = null;
        }
    }

    private static class NullablePairDeterministicUnionAutomaton<S1, S2>
    extends AbstractMemoizingAutomaton.EdgeImplementation<NullablePair<S1, S2>, EmersonLeiAcceptance> {
        @Nullable
        private Automaton<S1, ?> automaton1;
        @Nullable
        private Automaton<S2, ?> automaton2;
        private final ImmutableBitSet rejectingSet1;
        private final ImmutableBitSet rejectingSet2;

        private NullablePairDeterministicUnionAutomaton(List<String> atomicPropositions, Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2, ImmutableBitSet rejectingSet1, ImmutableBitSet rejectingSet2) {
            super(atomicPropositions, Set.of(NullablePairDeterministicUnionAutomaton.initialState(automaton1, automaton2)), BooleanOperations.unionAcceptance(List.of(automaton1.acceptance(), automaton2.acceptance())));
            this.automaton1 = automaton1;
            this.automaton2 = automaton2;
            this.rejectingSet1 = rejectingSet1;
            this.rejectingSet2 = rejectingSet2;
        }

        private static <S1, S2> NullablePair<S1, S2> initialState(Automaton<? extends S1, ?> automata1, Automaton<? extends S2, ?> automata2) {
            Object initialState1 = Iterables.getOnlyElement(automata1.initialStates(), null);
            Object initialState2 = Iterables.getOnlyElement(automata2.initialStates(), null);
            return NullablePair.of(initialState1, initialState2);
        }

        @Override
        public Edge<NullablePair<S1, S2>> edgeImpl(NullablePair<S1, S2> state, BitSet valuation) {
            Edge<S1> edge1 = state.fst() == null ? null : this.automaton1.edge(state.fst(), valuation);
            Edge<S2> edge2 = state.snd() == null ? null : this.automaton2.edge(state.snd(), valuation);
            return this.combine(edge1, edge2);
        }

        @Nullable
        private Edge<NullablePair<S1, S2>> combine(@Nullable Edge<S1> edge1, @Nullable Edge<S2> edge2) {
            Object successor2;
            Object successor1;
            if (edge1 == null && edge2 == null) {
                return null;
            }
            BitSet acceptance = new BitSet();
            if (edge1 == null) {
                successor1 = null;
                this.rejectingSet1.copyInto(acceptance);
            } else {
                successor1 = edge1.successor();
                edge1.colours().copyInto(acceptance);
            }
            int offset = ((EmersonLeiAcceptance)this.automaton1.acceptance()).acceptanceSets();
            if (edge2 == null) {
                successor2 = null;
                this.rejectingSet2.forEach(i -> acceptance.set(i + offset));
            } else {
                successor2 = edge2.successor();
                edge2.colours().forEach(i -> acceptance.set(i + offset));
            }
            acceptance.clear(((EmersonLeiAcceptance)this.acceptance()).acceptanceSets(), Integer.MAX_VALUE);
            return Edge.of(NullablePair.of(successor1, successor2), acceptance);
        }

        @Override
        protected void explorationCompleted() {
            this.automaton1 = null;
            this.automaton2 = null;
        }
    }

    private static class ListIntersectionAutomaton<S>
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<List<S>, EmersonLeiAcceptance> {
        @Nullable
        private List<? extends Automaton<S, ?>> automata;

        private ListIntersectionAutomaton(List<String> atomicPropositions, List<? extends Automaton<S, ?>> automata) {
            super(atomicPropositions, ListIntersectionAutomaton.initialStates(automata), BooleanOperations.intersectionAcceptance(automata.stream().map(Automaton::acceptance).collect(Collectors.toList())));
            this.automata = List.copyOf(automata);
        }

        private static <S> Set<List<S>> initialStates(List<? extends Automaton<S, ?>> automata) {
            return Sets.cartesianProduct(automata.stream().map(Automaton::initialStates).collect(Collectors.toList()));
        }

        @Override
        protected MtBdd<Edge<List<S>>> edgeTreeImpl(List<S> state) {
            ArrayList<MtBdd<Edge<S>>> edgeTrees = new ArrayList<MtBdd<Edge<S>>>();
            int s = this.automata.size();
            for (int i = 0; i < s; ++i) {
                edgeTrees.add(this.automata.get(i).edgeTree(state.get(i)));
            }
            return MtBddOperations.cartesianProduct(edgeTrees).map(x -> x.stream().map(this::combine).collect(Collectors.toUnmodifiableSet()));
        }

        private Edge<List<S>> combine(List<? extends Edge<S>> edges) {
            ArrayList<S> successors = new ArrayList<S>();
            BitSet acceptance = new BitSet();
            int offset = 0;
            int s = this.automata.size();
            for (int i = 0; i < s; ++i) {
                int offsetFinal = offset;
                Edge<S> edge = edges.get(i);
                successors.add(edge.successor());
                edge.colours().forEach(set -> acceptance.set(set + offsetFinal));
                offset += ((EmersonLeiAcceptance)this.automata.get(i).acceptance()).acceptanceSets();
            }
            acceptance.clear(((EmersonLeiAcceptance)this.acceptance()).acceptanceSets(), Integer.MAX_VALUE);
            return Edge.of(List.copyOf(successors), acceptance);
        }

        @Override
        protected void explorationCompleted() {
            this.automata = null;
        }
    }

    private static class PairIntersectionAutomaton<S1, S2>
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<Pair<S1, S2>, EmersonLeiAcceptance> {
        @Nullable
        private Automaton<S1, ?> automaton1;
        @Nullable
        private Automaton<S2, ?> automaton2;
        private final int acceptance1Sets;

        private PairIntersectionAutomaton(List<String> atomicPropositions, Automaton<S1, ?> automaton1, Automaton<S2, ?> automaton2) {
            super(atomicPropositions, Pair.allPairs(automaton1.initialStates(), automaton2.initialStates()), BooleanOperations.intersectionAcceptance(List.of(automaton1.acceptance(), automaton2.acceptance())));
            this.automaton1 = automaton1;
            this.automaton2 = automaton2;
            this.acceptance1Sets = ((EmersonLeiAcceptance)automaton1.acceptance()).acceptanceSets();
        }

        @Override
        protected MtBdd<Edge<Pair<S1, S2>>> edgeTreeImpl(Pair<S1, S2> state) {
            MtBdd<Edge<S1>> edgeTree1 = this.automaton1.edgeTree(state.fst());
            MtBdd<Edge<S2>> edgeTree2 = this.automaton2.edgeTree(state.snd());
            return MtBddOperations.cartesianProduct(edgeTree1, edgeTree2, this::combine);
        }

        private Edge<Pair<S1, S2>> combine(Edge<? extends S1> edge1, Edge<? extends S2> edge2) {
            BitSet acceptance = edge1.colours().copyInto(new BitSet());
            edge2.colours().forEach(set -> acceptance.set(set + this.acceptance1Sets));
            acceptance.clear(((EmersonLeiAcceptance)this.acceptance()).acceptanceSets(), Integer.MAX_VALUE);
            return Edge.of(Pair.of(edge1.successor(), edge2.successor()), acceptance);
        }

        @Override
        protected void explorationCompleted() {
            this.automaton1 = null;
            this.automaton2 = null;
        }
    }
}

