/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.common.primitives.ImmutableIntArray;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CIntPointer;
import owl.cinterface.CInterface;
import owl.cinterface.DecomposedDPA;
import owl.ltl.LabelledFormula;

@CContext(value=CInterface.CDirectives.class)
public final class CDecomposedDPA {
    private static final String NAMESPACE = "decomposed_dpa_";

    private CDecomposedDPA() {
    }

    @CEntryPoint(name="decomposed_dpa_of", documentation={"Translate the given formula to a decomposed DPA.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle of(IsolateThread thread, ObjectHandle cLabelledFormula) {
        LabelledFormula formula = (LabelledFormula)ObjectHandles.getGlobal().get(cLabelledFormula);
        DecomposedDPA decomposedDPA = DecomposedDPA.of(formula);
        return ObjectHandles.getGlobal().create((Object)decomposedDPA);
    }

    @CEntryPoint(name="decomposed_dpa_automata_size", documentation={"Retrieve the number of subautomata."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static int automataSize(IsolateThread thread, ObjectHandle cDecomposedDPA) {
        return CDecomposedDPA.get((ObjectHandle)cDecomposedDPA).automata.size();
    }

    @CEntryPoint(name="decomposed_dpa_automata_get", documentation={"Retrieve the i-th subautomaton.", "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
    public static ObjectHandle automataGet(IsolateThread thread, ObjectHandle cDecomposedDPA, int index) {
        return ObjectHandles.getGlobal().create(CDecomposedDPA.get((ObjectHandle)cDecomposedDPA).automata.get(index));
    }

    @CEntryPoint(name="decomposed_dpa_declare_realizability_status", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
    public static boolean declareRealizabilityStatus(IsolateThread thread, ObjectHandle cDecomposedDPA, RealizabilityStatus status, CIntPointer cDecomposedState, int numberOfStates) {
        DecomposedDPA decomposedDPA = (DecomposedDPA)ObjectHandles.getGlobal().get(cDecomposedDPA);
        return decomposedDPA.declare(status, cDecomposedState, numberOfStates);
    }

    @CEntryPoint(name="decomposed_dpa_query_realizability_status", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnRealizabilityStatus.class)
    public static RealizabilityStatus queryRealizabilityStatus(IsolateThread thread, ObjectHandle cDecomposedDPA, CIntPointer cDecomposedState, int numberOfStates) {
        DecomposedDPA decomposedDPA = (DecomposedDPA)ObjectHandles.getGlobal().get(cDecomposedDPA);
        return decomposedDPA.query(cDecomposedState, numberOfStates);
    }

    private static DecomposedDPA get(ObjectHandle cDecomposedDPA) {
        return (DecomposedDPA)ObjectHandles.getGlobal().get(cDecomposedDPA);
    }

    public static final class Structure {
        private static final String NAMESPACE = "decomposed_dpa_structure_";

        private Structure() {
        }

        @CEntryPoint(name="decomposed_dpa_structure_get", documentation={"This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
        public static ObjectHandle createStructureHandle(IsolateThread thread, ObjectHandle cDecomposedDPA) {
            DecomposedDPA decomposedDPA = (DecomposedDPA)ObjectHandles.getGlobal().get(cDecomposedDPA);
            return ObjectHandles.getGlobal().create((Object)decomposedDPA.structure);
        }

        @CEntryPoint(name="decomposed_dpa_structure_node_type", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnNodeType.class)
        public static NodeType nodeType(IsolateThread thread, ObjectHandle cLabelledTree) {
            DecomposedDPA.Tree node = Structure.get(cLabelledTree);
            if (node instanceof DecomposedDPA.Tree.Leaf) {
                return NodeType.AUTOMATON;
            }
            return ((DecomposedDPA.Tree.Node)node).label;
        }

        @CEntryPoint(name="decomposed_dpa_structure_children", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
        public static int getNumberOfChildren(IsolateThread thread, ObjectHandle cLabelledTree) {
            return Structure.getNode((ObjectHandle)cLabelledTree).children.size();
        }

        @CEntryPoint(name="decomposed_dpa_structure_get_child", documentation={"This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
        public static ObjectHandle getChild(IsolateThread thread, ObjectHandle cLabelledTree, int index) {
            return ObjectHandles.getGlobal().create((Object)Structure.getNode((ObjectHandle)cLabelledTree).children.get(index));
        }

        @CEntryPoint(name="decomposed_dpa_structure_referenced_automaton", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
        public static int getReferencedAutomaton(IsolateThread thread, ObjectHandle cLabelledTree) {
            return Structure.getLeaf((ObjectHandle)cLabelledTree).index;
        }

        @CEntryPoint(name="decomposed_dpa_structure_referenced_formula", documentation={"This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer."}, exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnObjectHandle.class)
        public static ObjectHandle createFormulaObjectHandle(IsolateThread thread, ObjectHandle cLabelledTree) {
            return ObjectHandles.getGlobal().create((Object)Structure.getLeaf((ObjectHandle)cLabelledTree).formula);
        }

        @CEntryPoint(name="decomposed_dpa_structure_referenced_alphabet_mapping", exceptionHandler=CInterface.PrintStackTraceAndExit.ReturnInt.class)
        public static int alphabetMapping(IsolateThread thread, ObjectHandle cLabelledTree, int i) {
            int value;
            ImmutableIntArray mapping = Structure.getLeaf((ObjectHandle)cLabelledTree).globalToLocalMapping;
            if (i < mapping.length() && (value = mapping.get(i)) >= 0) {
                return value;
            }
            return -1;
        }

        private static DecomposedDPA.Tree get(ObjectHandle cDeterministicAutomaton) {
            return (DecomposedDPA.Tree)ObjectHandles.getGlobal().get(cDeterministicAutomaton);
        }

        private static DecomposedDPA.Tree.Leaf getLeaf(ObjectHandle cDeterministicAutomaton) {
            return (DecomposedDPA.Tree.Leaf)ObjectHandles.getGlobal().get(cDeterministicAutomaton);
        }

        private static DecomposedDPA.Tree.Node getNode(ObjectHandle cDeterministicAutomaton) {
            return (DecomposedDPA.Tree.Node)ObjectHandles.getGlobal().get(cDeterministicAutomaton);
        }

        @CEnum(value="node_type_t")
        public static enum NodeType {
            AUTOMATON,
            BICONDITIONAL,
            CONJUNCTION,
            DISJUNCTION;


            @CEnumValue
            public native int getCValue();

            @CEnumLookup
            public static native NodeType fromCValue(int var0);
        }
    }

    @CEnum(value="realizability_status_t")
    public static enum RealizabilityStatus {
        REALIZABLE,
        UNREALIZABLE,
        UNKNOWN;


        @CEnumValue
        public native int getCValue();

        @CEnumLookup
        public static native RealizabilityStatus fromCValue(int var0);
    }
}

