/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.BitSet;
import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.DefaultImplementations;
import owl.automaton.EdgeMapAutomatonMixin;
import owl.automaton.EdgeTreeAutomatonMixin;
import owl.automaton.EdgesAutomatonMixin;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.factories.ValuationSetFactory;

public abstract class AbstractImmutableAutomaton<S, A extends OmegaAcceptance>
implements Automaton<S, A> {
    protected final A acceptance;
    protected final Set<S> initialStates;
    protected final ValuationSetFactory factory;
    @Nullable
    private Set<S> statesCache;

    public AbstractImmutableAutomaton(ValuationSetFactory factory, Set<S> initialStates, A acceptance) {
        this.factory = factory;
        this.acceptance = acceptance;
        this.initialStates = Set.copyOf(initialStates);
    }

    @Override
    public final A acceptance() {
        return this.acceptance;
    }

    @Override
    public final ValuationSetFactory factory() {
        return this.factory;
    }

    @Override
    public final S onlyInitialState() {
        return Automaton.super.onlyInitialState();
    }

    @Override
    public final Set<S> initialStates() {
        return this.initialStates;
    }

    @Override
    public final Set<S> states() {
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(DefaultImplementations.getReachableStates(this));
        }
        return this.statesCache;
    }

    @Override
    public final void accept(Automaton.EdgeVisitor<S> visitor) {
        Set<S> exploredStates = DefaultImplementations.visit(this, visitor);
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(exploredStates);
        }
    }

    @Override
    public final void accept(Automaton.EdgeMapVisitor<S> visitor) {
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(DefaultImplementations.visit(this, visitor));
        } else {
            for (S state : this.statesCache) {
                visitor.enter(state);
                visitor.visit(state, this.edgeMap(state));
                visitor.exit(state);
            }
        }
    }

    @Override
    public final void accept(Automaton.EdgeTreeVisitor<S> visitor) {
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(DefaultImplementations.visit(this, visitor));
        } else {
            for (S state : this.statesCache) {
                visitor.enter(state);
                visitor.visit(state, this.edgeTree(state));
                visitor.exit(state);
            }
        }
    }

    @Nullable
    protected final Set<S> cache() {
        return this.statesCache;
    }

    public static abstract class SemiDeterministicEdgesAutomaton<S, A extends OmegaAcceptance>
    extends AbstractImmutableAutomaton<S, A>
    implements EdgesAutomatonMixin<S, A> {
        public SemiDeterministicEdgesAutomaton(ValuationSetFactory factory, Set<S> initialStates, A acceptance) {
            super(factory, initialStates, acceptance);
        }

        @Override
        public abstract Edge<S> edge(S var1, BitSet var2);

        @Override
        public final Set<Edge<S>> edges(S state, BitSet valuation) {
            return Collections3.ofNullable(this.edge(state, valuation));
        }

        @Override
        public final boolean is(Automaton.Property property) {
            return property == Automaton.Property.SEMI_DETERMINISTIC || property == Automaton.Property.LIMIT_DETERMINISTIC || super.is(property);
        }
    }

    public static abstract class NonDeterministicEdgeTreeAutomaton<S, A extends OmegaAcceptance>
    extends AbstractImmutableAutomaton<S, A>
    implements EdgeTreeAutomatonMixin<S, A> {
        public NonDeterministicEdgeTreeAutomaton(ValuationSetFactory factory, Set<S> initialStates, A acceptance) {
            super(factory, initialStates, acceptance);
        }
    }

    public static abstract class NonDeterministicEdgeMapAutomaton<S, A extends OmegaAcceptance>
    extends AbstractImmutableAutomaton<S, A>
    implements EdgeMapAutomatonMixin<S, A> {
        public NonDeterministicEdgeMapAutomaton(ValuationSetFactory factory, Set<S> initialStates, A acceptance) {
            super(factory, initialStates, acceptance);
        }
    }

    public static abstract class NonDeterministicEdgesAutomaton<S, A extends OmegaAcceptance>
    extends AbstractImmutableAutomaton<S, A>
    implements EdgesAutomatonMixin<S, A> {
        public NonDeterministicEdgesAutomaton(ValuationSetFactory factory, Set<S> initialStates, A acceptance) {
            super(factory, initialStates, acceptance);
        }
    }
}

