/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class PowerIterator
implements Iterator<BitSet> {
    private final BitSet iteration;
    private final int size;
    private int numSetBits = -1;

    PowerIterator(int size) {
        this.size = size;
        this.iteration = new BitSet(size);
    }

    @Override
    public boolean hasNext() {
        return this.numSetBits < this.size;
    }

    @Override
    public BitSet next() {
        if (this.numSetBits == -1) {
            this.numSetBits = 0;
            return this.iteration;
        }
        if (this.numSetBits == this.size) {
            throw new NoSuchElementException("No next element");
        }
        for (int index = 0; index < this.size; ++index) {
            if (this.iteration.get(index)) {
                this.iteration.clear(index);
                --this.numSetBits;
                continue;
            }
            this.iteration.set(index);
            ++this.numSetBits;
            break;
        }
        return this.iteration;
    }
}

