/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import java.util.Random;

final class HashUtil {
    private static final int BYTE_MASK = 255;
    private static final int FNV_OFFSET = -2128831035;
    private static final int FNV_PRIME = 16777619;
    private static final int MURMUR3_C2 = 461845907;
    private static final int MURMUR3_C1 = -862048943;
    static final int MURMUR3_SEED = new Random().nextInt();

    private HashUtil() {
    }

    static int hash(int key) {
        return HashUtil.murmur3Hash(key);
    }

    static int hash(long key) {
        return HashUtil.murmur3Hash(key);
    }

    static int hash(long firstKey, int secondKey) {
        return HashUtil.murmur3Hash(firstKey, secondKey);
    }

    static int hash(long firstKey, long secondKey) {
        return HashUtil.murmur3Hash(firstKey, secondKey);
    }

    static int hash(int key, int[] keys) {
        return HashUtil.murmur3Hash(key, keys);
    }

    static int murmur3Hash(int key) {
        int h = MURMUR3_SEED;
        h = HashUtil.murmur3round(h, key);
        return HashUtil.murmur3mix(h ^= 4);
    }

    static int murmur3Hash(long key) {
        int h = MURMUR3_SEED;
        h = HashUtil.murmur3round(h, (int)(key >>> 32));
        h = HashUtil.murmur3round(h, (int)key);
        return HashUtil.murmur3mix(h ^= 8);
    }

    static int murmur3Hash(long firstKey, int secondKey) {
        int h = MURMUR3_SEED;
        h = HashUtil.murmur3round(h, (int)(firstKey >>> 32));
        h = HashUtil.murmur3round(h, (int)firstKey);
        h = HashUtil.murmur3round(h, secondKey);
        return HashUtil.murmur3mix(h ^= 0xC);
    }

    static int murmur3Hash(long firstKey, long secondKey) {
        int h = MURMUR3_SEED;
        h = HashUtil.murmur3round(h, (int)(firstKey >>> 32));
        h = HashUtil.murmur3round(h, (int)firstKey);
        h = HashUtil.murmur3round(h, (int)(secondKey >>> 32));
        h = HashUtil.murmur3round(h, (int)secondKey);
        return HashUtil.murmur3mix(h ^= 0x10);
    }

    static int murmur3Hash(int key, int[] keys) {
        int h = MURMUR3_SEED;
        h = HashUtil.murmur3round(h, key);
        for (int k : keys) {
            h = HashUtil.murmur3round(h, k);
        }
        return HashUtil.murmur3mix(h ^= 4 * keys.length + 4);
    }

    private static int murmur3round(int h, int k) {
        int key = k;
        key *= -862048943;
        key = key << 15 | key >>> 17;
        int hash = h;
        hash ^= (key *= 461845907);
        hash = hash << 13 | hash >>> 19;
        return hash * 5 + -430675100;
    }

    private static int murmur3mix(int h) {
        int mix = h;
        mix ^= mix >>> 16;
        mix *= -2048144789;
        mix ^= mix >>> 13;
        mix *= -1028477387;
        mix ^= mix >>> 16;
        return mix;
    }

    static int fnv1aHash(int key) {
        return HashUtil.fnv1aRound(-2128831035, key);
    }

    static int fnv1aHash(long key) {
        return HashUtil.fnv1aRound(-2128831035, key);
    }

    static int fnv1aHash(long firstKey, int secondKey) {
        return HashUtil.fnv1aRound(HashUtil.fnv1aRound(-2128831035, firstKey), secondKey);
    }

    static int fnv1aHash(long firstKey, long secondKey) {
        return HashUtil.fnv1aRound(HashUtil.fnv1aRound(-2128831035, firstKey), secondKey);
    }

    static int fnv1aHash(int key, int[] keys) {
        int hash = HashUtil.fnv1aRound(-2128831035, key);
        for (int arrayKey : keys) {
            hash = HashUtil.fnv1aRound(hash, arrayKey);
        }
        return hash;
    }

    private static int fnv1aRound(int h, int k) {
        return ((((h ^ k >>> 24 & 0xFF) * 16777619 ^ k >>> 16 & 0xFF) * 16777619 ^ k >>> 8 & 0xFF) * 16777619 ^ k & 0xFF) * 16777619;
    }

    private static int fnv1aRound(int h, long k) {
        return HashUtil.fnv1aRound(HashUtil.fnv1aRound(h, (int)(k >>> 32)), (int)k);
    }
}

