/*
 * Decompiled with CFR 0.152.
 */
package owl.game;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import de.tum.in.naturals.Indices;
import de.tum.in.naturals.bitset.BitSets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.EdgeMapAutomatonMixin;
import owl.automaton.Views;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.game.AutoValue_GameViews_Node;
import owl.game.Game;
import owl.run.modules.OwlModule;

public final class GameViews {
    public static final OwlModule<OwlModule.Transformer> AUTOMATON_TO_GAME_MODULE = OwlModule.of("aut2game", "Converts an automaton into a game by splitting the transitions", () -> {
        Option environmentPropositions = new Option("e", "environment", true, "List of atomic propositions controlled by the environment");
        Option systemPropositions = new Option("s", "system", true, "List of atomic propositions controlled by the system");
        Option environmentPrefixes = new Option(null, "envprefix", true, "Prefixes of environment APs (defaults to i)");
        Option systemPrefixes = new Option(null, "sysprefix", true, "Prefixes of system APs");
        Option complete = new Option("c", "complete", false, "Make automaton complete (may decrease performance)");
        OptionGroup apGroup = new OptionGroup().addOption(environmentPropositions).addOption(environmentPrefixes).addOption(systemPropositions).addOption(systemPrefixes);
        apGroup.getOptions().forEach(option -> option.setArgs(-2));
        return new Options().addOptionGroup(apGroup).addOption(complete);
    }, (commandLine, environment) -> {
        Predicate<String> isEnvironmentAp;
        String[] environmentPropositions = commandLine.getOptionValues("environment");
        String[] systemPropositions = commandLine.getOptionValues("system");
        String[] environmentPrefixes = commandLine.getOptionValues("envprefix");
        String[] systemPrefixes = commandLine.getOptionValues("sysprefix");
        if (environmentPropositions != null) {
            List<String> environmentAPs = List.of(environmentPropositions);
            isEnvironmentAp = environmentAPs::contains;
        } else if (systemPropositions != null) {
            List<String> systemAPs = List.of(systemPropositions);
            isEnvironmentAp = ((Predicate<String>)systemAPs::contains).negate();
        } else {
            isEnvironmentAp = environmentPrefixes != null ? ap -> Arrays.stream(environmentPrefixes).anyMatch(ap::startsWith) : (systemPrefixes != null ? ap -> Arrays.stream(systemPrefixes).noneMatch(ap::startsWith) : ap -> ap.charAt(0) == 'i');
        }
        boolean wrapComplete = commandLine.hasOption("complete");
        return OwlModule.AutomatonTransformer.of(automaton -> {
            Object parityAutomaton = automaton;
            if (wrapComplete) {
                parityAutomaton = OmegaAcceptanceCast.cast(Views.complete(parityAutomaton, new Object()), ParityAcceptance.class);
            }
            return GameViews.split(parityAutomaton, isEnvironmentAp);
        }, ParityAcceptance.class);
    });

    private GameViews() {
    }

    public static <S, A extends OmegaAcceptance> Game<S, A> filter(Game<S, A> game, Predicate<S> states) {
        return new FilteredGame<S, A>(game, states, x -> true);
    }

    public static <S, A extends OmegaAcceptance> Game<S, A> filter(Game<S, A> game, Predicate<S> states, Predicate<Edge<S>> edgeFilter) {
        return new FilteredGame<S, A>(game, states, edgeFilter);
    }

    public static <S, A extends OmegaAcceptance> Game<Node<S>, A> split(Automaton<S, A> automaton, Collection<String> firstPropositions) {
        return new ForwardingGame<S, A>(automaton, firstPropositions::contains);
    }

    public static <S, A extends OmegaAcceptance> Game<Node<S>, A> split(Automaton<S, A> automaton, Predicate<String> firstPropositions) {
        assert (automaton.is(Automaton.Property.COMPLETE)) : "Only defined for complete automata.";
        return new ForwardingGame<S, A>(automaton, firstPropositions);
    }

    public static <S, A extends OmegaAcceptance> Game<S, A> replaceInitialStates(final Game<S, A> game, Set<S> initialStates) {
        final Set<S> immutableInitialStates = Set.copyOf(initialStates);
        return new Game<S, A>(){

            @Override
            public A acceptance() {
                return game.acceptance();
            }

            @Override
            public ValuationSetFactory factory() {
                return game.factory();
            }

            @Override
            public Set<S> initialStates() {
                return immutableInitialStates;
            }

            @Override
            public Set<S> states() {
                return game.states();
            }

            @Override
            public Set<Edge<S>> edges(S state, BitSet valuation) {
                return game.edges(state, valuation);
            }

            @Override
            public Set<Edge<S>> edges(S state) {
                return game.edges(state);
            }

            @Override
            public Map<Edge<S>, ValuationSet> edgeMap(S state) {
                return game.edgeMap(state);
            }

            @Override
            public ValuationTree<Edge<S>> edgeTree(S state) {
                throw new UnsupportedOperationException("Class deprecated.");
            }

            @Override
            public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
                return game.preferredEdgeAccess();
            }

            @Override
            public Game.Owner owner(S state) {
                return game.owner(state);
            }

            @Override
            public BitSet choice(S state, Game.Owner owner) {
                return game.choice(state, owner);
            }

            @Override
            public List<String> variables(Game.Owner owner) {
                return game.variables(owner);
            }
        };
    }

    @AutoValue
    public static abstract class Node<S>
    implements AnnotatedState<S> {
        @Override
        public abstract S state();

        @Nullable
        abstract BitSet firstPlayerChoice();

        static <S> Node<S> of(S state) {
            return new AutoValue_GameViews_Node<S>(state, null);
        }

        static <S> Node<S> of(S state, BitSet choice) {
            return new AutoValue_GameViews_Node<S>(state, BitSets.copyOf((BitSet)choice));
        }

        public abstract boolean equals(Object var1);

        @Memoized
        public abstract int hashCode();

        public String toString() {
            return this.isFirstPlayersTurn() ? String.format("1:%s", this.state()) : String.format("2%s:%s", this.firstPlayerChoice(), this.state());
        }

        boolean isFirstPlayersTurn() {
            return this.firstPlayerChoice() == null;
        }
    }

    static final class ForwardingGame<S, A extends OmegaAcceptance>
    implements Game<Node<S>, A>,
    EdgeMapAutomatonMixin<Node<S>, A> {
        private final Automaton<S, A> automaton;
        private final BitSet firstPlayer;
        private final BitSet secondPlayer;

        ForwardingGame(Automaton<S, A> automaton, Predicate<String> firstPlayer) {
            this.automaton = automaton;
            this.firstPlayer = new BitSet();
            ListIterator<String> iterator = automaton.factory().atomicPropositions().listIterator();
            while (iterator.hasNext()) {
                int index = iterator.nextIndex();
                String next = iterator.next();
                if (!firstPlayer.test(next)) continue;
                this.firstPlayer.set(index);
            }
            this.secondPlayer = BitSets.copyOf((BitSet)this.firstPlayer);
            this.secondPlayer.flip(0, automaton.factory().atomicPropositions().size());
        }

        @Override
        public A acceptance() {
            return this.automaton.acceptance();
        }

        @Override
        public ValuationSetFactory factory() {
            return this.automaton.factory();
        }

        @Override
        public Set<Node<S>> initialStates() {
            return Collections3.transformSet(this.automaton.initialStates(), Node::of);
        }

        @Override
        public Map<Edge<Node<S>>, ValuationSet> edgeMap(Node<S> node) {
            HashMap<Edge<Node<S>>, ValuationSet> edges = new HashMap<Edge<Node<S>>, ValuationSet>();
            ValuationSetFactory factory = this.automaton.factory();
            if (node.isFirstPlayersTurn()) {
                for (BitSet valuation : BitSets.powerSet((BitSet)this.firstPlayer)) {
                    ValuationSet valuationSet = factory.of(valuation, this.firstPlayer);
                    edges.merge(Edge.of(Node.of(node.state(), valuation)), valuationSet, ValuationSet::union);
                }
            } else {
                for (BitSet valuation : BitSets.powerSet((BitSet)this.secondPlayer)) {
                    ValuationSet vs = factory.of(valuation, this.secondPlayer);
                    BitSet joined = BitSets.copyOf((BitSet)valuation);
                    joined.or(node.firstPlayerChoice());
                    Edge<S> edge = this.automaton.edge(node.state(), joined);
                    Preconditions.checkNotNull(edge, (String)"Automaton not complete in state %s with valuation %s", node.state(), (Object)joined);
                    edges.merge(edge.withSuccessor(Node.of(edge.successor())), vs, ValuationSet::union);
                }
            }
            return edges;
        }

        @Override
        public Game.Owner owner(Node<S> state) {
            return state.isFirstPlayersTurn() ? Game.Owner.PLAYER_1 : Game.Owner.PLAYER_2;
        }

        @Override
        public Set<Node<S>> predecessors(Node<S> successor) {
            if (!successor.isFirstPlayersTurn()) {
                return Set.of(Node.of(successor.state()));
            }
            HashSet<Node<S>> predecessors = new HashSet<Node<S>>();
            for (S predecessor : this.automaton.states()) {
                this.automaton.edgeMap(predecessor).forEach((edge, valuations) -> {
                    if (successor.state().equals(edge.successor())) {
                        valuations.forEach(set -> {
                            BitSet localSet = BitSets.copyOf((BitSet)set);
                            localSet.and(this.firstPlayer);
                            predecessors.add(Node.of(predecessor, localSet));
                        });
                    }
                });
            }
            return predecessors;
        }

        @Override
        public Set<Node<S>> predecessors(Node<S> state, Game.Owner owner) {
            return owner == this.owner(state) ? Set.of() : this.predecessors(state);
        }

        @Override
        public Set<Node<S>> states() {
            HashSet<Node<S>> states = new HashSet<Node<S>>();
            this.automaton.states().forEach(state -> {
                Node<Object> node = Node.of(state);
                states.add(node);
                for (BitSet valuation : BitSets.powerSet((BitSet)this.firstPlayer)) {
                    states.add(Node.of(state, valuation));
                }
            });
            return states;
        }

        @Override
        public List<String> variables(Game.Owner owner) {
            ArrayList<String> variables = new ArrayList<String>();
            Indices.forEachIndexed(this.factory().atomicPropositions(), (i, s) -> {
                if (owner == Game.Owner.PLAYER_1 ^ !this.firstPlayer.get(i)) {
                    variables.add((String)s);
                }
            });
            return variables;
        }

        public String toString() {
            return "Arena: " + this.firstPlayer + "/" + this.secondPlayer + "\n" + this.automaton;
        }

        @Override
        public BitSet choice(Node<S> state, Game.Owner owner) {
            Preconditions.checkArgument((state.firstPlayerChoice() != null ? 1 : 0) != 0, (Object)"The state has no encoded choice.");
            if (owner == Game.Owner.PLAYER_1) {
                BitSet choice = state.firstPlayerChoice();
                assert (choice != null);
                return BitSets.copyOf((BitSet)choice);
            }
            ValuationSet valuationSet = (ValuationSet)((Map.Entry)Iterables.getOnlyElement(this.edgeMap(state).entrySet())).getValue();
            return valuationSet.factory().iterator(valuationSet).next();
        }
    }

    private static final class FilteredGame<S, A extends OmegaAcceptance>
    implements Game<S, A>,
    EdgeMapAutomatonMixin<S, A> {
        private final Automaton<S, A> filteredAutomaton;
        private final Function<S, Game.Owner> ownership;
        private final Function<Game.Owner, List<String>> variableOwnership;
        private final BiFunction<S, Game.Owner, BitSet> choice;

        FilteredGame(Game<S, A> game, Predicate<S> states, Predicate<Edge<S>> edgeFilter) {
            this.filteredAutomaton = Views.filtered(game, Views.Filter.of(states, (s, e) -> edgeFilter.test((Edge)e)));
            this.ownership = game::owner;
            this.variableOwnership = game::variables;
            this.choice = game::choice;
        }

        @Override
        public BitSet choice(S state, Game.Owner owner) {
            return this.choice.apply(state, owner);
        }

        @Override
        public A acceptance() {
            return this.filteredAutomaton.acceptance();
        }

        @Override
        public Set<S> initialStates() {
            return this.filteredAutomaton.initialStates();
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            return this.filteredAutomaton.edgeMap(state);
        }

        @Override
        public Game.Owner owner(S state) {
            return this.ownership.apply(state);
        }

        @Override
        public List<String> variables(Game.Owner owner) {
            return this.variableOwnership.apply(owner);
        }

        @Override
        public ValuationSetFactory factory() {
            return this.filteredAutomaton.factory();
        }

        @Override
        public Set<S> predecessors(S successor) {
            return this.filteredAutomaton.predecessors(successor);
        }

        @Override
        public Set<S> successors(S state) {
            return this.filteredAutomaton.successors(state);
        }

        @Override
        public Set<S> states() {
            return this.filteredAutomaton.states();
        }
    }
}

