/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract class Either<A, B> {
    private Either() {
    }

    public abstract <C> C either(Function<? super A, ? extends C> var1, Function<? super B, ? extends C> var2);

    public static <A, B> Either<A, B> left(A value) {
        return new EitherA(value);
    }

    public static <A, B> Either<A, B> right(B value) {
        return new EitherB(value);
    }

    public Optional<A> fromLeft() {
        return this.either(Optional::of, value -> Optional.empty());
    }

    public Optional<B> fromRight() {
        return this.either(value -> Optional.empty(), Optional::of);
    }

    public boolean isLeft() {
        return this.fromLeft().isPresent();
    }

    public boolean isRight() {
        return this.fromRight().isPresent();
    }

    private static final class EitherB<A, B>
    extends Either<A, B> {
        private final B value;

        private EitherB(B value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public <C> C either(Function<? super A, ? extends C> left, Function<? super B, ? extends C> right) {
            return right.apply(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EitherB)) {
                return false;
            }
            return this.value.equals(((EitherB)o).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "B[" + this.value + "]";
        }
    }

    private static final class EitherA<A, B>
    extends Either<A, B> {
        private final A value;

        private EitherA(A value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public <C> C either(Function<? super A, ? extends C> left, Function<? super B, ? extends C> right) {
            return left.apply(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EitherA)) {
                return false;
            }
            return this.value.equals(((EitherA)o).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "A[" + this.value + "]";
        }
    }
}

