/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.DefaultImplementations;
import owl.automaton.acceptance.OmegaAcceptance;

public abstract class AbstractCachedStatesAutomaton<S, A extends OmegaAcceptance>
implements Automaton<S, A> {
    @Nullable
    private Set<S> statesCache;

    @Override
    public final Set<S> states() {
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(DefaultImplementations.getReachableStates(this));
        }
        return this.statesCache;
    }

    @Override
    public final void accept(Automaton.EdgeVisitor<S> visitor) {
        Set<S> exploredStates = DefaultImplementations.visit(this, visitor);
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(exploredStates);
        }
    }

    @Override
    public final void accept(Automaton.EdgeMapVisitor<S> visitor) {
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(DefaultImplementations.visit(this, visitor));
        } else {
            for (S state : this.statesCache) {
                visitor.enter(state);
                visitor.visit(state, this.edgeMap(state));
                visitor.exit(state);
            }
        }
    }

    @Override
    public final void accept(Automaton.EdgeTreeVisitor<S> visitor) {
        if (this.statesCache == null) {
            this.statesCache = Set.copyOf(DefaultImplementations.visit(this, visitor));
        } else {
            for (S state : this.statesCache) {
                visitor.enter(state);
                visitor.visit(state, this.edgeTree(state));
                visitor.exit(state);
            }
        }
    }

    @Nullable
    protected final Set<S> cache() {
        return this.statesCache;
    }
}

