/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddCache;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.ImmutableBddConfiguration;
import de.tum.in.jbdd.MathUtil;
import de.tum.in.jbdd.NodeTable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;

class BddImpl
extends NodeTable
implements Bdd {
    private static final int FALSE_NODE = 0;
    private static final int TRUE_NODE = 1;
    private final BddCache cache = new BddCache(this);
    private int numberOfVariables;
    private int[] variableNodes;

    BddImpl(int nodeSize) {
        this(nodeSize, ImmutableBddConfiguration.builder().build());
    }

    BddImpl(int nodeSize, BddConfiguration configuration) {
        super(MathUtil.nextPrime(nodeSize), configuration);
        this.variableNodes = new int[configuration.initialVariableNodes()];
        this.numberOfVariables = 0;
    }

    private static boolean isVariableOrNegatedStore(long nodeStore) {
        int low = (int)BddImpl.getLowFromStore(nodeStore);
        int high = (int)BddImpl.getHighFromStore(nodeStore);
        return low == 0 && high == 1 || low == 1 && high == 0;
    }

    @Override
    public int getTrueNode() {
        return 1;
    }

    @Override
    public int getFalseNode() {
        return 0;
    }

    @Override
    public int numberOfVariables() {
        return this.numberOfVariables;
    }

    @Override
    public int getVariableNode(int variableNumber) {
        assert (0 <= variableNumber && variableNumber < this.numberOfVariables);
        return this.variableNodes[variableNumber];
    }

    @Override
    public int createVariable() {
        int variableNode = this.saturateNode(this.makeNode(this.numberOfVariables, 0, 1));
        int notVariableNode = this.saturateNode(this.makeNode(this.numberOfVariables, 1, 0));
        if (this.numberOfVariables == this.variableNodes.length) {
            this.variableNodes = Arrays.copyOf(this.variableNodes, this.variableNodes.length * 2);
        }
        this.variableNodes[this.numberOfVariables] = variableNode;
        ++this.numberOfVariables;
        this.cache.putNot(variableNode, notVariableNode);
        this.cache.putNot(notVariableNode, variableNode);
        this.growTree(this.numberOfVariables);
        this.cache.invalidateSatisfaction();
        this.cache.invalidateCompose();
        this.cache.reallocateVolatile();
        return variableNode;
    }

    @Override
    public int[] createVariables(int count) {
        int newSize = this.numberOfVariables + count;
        if (newSize >= this.variableNodes.length) {
            this.variableNodes = Arrays.copyOf(this.variableNodes, Math.max(this.variableNodes.length * 2, newSize));
        }
        int[] variableNodes = new int[count];
        for (int i = 0; i < count; ++i) {
            int variable = this.numberOfVariables + i;
            int variableNode = this.saturateNode(this.makeNode(variable, 0, 1));
            int notVariableNode = this.saturateNode(this.makeNode(variable, 1, 0));
            variableNodes[i] = variableNode;
            this.variableNodes[variable] = variableNode;
            this.cache.putNot(variableNode, notVariableNode);
            this.cache.putNot(notVariableNode, variableNode);
        }
        this.numberOfVariables += count;
        this.growTree(this.numberOfVariables);
        this.cache.invalidateSatisfaction();
        this.cache.invalidateCompose();
        this.cache.reallocateVolatile();
        return variableNodes;
    }

    @Override
    public boolean isVariable(int node) {
        if (this.isNodeRoot(node)) {
            return false;
        }
        long nodeStore = this.getNodeStore(node);
        return (int)BddImpl.getLowFromStore(nodeStore) == 0 && (int)BddImpl.getHighFromStore(nodeStore) == 1;
    }

    @Override
    public boolean isVariableNegated(int node) {
        if (this.isNodeRoot(node)) {
            return false;
        }
        long nodeStore = this.getNodeStore(node);
        return (int)BddImpl.getLowFromStore(nodeStore) == 1 && (int)BddImpl.getHighFromStore(nodeStore) == 0;
    }

    @Override
    public boolean isVariableOrNegated(int node) {
        assert (this.isNodeValidOrRoot(node));
        if (this.isNodeRoot(node)) {
            return false;
        }
        long nodeStore = this.getNodeStore(node);
        return BddImpl.isVariableOrNegatedStore(nodeStore);
    }

    @Override
    public boolean evaluate(int node, BitSet assignment) {
        int currentBdd = node;
        while (currentBdd >= 2) {
            long currentBddStore = this.getNodeStore(currentBdd);
            int currentBddVariable = (int)BddImpl.getVariableFromStore(currentBddStore);
            if (assignment.get(currentBddVariable)) {
                currentBdd = (int)BddImpl.getHighFromStore(currentBddStore);
                continue;
            }
            currentBdd = (int)BddImpl.getLowFromStore(currentBddStore);
        }
        return currentBdd == 1;
    }

    @Override
    public BitSet getSatisfyingAssignment(int node) {
        assert (this.isNodeValidOrRoot(node));
        if (node == 1) {
            return new BitSet(0);
        }
        if (node == 0) {
            throw new IllegalArgumentException("False has no solution");
        }
        BitSet path = new BitSet(this.numberOfVariables);
        this.getSatisfyingAssignmentRecursive(node, path);
        return path;
    }

    private void getSatisfyingAssignmentRecursive(int node, BitSet path) {
        if (node == 1) {
            return;
        }
        long store = this.getNodeStore(node);
        int lowNode = (int)BddImpl.getLowFromStore(store);
        if (lowNode == 0) {
            int highNode = (int)BddImpl.getHighFromStore(store);
            int variable = (int)BddImpl.getVariableFromStore(store);
            path.set(variable);
            this.getSatisfyingAssignmentRecursive(highNode, path);
        } else {
            this.getSatisfyingAssignmentRecursive(lowNode, path);
        }
    }

    @Override
    public Iterator<BitSet> solutionIterator(int node) {
        if (node == 0) {
            return Collections.emptyIterator();
        }
        if (node == 1) {
            return new PowerIterator(this.numberOfVariables);
        }
        return new NodeSolutionIterator(this, node);
    }

    @Override
    public void forEachNonEmptyPath(int node, int highestVariable, BiConsumer<BitSet, BitSet> action) {
        int highestRecursive;
        int bitSetSize;
        assert (this.isNodeValidOrRoot(node) && highestVariable >= 0);
        if (node == 0) {
            return;
        }
        if (node == 1) {
            action.accept(new BitSet(0), new BitSet(0));
            return;
        }
        int numberOfVariables = this.numberOfVariables();
        if (highestVariable >= numberOfVariables) {
            bitSetSize = numberOfVariables;
            highestRecursive = Integer.MAX_VALUE;
        } else {
            bitSetSize = highestVariable;
            highestRecursive = highestVariable;
        }
        BitSet path = new BitSet(bitSetSize);
        BitSet pathSupport = new BitSet(bitSetSize);
        this.forEachNonEmptyPathRecursive(node, highestRecursive, path, pathSupport, action);
    }

    private void forEachNonEmptyPathRecursive(int node, int highestVariable, BitSet path, BitSet pathSupport, BiConsumer<BitSet, BitSet> action) {
        int highNode;
        assert (this.isNodeValid(node) || node == 1);
        if (node == 1) {
            action.accept(path, pathSupport);
            return;
        }
        long store = this.getNodeStore(node);
        int variable = (int)BddImpl.getVariableFromStore(store);
        if (variable > highestVariable) {
            action.accept(path, pathSupport);
            return;
        }
        pathSupport.set(variable);
        int lowNode = (int)BddImpl.getLowFromStore(store);
        if (lowNode != 0) {
            this.forEachNonEmptyPathRecursive(lowNode, highestVariable, path, pathSupport, action);
        }
        if ((highNode = (int)BddImpl.getHighFromStore(store)) != 0) {
            path.set(variable);
            this.forEachNonEmptyPathRecursive(highNode, highestVariable, path, pathSupport, action);
            path.clear(variable);
        }
        assert (pathSupport.get(variable));
        pathSupport.clear(variable);
    }

    @Override
    public void support(int node, BitSet bitSet, int highestVariable) {
        assert (this.isNodeValidOrRoot(node));
        assert (0 <= highestVariable && highestVariable <= this.numberOfVariables);
        this.supportRecursive(node, bitSet, highestVariable);
        this.unMarkTree(node);
    }

    private void supportRecursive(int node, BitSet bitSet, int highestVariable) {
        if (this.isNodeRoot(node)) {
            return;
        }
        long nodeStore = this.getNodeStore(node);
        if (BddImpl.isNodeStoreMarked(nodeStore)) {
            return;
        }
        int variable = (int)BddImpl.getVariableFromStore(nodeStore);
        if (variable < highestVariable) {
            bitSet.set(variable);
            this.markNode(node);
            this.supportRecursive((int)BddImpl.getLowFromStore(nodeStore), bitSet, highestVariable);
            this.supportRecursive((int)BddImpl.getHighFromStore(nodeStore), bitSet, highestVariable);
        }
    }

    @Override
    public double countSatisfyingAssignments(int node) {
        if (node == 0) {
            return 0.0;
        }
        if (node == 1) {
            return StrictMath.pow(2.0, this.numberOfVariables);
        }
        long nodeStore = this.getNodeStore(node);
        double variable = BddImpl.getVariableFromStore(nodeStore);
        return StrictMath.pow(2.0, variable) * this.countSatisfyingAssignmentsRecursive(node);
    }

    private double countSatisfyingAssignmentsRecursive(int node) {
        if (node == 0) {
            return 0.0;
        }
        if (node == 1) {
            return 1.0;
        }
        double cacheLookup = this.cache.lookupSatisfaction(node);
        if (cacheLookup >= 0.0) {
            return cacheLookup;
        }
        int hash = this.cache.getLookupHash();
        long nodeStore = this.getNodeStore(node);
        int nodeVar = (int)BddImpl.getVariableFromStore(nodeStore);
        double lowCount = this.doCountSatisfyingAssignments((int)BddImpl.getLowFromStore(nodeStore), nodeVar);
        double highCount = this.doCountSatisfyingAssignments((int)BddImpl.getHighFromStore(nodeStore), nodeVar);
        double result = lowCount + highCount;
        this.cache.putSatisfaction(hash, node, result);
        return result;
    }

    private double doCountSatisfyingAssignments(int subNode, int currentVar) {
        if (subNode == 0) {
            return 0.0;
        }
        if (subNode == 1) {
            return StrictMath.pow(2.0, this.numberOfVariables - currentVar - 1);
        }
        long subStore = this.getNodeStore(subNode);
        int subVar = (int)BddImpl.getVariableFromStore(subStore);
        double multiplier = StrictMath.pow(2.0, subVar - currentVar - 1);
        return multiplier * this.countSatisfyingAssignmentsRecursive(subNode);
    }

    @Override
    public int cube(BitSet cubeVariables) {
        int node = 1;
        int currentVariableNumber = cubeVariables.nextSetBit(0);
        while (currentVariableNumber != -1) {
            this.pushToWorkStack(node);
            node = this.andRecursive(node, this.variableNodes[currentVariableNumber]);
            this.popWorkStack();
            currentVariableNumber = cubeVariables.nextSetBit(currentVariableNumber + 1);
        }
        return node;
    }

    @Override
    public int and(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.andRecursive(node1, node2);
        this.popWorkStack(2);
        return result;
    }

    private int andRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        int node2var;
        if (node1 == node2 || node2 == 1) {
            return node1;
        }
        if (node1 == 0 || node2 == 0) {
            return 0;
        }
        if (node1 == 1) {
            return node2;
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddImpl.getVariableFromStore(node1store);
        if (node1var > (node2var = (int)BddImpl.getVariableFromStore(node2store))) {
            if (this.cache.lookupAnd(node2, node1)) {
                return this.cache.getLookupResult();
            }
            int hash = this.cache.getLookupHash();
            int lowNode2 = this.pushToWorkStack(this.andRecursive((int)BddImpl.getLowFromStore(node2store), node1));
            int highNode2 = this.pushToWorkStack(this.andRecursive((int)BddImpl.getHighFromStore(node2store), node1));
            int resultNode = this.makeNode(node2var, lowNode2, highNode2);
            this.popWorkStack(2);
            this.cache.putAnd(hash, node2, node1, resultNode);
            return resultNode;
        }
        if (this.cache.lookupAnd(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.andRecursive((int)BddImpl.getLowFromStore(node1store), (int)BddImpl.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.andRecursive((int)BddImpl.getHighFromStore(node1store), (int)BddImpl.getHighFromStore(node2store));
            this.pushToWorkStack(highNode);
        } else {
            lowNode = this.pushToWorkStack(this.andRecursive((int)BddImpl.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.andRecursive((int)BddImpl.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putAnd(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public int compose(int node, int[] variableNodes) {
        int hash;
        assert (variableNodes.length <= this.numberOfVariables);
        if (node == 1 || node == 0) {
            return node;
        }
        this.pushToWorkStack(node);
        int workStackCount = 1;
        for (int i = 0; i < variableNodes.length; ++i) {
            if (variableNodes[i] == -1) {
                variableNodes[i] = this.variableNodes[i];
                continue;
            }
            assert (this.isNodeValidOrRoot(variableNodes[i]));
            if (this.isNodeSaturated(variableNodes[i])) continue;
            this.pushToWorkStack(variableNodes[i]);
            ++workStackCount;
        }
        int highestReplacedVariable = variableNodes.length - 1;
        for (int i = variableNodes.length - 1; i >= 0; --i) {
            if (variableNodes[i] == this.variableNodes[i]) continue;
            highestReplacedVariable = i;
            break;
        }
        if (highestReplacedVariable == -1) {
            return node;
        }
        if (this.getConfiguration().useGlobalComposeCache()) {
            if (this.cache.lookupCompose(node, variableNodes)) {
                return this.cache.getLookupResult();
            }
            hash = this.cache.getLookupHash();
        } else {
            hash = -1;
        }
        this.cache.clearVolatileCache();
        int result = this.composeRecursive(node, variableNodes, highestReplacedVariable);
        this.popWorkStack(workStackCount);
        if (this.getConfiguration().useGlobalComposeCache()) {
            this.cache.putCompose(hash, node, variableNodes, result);
        }
        return result;
    }

    private int composeRecursive(int node, int[] variableNodes, int highestReplacedVariable) {
        int resultNode;
        if (node == 1 || node == 0) {
            return node;
        }
        long nodeStore = this.getNodeStore(node);
        int nodeVariable = (int)BddImpl.getVariableFromStore(nodeStore);
        if (nodeVariable > highestReplacedVariable) {
            return node;
        }
        if (this.cache.lookupVolatile(node)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        int variableReplacementNode = variableNodes[nodeVariable];
        if (variableReplacementNode == 1) {
            resultNode = this.composeRecursive((int)BddImpl.getHighFromStore(nodeStore), variableNodes, highestReplacedVariable);
        } else if (variableReplacementNode == 0) {
            resultNode = this.composeRecursive((int)BddImpl.getLowFromStore(nodeStore), variableNodes, highestReplacedVariable);
        } else {
            int lowCompose = this.pushToWorkStack(this.composeRecursive((int)BddImpl.getLowFromStore(nodeStore), variableNodes, highestReplacedVariable));
            int highCompose = this.pushToWorkStack(this.composeRecursive((int)BddImpl.getHighFromStore(nodeStore), variableNodes, highestReplacedVariable));
            resultNode = this.ifThenElseRecursive(variableReplacementNode, highCompose, lowCompose);
            this.popWorkStack(2);
        }
        this.cache.putVolatile(hash, node, resultNode);
        return resultNode;
    }

    @Override
    public int equivalence(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int ret = this.equivalenceRecursive(node1, node2);
        this.popWorkStack(2);
        return ret;
    }

    private int equivalenceRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        int node2var;
        if (node1 == node2) {
            return 1;
        }
        if (node1 == 0) {
            return this.notRecursive(node2);
        }
        if (node1 == 1) {
            return node2;
        }
        if (node2 == 0) {
            return this.notRecursive(node1);
        }
        if (node2 == 1) {
            return node1;
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddImpl.getVariableFromStore(node1store);
        if (node1var > (node2var = (int)BddImpl.getVariableFromStore(node2store))) {
            if (this.cache.lookupEquivalence(node2, node1)) {
                return this.cache.getLookupResult();
            }
            int hash = this.cache.getLookupHash();
            int lowNode2 = this.equivalenceRecursive((int)BddImpl.getLowFromStore(node2store), node1);
            this.pushToWorkStack(lowNode2);
            int highNode2 = this.equivalenceRecursive((int)BddImpl.getHighFromStore(node2store), node1);
            this.pushToWorkStack(highNode2);
            int resultNode = this.makeNode(node2var, lowNode2, highNode2);
            this.popWorkStack(2);
            this.cache.putEquivalence(hash, node2, node1, resultNode);
            return resultNode;
        }
        if (this.cache.lookupEquivalence(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.equivalenceRecursive((int)BddImpl.getLowFromStore(node1store), (int)BddImpl.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.equivalenceRecursive((int)BddImpl.getHighFromStore(node1store), (int)BddImpl.getHighFromStore(node2store));
            this.pushToWorkStack(highNode);
        } else {
            lowNode = this.pushToWorkStack(this.equivalenceRecursive((int)BddImpl.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.equivalenceRecursive((int)BddImpl.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putEquivalence(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public int exists(int node, BitSet quantifiedVariables) {
        return this.getConfiguration().useShannonExists() ? this.existsShannon(node, quantifiedVariables) : this.existsSelfSubstitution(node, quantifiedVariables);
    }

    int existsSelfSubstitution(int node, BitSet quantifiedVariables) {
        assert (quantifiedVariables.previousSetBit(quantifiedVariables.length()) <= this.numberOfVariables);
        if (quantifiedVariables.cardinality() == this.numberOfVariables) {
            return 1;
        }
        if (node == 1 || node == 0) {
            return node;
        }
        this.pushToWorkStack(node);
        int[] replacementArray = new int[quantifiedVariables.length()];
        System.arraycopy(this.variableNodes, 0, replacementArray, 0, replacementArray.length);
        int quantifiedNode = node;
        int workStackElements = 1;
        for (int i = 0; i < quantifiedVariables.length(); ++i) {
            if (!quantifiedVariables.get(i)) continue;
            int variableNode = replacementArray[i];
            replacementArray[i] = 1;
            this.cache.clearVolatileCache();
            replacementArray[i] = this.pushToWorkStack(this.composeRecursive(quantifiedNode, replacementArray, i));
            this.cache.clearVolatileCache();
            quantifiedNode = this.composeRecursive(quantifiedNode, replacementArray, i);
            this.popWorkStack();
            replacementArray[i] = variableNode;
            this.pushToWorkStack(quantifiedNode);
            ++workStackElements;
        }
        this.popWorkStack(workStackElements);
        return quantifiedNode;
    }

    int existsShannon(int node, BitSet quantifiedVariables) {
        assert (quantifiedVariables.previousSetBit(quantifiedVariables.length()) <= this.numberOfVariables);
        if (quantifiedVariables.cardinality() == this.numberOfVariables) {
            return 1;
        }
        this.pushToWorkStack(node);
        int quantifiedVariablesCube = this.cube(quantifiedVariables);
        this.pushToWorkStack(quantifiedVariablesCube);
        int result = this.existsShannonRecursive(node, quantifiedVariablesCube);
        this.popWorkStack(2);
        return result;
    }

    private int existsShannonRecursive(int node, int quantifiedVariableCube) {
        if (node == 1 || node == 0) {
            return node;
        }
        if (quantifiedVariableCube == 1) {
            return node;
        }
        long nodeStore = this.getNodeStore(node);
        int nodeVariable = (int)BddImpl.getVariableFromStore(nodeStore);
        int currentCubeNode = quantifiedVariableCube;
        long currentCubeNodeStore = this.getNodeStore(currentCubeNode);
        int currentCubeNodeVariable = (int)BddImpl.getVariableFromStore(currentCubeNodeStore);
        while (currentCubeNodeVariable < nodeVariable) {
            currentCubeNode = (int)BddImpl.getHighFromStore(currentCubeNodeStore);
            if (currentCubeNode == 1) {
                return node;
            }
            currentCubeNodeStore = this.getNodeStore(currentCubeNode);
            currentCubeNodeVariable = (int)BddImpl.getVariableFromStore(currentCubeNodeStore);
        }
        if (BddImpl.isVariableOrNegatedStore(nodeStore)) {
            if (nodeVariable == currentCubeNodeVariable) {
                return 1;
            }
            return node;
        }
        if (this.cache.lookupExists(node, currentCubeNode)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        int lowExists = this.pushToWorkStack(this.existsShannonRecursive((int)BddImpl.getLowFromStore(nodeStore), currentCubeNode));
        int highExists = this.pushToWorkStack(this.existsShannonRecursive((int)BddImpl.getHighFromStore(nodeStore), currentCubeNode));
        int resultNode = currentCubeNodeVariable > nodeVariable ? this.makeNode(nodeVariable, lowExists, highExists) : this.orRecursive(lowExists, highExists);
        this.popWorkStack(2);
        this.cache.putExists(hash, node, currentCubeNode, resultNode);
        return resultNode;
    }

    @Override
    public int ifThenElse(int ifNode, int thenNode, int elseNode) {
        assert (this.isNodeValidOrRoot(ifNode) && this.isNodeValidOrRoot(thenNode) && this.isNodeValidOrRoot(elseNode));
        this.pushToWorkStack(ifNode);
        this.pushToWorkStack(thenNode);
        this.pushToWorkStack(elseNode);
        int result = this.ifThenElseRecursive(ifNode, thenNode, elseNode);
        this.popWorkStack(3);
        return result;
    }

    private int ifThenElseRecursive(int ifNode, int thenNode, int elseNode) {
        int elseHighNode;
        int elseLowNode;
        int thenHighNode;
        int thenLowNode;
        int ifHighNode;
        int ifLowNode;
        int elseVar;
        int thenVar;
        int minVar;
        if (ifNode == 1) {
            return thenNode;
        }
        if (ifNode == 0) {
            return elseNode;
        }
        if (thenNode == elseNode) {
            return thenNode;
        }
        if (thenNode == 1) {
            if (elseNode == 0) {
                return ifNode;
            }
            return this.orRecursive(ifNode, elseNode);
        }
        if (thenNode == 0) {
            if (elseNode == 1) {
                return this.notRecursive(ifNode);
            }
            int result = this.andRecursive(this.pushToWorkStack(this.notRecursive(ifNode)), elseNode);
            this.popWorkStack();
            return result;
        }
        if (elseNode == 0) {
            return this.andRecursive(ifNode, thenNode);
        }
        if (elseNode == 1) {
            int result = this.notAndRecursive(ifNode, this.pushToWorkStack(this.notRecursive(thenNode)));
            this.popWorkStack();
            return result;
        }
        if (this.cache.lookupIfThenElse(ifNode, thenNode, elseNode)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        long ifStore = this.getNodeStore(ifNode);
        long thenStore = this.getNodeStore(thenNode);
        long elseStore = this.getNodeStore(elseNode);
        int ifVar = (int)BddImpl.getVariableFromStore(ifStore);
        if (ifVar == (minVar = Math.min(ifVar, Math.min(thenVar = (int)BddImpl.getVariableFromStore(thenStore), elseVar = (int)BddImpl.getVariableFromStore(elseStore))))) {
            ifLowNode = (int)BddImpl.getLowFromStore(ifStore);
            ifHighNode = (int)BddImpl.getHighFromStore(ifStore);
        } else {
            ifLowNode = ifNode;
            ifHighNode = ifNode;
        }
        if (thenVar == minVar) {
            thenLowNode = (int)BddImpl.getLowFromStore(thenStore);
            thenHighNode = (int)BddImpl.getHighFromStore(thenStore);
        } else {
            thenLowNode = thenNode;
            thenHighNode = thenNode;
        }
        if (elseVar == minVar) {
            elseLowNode = (int)BddImpl.getLowFromStore(elseStore);
            elseHighNode = (int)BddImpl.getHighFromStore(elseStore);
        } else {
            elseLowNode = elseNode;
            elseHighNode = elseNode;
        }
        int lowNode = this.pushToWorkStack(this.ifThenElseRecursive(ifLowNode, thenLowNode, elseLowNode));
        int highNode = this.pushToWorkStack(this.ifThenElseRecursive(ifHighNode, thenHighNode, elseHighNode));
        int result = this.makeNode(minVar, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putIfThenElse(hash, ifNode, thenNode, elseNode, result);
        return result;
    }

    @Override
    public int implication(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int ret = this.implicationRecursive(node1, node2);
        this.popWorkStack(2);
        return ret;
    }

    private int implicationRecursive(int node1, int node2) {
        int decisionVar;
        int highNode;
        int lowNode;
        int node2var;
        if (node1 == 0 || node2 == 1 || node1 == node2) {
            return 1;
        }
        if (node1 == 1) {
            return node2;
        }
        if (node2 == 0) {
            return this.notRecursive(node1);
        }
        if (this.cache.lookupImplication(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddImpl.getVariableFromStore(node1store);
        if (node1var > (node2var = (int)BddImpl.getVariableFromStore(node2store))) {
            lowNode = this.pushToWorkStack(this.implicationRecursive(node1, (int)BddImpl.getLowFromStore(node2store)));
            highNode = this.pushToWorkStack(this.implicationRecursive(node1, (int)BddImpl.getHighFromStore(node2store)));
            decisionVar = node2var;
        } else if (node1var == node2var) {
            lowNode = this.pushToWorkStack(this.implicationRecursive((int)BddImpl.getLowFromStore(node1store), (int)BddImpl.getLowFromStore(node2store)));
            highNode = this.pushToWorkStack(this.implicationRecursive((int)BddImpl.getHighFromStore(node1store), (int)BddImpl.getHighFromStore(node2store)));
            decisionVar = node1var;
        } else {
            lowNode = this.pushToWorkStack(this.implicationRecursive((int)BddImpl.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.implicationRecursive((int)BddImpl.getHighFromStore(node1store), node2));
            decisionVar = node1var;
        }
        int resultNode = this.makeNode(decisionVar, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putImplication(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public boolean implies(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        return this.impliesRecursive(node1, node2);
    }

    private boolean impliesRecursive(int node1, int node2) {
        int node2var;
        if (node1 == 0) {
            return true;
        }
        if (node2 == 0) {
            return false;
        }
        if (node2 == 1) {
            return true;
        }
        if (node1 == 1) {
            return false;
        }
        if (node1 == node2) {
            return true;
        }
        if (this.cache.lookupImplication(node1, node2)) {
            return this.cache.getLookupResult() == 1;
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddImpl.getVariableFromStore(node1store);
        if (node1var == (node2var = (int)BddImpl.getVariableFromStore(node2store))) {
            return this.impliesRecursive((int)BddImpl.getLowFromStore(node1store), (int)BddImpl.getLowFromStore(node2store)) && this.impliesRecursive((int)BddImpl.getHighFromStore(node1store), (int)BddImpl.getHighFromStore(node2store));
        }
        if (node1var < node2var) {
            return this.impliesRecursive((int)BddImpl.getLowFromStore(node1store), node2) && this.impliesRecursive((int)BddImpl.getHighFromStore(node1store), node2);
        }
        return this.impliesRecursive(node1, (int)BddImpl.getLowFromStore(node2store)) && this.impliesRecursive(node1, (int)BddImpl.getHighFromStore(node2store));
    }

    @Override
    public int not(int node) {
        assert (this.isNodeValidOrRoot(node));
        this.pushToWorkStack(node);
        int ret = this.notRecursive(node);
        this.popWorkStack();
        return ret;
    }

    private int notRecursive(int node) {
        if (node == 0) {
            return 1;
        }
        if (node == 1) {
            return 0;
        }
        if (this.cache.lookupNot(node)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        long nodeStore = this.getNodeStore(node);
        int lowNode = this.pushToWorkStack(this.notRecursive((int)BddImpl.getLowFromStore(nodeStore)));
        int highNode = this.pushToWorkStack(this.notRecursive((int)BddImpl.getHighFromStore(nodeStore)));
        int resultNode = this.makeNode((int)BddImpl.getVariableFromStore(nodeStore), lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putNot(hash, node, resultNode);
        return resultNode;
    }

    @Override
    public int notAnd(int node1, int node2) {
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int ret = this.notAndRecursive(node1, node2);
        this.popWorkStack(2);
        return ret;
    }

    private int notAndRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        int node2var;
        if (node1 == 0 || node2 == 0) {
            return 1;
        }
        if (node1 == 1 || node1 == node2) {
            return this.notRecursive(node2);
        }
        if (node2 == 1) {
            return this.notRecursive(node1);
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddImpl.getVariableFromStore(node1store);
        if (node1var > (node2var = (int)BddImpl.getVariableFromStore(node2store))) {
            if (this.cache.lookupNAnd(node2, node1)) {
                return this.cache.getLookupResult();
            }
            int hash = this.cache.getLookupHash();
            int lowNode2 = this.notAndRecursive((int)BddImpl.getLowFromStore(node2store), node1);
            this.pushToWorkStack(lowNode2);
            int highNode2 = this.notAndRecursive((int)BddImpl.getHighFromStore(node2store), node1);
            this.pushToWorkStack(highNode2);
            int resultNode = this.makeNode(node2var, lowNode2, highNode2);
            this.popWorkStack(2);
            this.cache.putNAnd(hash, node2, node1, resultNode);
            return resultNode;
        }
        if (this.cache.lookupNAnd(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.notAndRecursive((int)BddImpl.getLowFromStore(node1store), (int)BddImpl.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.notAndRecursive((int)BddImpl.getHighFromStore(node1store), (int)BddImpl.getHighFromStore(node2store));
            this.pushToWorkStack(highNode);
        } else {
            lowNode = this.pushToWorkStack(this.notAndRecursive((int)BddImpl.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.notAndRecursive((int)BddImpl.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putNAnd(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public int or(int node1, int node2) {
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.orRecursive(node1, node2);
        this.popWorkStack(2);
        return result;
    }

    private int orRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        int node2var;
        if (node1 == 1 || node2 == 1) {
            return 1;
        }
        if (node1 == 0 || node1 == node2) {
            return node2;
        }
        if (node2 == 0) {
            return node1;
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddImpl.getVariableFromStore(node1store);
        if (node1var > (node2var = (int)BddImpl.getVariableFromStore(node2store))) {
            if (this.cache.lookupOr(node2, node1)) {
                return this.cache.getLookupResult();
            }
            int hash = this.cache.getLookupHash();
            int lowNode2 = this.pushToWorkStack(this.orRecursive((int)BddImpl.getLowFromStore(node2store), node1));
            int highNode2 = this.pushToWorkStack(this.orRecursive((int)BddImpl.getHighFromStore(node2store), node1));
            int resultNode = this.makeNode(node2var, lowNode2, highNode2);
            this.popWorkStack(2);
            this.cache.putOr(hash, node2, node1, resultNode);
            return resultNode;
        }
        if (this.cache.lookupOr(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.orRecursive((int)BddImpl.getLowFromStore(node1store), (int)BddImpl.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.pushToWorkStack(this.orRecursive((int)BddImpl.getHighFromStore(node1store), (int)BddImpl.getHighFromStore(node2store)));
        } else {
            lowNode = this.pushToWorkStack(this.orRecursive((int)BddImpl.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.orRecursive((int)BddImpl.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putOr(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    public int restrict(int node, BitSet restrictedVariables, BitSet restrictedVariableValues) {
        assert (this.isNodeValidOrRoot(node));
        this.pushToWorkStack(node);
        this.cache.clearVolatileCache();
        int resultNode = this.restrictRecursive(node, restrictedVariables, restrictedVariableValues);
        this.popWorkStack();
        return resultNode;
    }

    private int restrictRecursive(int node, BitSet restrictedVariables, BitSet restrictedVariableValues) {
        int resultNode;
        if (node == 1 || node == 0) {
            return node;
        }
        long nodeStore = this.getNodeStore(node);
        int nodeVariable = (int)BddImpl.getVariableFromStore(nodeStore);
        if (nodeVariable >= restrictedVariables.length()) {
            return node;
        }
        if (this.cache.lookupVolatile(node)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (restrictedVariables.get(nodeVariable)) {
            resultNode = restrictedVariableValues.get(nodeVariable) ? this.restrictRecursive((int)BddImpl.getHighFromStore(nodeStore), restrictedVariables, restrictedVariableValues) : this.restrictRecursive((int)BddImpl.getLowFromStore(nodeStore), restrictedVariables, restrictedVariableValues);
        } else {
            int lowRestrict = this.pushToWorkStack(this.restrictRecursive((int)BddImpl.getLowFromStore(nodeStore), restrictedVariables, restrictedVariableValues));
            int highRestrict = this.pushToWorkStack(this.restrictRecursive((int)BddImpl.getHighFromStore(nodeStore), restrictedVariables, restrictedVariableValues));
            resultNode = this.makeNode(nodeVariable, lowRestrict, highRestrict);
            this.popWorkStack(2);
        }
        this.cache.putVolatile(hash, node, resultNode);
        return resultNode;
    }

    @Override
    public int xor(int node1, int node2) {
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int ret = this.xorRecursive(node1, node2);
        this.popWorkStack(2);
        return ret;
    }

    private int xorRecursive(int node1, int node2) {
        int highNode;
        int lowNode;
        int node2var;
        if (node1 == node2) {
            return 0;
        }
        if (node1 == 0) {
            return node2;
        }
        if (node2 == 0) {
            return node1;
        }
        if (node1 == 1) {
            return this.notRecursive(node2);
        }
        if (node2 == 1) {
            return this.notRecursive(node1);
        }
        long node1store = this.getNodeStore(node1);
        long node2store = this.getNodeStore(node2);
        int node1var = (int)BddImpl.getVariableFromStore(node1store);
        if (node1var > (node2var = (int)BddImpl.getVariableFromStore(node2store))) {
            if (this.cache.lookupXor(node2, node1)) {
                return this.cache.getLookupResult();
            }
            int hash = this.cache.getLookupHash();
            int lowNode2 = this.pushToWorkStack(this.xorRecursive((int)BddImpl.getLowFromStore(node2store), node1));
            int highNode2 = this.pushToWorkStack(this.xorRecursive((int)BddImpl.getHighFromStore(node2store), node1));
            int resultNode = this.makeNode(node2var, lowNode2, highNode2);
            this.popWorkStack(2);
            this.cache.putXor(hash, node2, node1, resultNode);
            return resultNode;
        }
        if (this.cache.lookupXor(node1, node2)) {
            return this.cache.getLookupResult();
        }
        int hash = this.cache.getLookupHash();
        if (node1var == node2var) {
            lowNode = this.xorRecursive((int)BddImpl.getLowFromStore(node1store), (int)BddImpl.getLowFromStore(node2store));
            this.pushToWorkStack(lowNode);
            highNode = this.pushToWorkStack(this.xorRecursive((int)BddImpl.getHighFromStore(node1store), (int)BddImpl.getHighFromStore(node2store)));
        } else {
            lowNode = this.pushToWorkStack(this.xorRecursive((int)BddImpl.getLowFromStore(node1store), node2));
            highNode = this.pushToWorkStack(this.xorRecursive((int)BddImpl.getHighFromStore(node1store), node2));
        }
        int resultNode = this.makeNode(node1var, lowNode, highNode);
        this.popWorkStack(2);
        this.cache.putXor(hash, node1, node2, resultNode);
        return resultNode;
    }

    @Override
    void notifyGcRun() {
        this.cache.invalidate();
    }

    @Override
    void notifyTableSizeChanged() {
        this.cache.invalidate();
    }

    String getCacheStatistics() {
        return this.cache.getStatistics();
    }

    static final class PowerIterator
    implements Iterator<BitSet> {
        private final BitSet iteration;
        private final int size;
        private int numSetBits = -1;

        PowerIterator(int size) {
            this.size = size;
            this.iteration = new BitSet(size);
        }

        @Override
        public boolean hasNext() {
            return this.numSetBits < this.size;
        }

        @Override
        public BitSet next() {
            if (this.numSetBits == -1) {
                this.numSetBits = 0;
                return this.iteration;
            }
            if (this.numSetBits == this.size) {
                throw new NoSuchElementException("No next element");
            }
            for (int index = 0; index < this.size; ++index) {
                if (this.iteration.get(index)) {
                    this.iteration.clear(index);
                    --this.numSetBits;
                    continue;
                }
                this.iteration.set(index);
                ++this.numSetBits;
                break;
            }
            return this.iteration;
        }
    }

    private static final class NodeSolutionIterator
    implements Iterator<BitSet> {
        private static final int NON_PATH_NODE = -1;
        private final BddImpl bdd;
        private final BitSet assignment;
        private final int variableCount;
        private final int[] path;
        private boolean firstRun = true;
        private int highestLowVariableWithNonFalseHighBranch = 0;
        private int leafNodeIndex;
        private boolean hasNextPath;
        private boolean hasNextAssignment;
        private final int rootVariable;

        NodeSolutionIterator(BddImpl bdd, int node) {
            assert (bdd.isNodeValid(node) || node == 1);
            this.variableCount = bdd.numberOfVariables();
            assert (this.variableCount > 0);
            this.bdd = bdd;
            this.path = new int[this.variableCount];
            this.assignment = new BitSet(this.variableCount);
            this.rootVariable = bdd.getVariable(node);
            Arrays.fill(this.path, -1);
            this.path[this.rootVariable] = node;
            this.leafNodeIndex = 0;
            this.hasNextPath = true;
            this.hasNextAssignment = true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNextAssignment;
        }

        @Override
        public BitSet next() throws NoSuchElementException {
            int currentNode;
            if (this.firstRun) {
                this.firstRun = false;
                currentNode = this.path[this.rootVariable];
            } else {
                boolean clearedAny = false;
                for (int index2 = 0; index2 < this.variableCount; ++index2) {
                    if (this.path[index2] != -1) continue;
                    if (this.assignment.get(index2)) {
                        this.assignment.clear(index2);
                        clearedAny = true;
                        continue;
                    }
                    this.assignment.set(index2);
                    if (this.hasNextPath || clearedAny) {
                        this.hasNextAssignment = true;
                    } else {
                        this.hasNextAssignment = false;
                        for (int i = index2 + 1; i < this.variableCount; ++i) {
                            if (this.path[i] != -1 || this.assignment.get(i)) continue;
                            this.hasNextAssignment = true;
                            break;
                        }
                    }
                    assert (this.bdd.evaluate(this.path[this.rootVariable], this.assignment));
                    return this.assignment;
                }
                assert (this.hasNextPath);
                assert (IntStream.range(0, this.variableCount).allMatch(index -> this.path[index] != -1 || !this.assignment.get(index)));
                currentNode = this.path[this.leafNodeIndex];
                int branchIndex = this.leafNodeIndex;
                while (this.assignment.get(branchIndex) || this.bdd.getHigh(currentNode) == 0) {
                    do {
                        if (--branchIndex != -1) continue;
                        throw new NoSuchElementException("No next element");
                    } while (this.path[branchIndex] == -1);
                    currentNode = this.path[branchIndex];
                }
                assert (!this.assignment.get(branchIndex) && this.bdd.getHigh(currentNode) != 0);
                assert (this.bdd.getVariable(currentNode) == branchIndex);
                this.assignment.clear(branchIndex + 1, this.leafNodeIndex + 1);
                Arrays.fill(this.path, branchIndex + 1, this.leafNodeIndex + 1, -1);
                this.assignment.set(branchIndex);
                assert (this.path[branchIndex] == currentNode);
                currentNode = this.bdd.getHigh(this.path[branchIndex]);
                assert (currentNode != 0);
                this.leafNodeIndex = branchIndex;
            }
            boolean bl = this.hasNextPath = this.highestLowVariableWithNonFalseHighBranch < this.leafNodeIndex;
            while (currentNode != 1) {
                assert (currentNode != 0);
                long currentNodeStore = this.bdd.getNodeStore(currentNode);
                this.leafNodeIndex = (int)NodeTable.getVariableFromStore(currentNodeStore);
                this.path[this.leafNodeIndex] = currentNode;
                int low = (int)NodeTable.getLowFromStore(currentNodeStore);
                if (low == 0) {
                    this.assignment.set(this.leafNodeIndex);
                    currentNode = (int)NodeTable.getHighFromStore(currentNodeStore);
                    continue;
                }
                if (!this.hasNextPath && (int)NodeTable.getHighFromStore(currentNodeStore) != 0) {
                    this.hasNextPath = true;
                    this.highestLowVariableWithNonFalseHighBranch = this.leafNodeIndex;
                }
                currentNode = low;
            }
            assert (this.bdd.evaluate(this.path[this.rootVariable], this.assignment));
            return this.assignment;
        }
    }
}

