/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Visitor;

public final class DeduplicationRewriter
implements Visitor<Formula> {
    private final Map<Formula, Formula> map = new HashMap<Formula, Formula>();

    private DeduplicationRewriter() {
    }

    public static Formula deduplicate(Formula formula) {
        return formula.accept(new DeduplicationRewriter());
    }

    private Formula computeIfAbsent(Formula formula, Supplier<Formula> supplier) {
        Formula value = this.map.get(formula);
        if (value != null) {
            return value;
        }
        Formula newValue = supplier.get();
        Formula oldValue = this.map.putIfAbsent(formula, newValue);
        return oldValue == null ? newValue : oldValue;
    }

    @Override
    public Formula visit(Biconditional biconditional) {
        return this.computeIfAbsent(biconditional, () -> new Biconditional(biconditional.left.accept(this), biconditional.right.accept(this)));
    }

    @Override
    public Formula visit(BooleanConstant booleanConstant) {
        return booleanConstant;
    }

    @Override
    public Formula visit(Conjunction conjunction) {
        return this.computeIfAbsent(conjunction, () -> Conjunction.of(conjunction.map(this)));
    }

    @Override
    public Formula visit(Disjunction disjunction) {
        return this.computeIfAbsent(disjunction, () -> Disjunction.of(disjunction.map(this)));
    }

    @Override
    public Formula visit(FOperator fOperator) {
        return this.computeIfAbsent(fOperator, () -> new FOperator(fOperator.operand.accept(this)));
    }

    @Override
    public Formula visit(GOperator gOperator) {
        return this.computeIfAbsent(gOperator, () -> new GOperator(gOperator.operand.accept(this)));
    }

    @Override
    public Formula visit(Literal literal) {
        return this.computeIfAbsent(literal, () -> literal);
    }

    @Override
    public Formula visit(MOperator mOperator) {
        return this.computeIfAbsent(mOperator, () -> new MOperator(mOperator.left.accept(this), mOperator.right.accept(this)));
    }

    @Override
    public Formula visit(ROperator rOperator) {
        return this.computeIfAbsent(rOperator, () -> new ROperator(rOperator.left.accept(this), rOperator.right.accept(this)));
    }

    @Override
    public Formula visit(UOperator uOperator) {
        return this.computeIfAbsent(uOperator, () -> new UOperator(uOperator.left.accept(this), uOperator.right.accept(this)));
    }

    @Override
    public Formula visit(WOperator wOperator) {
        return this.computeIfAbsent(wOperator, () -> new WOperator(wOperator.left.accept(this), wOperator.right.accept(this)));
    }

    @Override
    public Formula visit(XOperator xOperator) {
        return this.computeIfAbsent(xOperator, () -> new XOperator(xOperator.operand.accept(this)));
    }
}

