/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Objects;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.Visitor;

public final class FrequencyG
extends GOperator {
    private static final double EPSILON = 1.0E-12;
    public final double bound;
    public final Comparison cmp;
    public final Limes limes;

    public FrequencyG(Formula operand, double bound, Comparison cmp, Limes limes) {
        super(operand);
        this.bound = bound;
        this.cmp = cmp;
        this.limes = limes;
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    @Override
    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    protected boolean equalsImpl(Formula o) {
        assert (this.getClass() == o.getClass());
        FrequencyG that = (FrequencyG)o;
        return Objects.equals(this.operand, that.operand) && Math.abs(this.bound - that.bound) < 1.0E-12 && this.cmp == that.cmp && this.limes == that.limes;
    }

    @Override
    public String operatorSymbol() {
        return "G{" + this.limes + " " + this.cmp + " " + this.bound + "}";
    }

    @Override
    public boolean isPureEventual() {
        throw new UnsupportedOperationException("To my best knowledge not defined");
    }

    @Override
    public boolean isPureUniversal() {
        throw new UnsupportedOperationException("To my best knowledge not defined");
    }

    @Override
    public Formula nnf() {
        return new FrequencyG(this.operand.nnf(), this.bound, this.cmp, this.limes);
    }

    @Override
    public FrequencyG not() {
        return new FrequencyG(this.operand.not(), 1.0 - this.bound, this.cmp.theOther(), this.limes.theOther());
    }

    @Override
    public String toString() {
        return "G {" + this.limes + this.cmp + this.bound + "} " + this.operand;
    }

    @Override
    public FrequencyG unfold() {
        return this;
    }

    public static enum Limes {
        SUP,
        INF;


        public Limes theOther() {
            if (this == SUP) {
                return INF;
            }
            return SUP;
        }

        public String toString() {
            if (this == SUP) {
                return "sup";
            }
            return "inf";
        }
    }

    public static enum Comparison {
        GEQ,
        GT;


        public Comparison theOther() {
            switch (this) {
                case GEQ: {
                    return GT;
                }
                case GT: {
                    return GEQ;
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            switch (this) {
                case GEQ: {
                    return ">=";
                }
                case GT: {
                    return ">";
                }
            }
            throw new AssertionError();
        }
    }
}

