/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import java.util.HashSet;
import java.util.Set;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.BinaryModalOperator;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.visitors.Collector;

final class RabinizerUtil {
    private RabinizerUtil() {
    }

    private static void findSupportingSubFormulas(EquivalenceClass equivalenceClass, Set<GOperator> gOperators) {
        for (Formula temporalOperator : equivalenceClass.modalOperators()) {
            if (temporalOperator instanceof GOperator) {
                gOperators.add((GOperator)temporalOperator);
                continue;
            }
            Formula unwrapped = temporalOperator;
            while (unwrapped instanceof UnaryModalOperator && !((unwrapped = ((UnaryModalOperator)unwrapped).operand) instanceof GOperator)) {
            }
            EquivalenceClassFactory factory = equivalenceClass.factory();
            if (unwrapped instanceof GOperator) {
                gOperators.add((GOperator)unwrapped);
                continue;
            }
            if (unwrapped instanceof BinaryModalOperator) {
                BinaryModalOperator binaryOperator = (BinaryModalOperator)unwrapped;
                RabinizerUtil.findSupportingSubFormulas(factory.of(binaryOperator.left), gOperators);
                RabinizerUtil.findSupportingSubFormulas(factory.of(binaryOperator.right), gOperators);
                continue;
            }
            RabinizerUtil.findSupportingSubFormulas(factory.of(unwrapped), gOperators);
        }
    }

    static Set<GOperator> getRelevantSubFormulas(EquivalenceClass equivalenceClass) {
        Formula representative = equivalenceClass.representative();
        if (representative != null) {
            return Collector.collectGOperators(representative);
        }
        HashSet<GOperator> operators = new HashSet<GOperator>();
        equivalenceClass.modalOperators().forEach(formula -> operators.addAll(Collector.collectGOperators(formula)));
        return operators;
    }

    static Set<GOperator> getSupportSubFormulas(EquivalenceClass equivalenceClass) {
        if (equivalenceClass.isTrue() || equivalenceClass.isFalse()) {
            return Set.of();
        }
        HashSet<GOperator> operators = new HashSet<GOperator>();
        RabinizerUtil.findSupportingSubFormulas(equivalenceClass, operators);
        return operators;
    }

    static String printRanking(int[] ranking) {
        if (ranking.length == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(ranking.length * 3 + 2);
        builder.append('[').append(ranking[0]);
        for (int i = 1; i < ranking.length; ++i) {
            builder.append(',').append(ranking[i]);
        }
        builder.append(']');
        return builder.toString();
    }
}

