/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import java.util.BitSet;
import javax.annotation.Nullable;
import owl.automaton.edge.Edge;
import owl.ltl.EquivalenceClass;
import owl.translations.rabinizer.MonitorState;
import owl.translations.rabinizer.RabinizerState;

class RabinizerStateFactory {
    final boolean eager;

    RabinizerStateFactory(boolean eager) {
        this.eager = eager;
    }

    BitSet getClassSensitiveAlphabet(EquivalenceClass equivalenceClass) {
        return this.eager ? equivalenceClass.atomicPropositions() : equivalenceClass.unfold().atomicPropositions();
    }

    static final class MasterStateFactory
    extends RabinizerStateFactory {
        private final boolean complete;
        private final boolean fairnessFragment;

        MasterStateFactory(boolean eager, boolean complete, boolean fairnessFragment) {
            super(eager);
            assert (!fairnessFragment || eager);
            this.complete = complete;
            this.fairnessFragment = fairnessFragment;
        }

        EquivalenceClass getInitialState(EquivalenceClass formula) {
            return this.eager ? formula.unfold() : formula;
        }

        @Nullable
        Edge<EquivalenceClass> getSuccessor(EquivalenceClass state, BitSet valuation) {
            EquivalenceClass successor = this.eager ? (this.fairnessFragment ? state : state.temporalStepUnfold(valuation)) : state.unfoldTemporalStep(valuation);
            return successor.isFalse() && !this.complete ? null : Edge.of(successor);
        }
    }

    static final class ProductStateFactory
    extends RabinizerStateFactory {
        ProductStateFactory(boolean eager) {
            super(eager);
        }

        public BitSet getSensitiveAlphabet(RabinizerState state) {
            BitSet sensitiveAlphabet = this.getClassSensitiveAlphabet(state.masterState());
            for (MonitorState monitorState : state.monitorStates()) {
                for (EquivalenceClass rankedFormula : monitorState.formulaRanking()) {
                    sensitiveAlphabet.or(this.getClassSensitiveAlphabet(rankedFormula));
                }
            }
            return sensitiveAlphabet;
        }
    }
}

