/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import com.google.common.collect.Collections2;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.LabelledEdgesAutomatonMixin;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.LabelledEdge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.ltl.GOperator;
import owl.translations.rabinizer.GSet;
import owl.translations.rabinizer.MonitorState;

class MonitorAutomaton
implements LabelledEdgesAutomatonMixin<MonitorState, NoneAcceptance> {
    private final Automaton<MonitorState, ParityAcceptance> anyAutomaton;
    private final Map<GSet, Automaton<MonitorState, ParityAcceptance>> automata;
    private final GSet base;
    private final GOperator formula;

    MonitorAutomaton(GOperator formula, Map<GSet, Automaton<MonitorState, ParityAcceptance>> automata) {
        this.automata = Map.copyOf(automata);
        this.formula = formula;
        HashSet<GOperator> baseBuilder = new HashSet<GOperator>();
        for (GSet relevantSet : this.automata.keySet()) {
            baseBuilder.addAll(relevantSet);
        }
        this.base = new GSet(baseBuilder);
        this.anyAutomaton = automata.values().iterator().next();
    }

    @Override
    public NoneAcceptance acceptance() {
        return NoneAcceptance.INSTANCE;
    }

    Map<GSet, Automaton<MonitorState, ParityAcceptance>> getAutomata() {
        return this.automata;
    }

    public Automaton<MonitorState, ParityAcceptance> getAutomaton(GSet gSet) {
        GSet intersection = this.base.intersection(gSet);
        Automaton<MonitorState, ParityAcceptance> result = this.automata.get(intersection);
        assert (result != null) : String.format("No automaton found for gSet %s with base %s", gSet, this.base);
        return result;
    }

    @Override
    public ValuationSetFactory factory() {
        return this.anyAutomaton.factory();
    }

    @Override
    public Set<MonitorState> initialStates() {
        return this.anyAutomaton.initialStates();
    }

    @Override
    public Collection<LabelledEdge<MonitorState>> labelledEdges(MonitorState state) {
        Collection<LabelledEdge<MonitorState>> labelledEdges = this.anyAutomaton.labelledEdges(state);
        HashMap<MonitorState, ValuationSet> successors = new HashMap<MonitorState, ValuationSet>(labelledEdges.size());
        for (LabelledEdge<MonitorState> labelledEdge : labelledEdges) {
            successors.merge((MonitorState)labelledEdge.edge.successor(), labelledEdge.valuations, ValuationSet::union);
        }
        return Collections2.transform(successors.entrySet(), x -> LabelledEdge.of((MonitorState)x.getKey(), (ValuationSet)x.getValue()));
    }

    @Override
    @Nullable
    public String name() {
        return "Monitor for " + this.formula + " with base " + this.base;
    }

    @Override
    public Set<MonitorState> states() {
        return this.anyAutomaton.states();
    }

    @Override
    @Nullable
    public MonitorState successor(MonitorState state, BitSet valuation) {
        return this.anyAutomaton.successor(state, valuation);
    }

    @Override
    public Set<MonitorState> successors(MonitorState state) {
        return this.anyAutomaton.successors(state);
    }
}

