/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.EnumSet;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import owl.run.modules.OwlModuleParser;
import owl.translations.ltl2ldba.LTL2LDBAFunction;

public abstract class AbstractLTL2LDBAModule
implements OwlModuleParser.TransformerParser {
    private static final Option EPSILON = new Option("e", "epsilon", false, "Do not remove generated epsilon-transitions. Note: The generated output is not valid HOA, since the format does not support epsilon transitions.");
    private static final Option NON_DETERMINISTIC = new Option("n", "non-deterministic", false, "Construct a non-deterministic initial component instead of a deterministic.");

    public static Option guessF() {
        return new Option("f", "guess-f", false, "Guess F-operators that are infinitely often true.");
    }

    public static Option simple() {
        return new Option("s", "simple", false, "Use a simpler state-space construction. This disables special optimisations and redundancy removal.");
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        List.of(EPSILON, NON_DETERMINISTIC, AbstractLTL2LDBAModule.guessF(), AbstractLTL2LDBAModule.simple()).forEach(arg_0 -> ((Options)options).addOption(arg_0));
        return options;
    }

    static EnumSet<LTL2LDBAFunction.Configuration> configuration(CommandLine commandLine) {
        EnumSet<LTL2LDBAFunction.Configuration> configuration;
        EnumSet<LTL2LDBAFunction.Configuration> enumSet = configuration = commandLine.hasOption(AbstractLTL2LDBAModule.simple().getOpt()) ? EnumSet.noneOf(LTL2LDBAFunction.Configuration.class) : EnumSet.of(LTL2LDBAFunction.Configuration.EAGER_UNFOLD, LTL2LDBAFunction.Configuration.FORCE_JUMPS, LTL2LDBAFunction.Configuration.OPTIMISED_STATE_STRUCTURE, LTL2LDBAFunction.Configuration.SUPPRESS_JUMPS);
        if (commandLine.hasOption(NON_DETERMINISTIC.getOpt())) {
            configuration.add(LTL2LDBAFunction.Configuration.NON_DETERMINISTIC_INITIAL_COMPONENT);
        }
        if (commandLine.hasOption(EPSILON.getOpt())) {
            configuration.add(LTL2LDBAFunction.Configuration.EPSILON_TRANSITIONS);
        }
        return configuration;
    }
}

