/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jhoafparser.analysis.AcceptanceSimplify;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredHeader;
import jhoafparser.storage.StoredState;
import jhoafparser.util.AcceptanceRepositoryStandard;

public class ToNondetBuchi
implements StoredAutomatonManipulator {
    private StoredAutomaton source;
    private StoredAutomaton target;
    private List<BooleanExpression<AtomAcceptance>> accDNF;
    private int copies;
    private int numberOfStates;
    private int numberOfBuchi;
    private BooleanExpression<AtomAcceptance> accExpr;

    public ToNondetBuchi() {
    }

    private ToNondetBuchi(StoredAutomaton aut) throws HOAConsumerException {
        this.source = aut;
        if (this.source.hasUniversalBranching()) {
            throw new HOAConsumerException("Automaton has branching, can only convert (non-)deterministic automata to non-deterministic Buchi");
        }
        if (this.source.hasEdgesImplicit()) {
            throw new HOAConsumerException("Converting to Buchi currently not supported for automata with implicit edges");
        }
        this.acceptanceToDNF();
        this.calcNumberOfBuchi();
        this.numberOfStates = Math.max(this.source.getNumberOfStates(), this.source.getHighestStateIndex() + 1);
        this.target = new StoredAutomaton();
        StoredHeader header = this.source.getStoredHeader().clone();
        this.target.setStoredHeader(header);
        header.setNumberOfStates(this.numberOfStates * (this.copies + 1));
        header.getAcceptanceNames().clear();
        header.provideAcceptanceName("generalized-Buchi", Collections.singletonList(this.numberOfBuchi));
        header.setAcceptanceCondition(this.numberOfBuchi, AcceptanceRepositoryStandard.forGenBuchi(Collections.singletonList(this.numberOfBuchi)));
        this.handleProperties();
        this.handleOriginal();
        for (int copy = 0; copy < this.copies; ++copy) {
            this.handleCopy(copy);
        }
    }

    private void calcNumberOfBuchi() {
        this.numberOfBuchi = 0;
        for (BooleanExpression<AtomAcceptance> clause : this.accDNF) {
            this.numberOfBuchi = Math.max(this.numberOfBuchi, this.countInf(clause));
        }
        if (this.numberOfBuchi == 0) {
            if (this.accExpr.isTRUE()) {
                this.numberOfBuchi = 1;
            } else if (this.accExpr.isFALSE()) {
                this.copies = 0;
            } else {
                this.numberOfBuchi = 1;
            }
        }
    }

    private int countInf(BooleanExpression<AtomAcceptance> acc) {
        switch (acc.getType()) {
            case EXP_AND: 
            case EXP_OR: {
                return this.countInf(acc.getLeft()) + this.countInf(acc.getRight());
            }
            case EXP_ATOM: {
                switch (acc.getAtom().getType()) {
                    case TEMPORAL_FIN: {
                        return 0;
                    }
                    case TEMPORAL_INF: {
                        return 1;
                    }
                }
                break;
            }
            case EXP_FALSE: 
            case EXP_TRUE: {
                return 0;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition: " + acc);
    }

    private Integer stateInOriginal(int t) {
        return t;
    }

    private Integer stateInCopy(int t, int copy) {
        return t + (copy + 1) * this.numberOfStates;
    }

    private List<Integer> gotoState(Integer t) {
        return Collections.singletonList(t);
    }

    private boolean consistentWithAcceptance(List<Integer> accSignature, BooleanExpression<AtomAcceptance> clause) {
        switch (clause.getType()) {
            case EXP_AND: {
                return this.consistentWithAcceptance(accSignature, clause.getLeft()) && this.consistentWithAcceptance(accSignature, clause.getRight());
            }
            case EXP_TRUE: {
                return true;
            }
            case EXP_FALSE: {
                return false;
            }
            case EXP_ATOM: {
                if (clause.getAtom().getType() == AtomAcceptance.Type.TEMPORAL_FIN) {
                    int index = clause.getAtom().getAcceptanceSet();
                    if (clause.getAtom().isNegated()) {
                        return accSignature.contains(index);
                    }
                    return !accSignature.contains(index);
                }
                return true;
            }
            case EXP_OR: {
                throw new UnsupportedOperationException("Acceptance condition has to be in conjunctive form:" + clause);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition:" + clause);
    }

    private List<Integer> translateAcceptance(List<Integer> acceptanceSignature, BooleanExpression<AtomAcceptance> acc, int unused) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        this.translateAcceptance(acceptanceSignature, acc, 0, result);
        for (int i = this.numberOfBuchi - unused; i < this.numberOfBuchi; ++i) {
            result.add(i);
        }
        return result;
    }

    private int translateAcceptance(List<Integer> acceptanceSignature, BooleanExpression<AtomAcceptance> acc, int current, List<Integer> transformedSignature) {
        switch (acc.getType()) {
            case EXP_AND: {
                current = this.translateAcceptance(acceptanceSignature, acc.getLeft(), current, transformedSignature);
                current = this.translateAcceptance(acceptanceSignature, acc.getRight(), current, transformedSignature);
                return current;
            }
            case EXP_ATOM: {
                if (acc.getAtom().getType() == AtomAcceptance.Type.TEMPORAL_INF) {
                    boolean negated = acc.getAtom().isNegated();
                    if (acceptanceSignature.contains(acc.getAtom().getAcceptanceSet()) ^ negated) {
                        transformedSignature.add(current);
                    }
                    return current + 1;
                }
                return current;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in acceptance condition:" + acc);
    }

    private void handleOriginal() {
        for (int s = 0; s < this.numberOfStates; ++s) {
            StoredState original = this.source.getStoredState(s);
            String name = Integer.toString(s);
            if (original == null) {
                this.target.addState(new StoredState(s, name, null, null));
            } else {
                this.target.addState(new StoredState(s, name, original.getLabelExpr(), null));
            }
            if (!this.source.hasEdgesWithLabel(s)) continue;
            for (StoredEdgeWithLabel edge : this.source.getEdgesWithLabel(s)) {
                assert (edge.getConjSuccessors().size() == 1);
                int t = edge.getConjSuccessors().get(0);
                this.target.addEdgeWithLabel(s, new StoredEdgeWithLabel(edge.getLabelExpr(), this.gotoState(this.stateInOriginal(t)), null));
                for (int copy = 0; copy < this.copies; ++copy) {
                    this.target.addEdgeWithLabel(s, new StoredEdgeWithLabel(edge.getLabelExpr(), this.gotoState(this.stateInCopy(t, copy)), null));
                }
            }
        }
    }

    private void handleCopy(int copy) throws HOAConsumerException {
        BooleanExpression<AtomAcceptance> acc = this.accDNF.get(copy);
        int unusedBuchi = this.numberOfBuchi - this.countInf(acc);
        assert (unusedBuchi >= 0);
        for (int s = 0; s < this.numberOfStates; ++s) {
            StoredState original = this.source.getStoredState(s);
            String name = s + "_" + copy;
            Integer s_ = this.stateInCopy(s, copy);
            if (original == null) {
                original = new StoredState(s_, name, null, null);
            }
            boolean makeTerminal = false;
            if (original.getAccSignature() != null) {
                if (!this.consistentWithAcceptance(original.getAccSignature(), acc)) {
                    makeTerminal = true;
                }
                List<Integer> transformedAcceptance = this.translateAcceptance(original.getAccSignature(), acc, unusedBuchi);
                this.target.addState(new StoredState(s_, name, original.getLabelExpr(), transformedAcceptance));
            } else {
                this.target.addState(new StoredState(s_, name, original.getLabelExpr(), null));
            }
            if (makeTerminal || !this.source.hasEdgesWithLabel(s)) continue;
            for (StoredEdgeWithLabel edge : this.source.getEdgesWithLabel(s)) {
                ArrayList<Integer> edgeAccSig;
                assert (edge.getConjSuccessors().size() == 1);
                int t = edge.getConjSuccessors().get(0);
                if (original.getAccSignature() != null) {
                    if (edge.getAccSignature() != null) {
                        throw new HOAConsumerException("Mixing state and edge acceptance signatures not supported");
                    }
                    this.target.addEdgeWithLabel(s_, new StoredEdgeWithLabel(edge.getLabelExpr(), this.gotoState(this.stateInCopy(t, copy)), null));
                    continue;
                }
                ArrayList<Integer> arrayList = edgeAccSig = edge.getAccSignature() != null ? edge.getAccSignature() : new ArrayList<Integer>(0);
                if (!this.consistentWithAcceptance(edgeAccSig, acc)) continue;
                List<Integer> transformedAcceptance = this.translateAcceptance(edgeAccSig, acc, unusedBuchi);
                this.target.addEdgeWithLabel(s_, new StoredEdgeWithLabel(edge.getLabelExpr(), this.gotoState(this.stateInCopy(t, copy)), transformedAcceptance));
            }
        }
    }

    private void handleProperties() throws HOAConsumerException {
        Iterator<String> it = this.target.getStoredHeader().getProperties().iterator();
        block34: while (it.hasNext()) {
            String property;
            switch (property = it.next()) {
                case "state-labels": {
                    continue block34;
                }
                case "trans-labels": {
                    continue block34;
                }
                case "implicit-labels": {
                    it.remove();
                    continue block34;
                }
                case "explicit-labels": {
                    continue block34;
                }
                case "state-acc": {
                    continue block34;
                }
                case "trans-acc": {
                    continue block34;
                }
                case "univ-branch": {
                    throw new HOAConsumerException("Automaton is marked as having universal branching, but conversion to non-det Buchi is not supported");
                }
                case "no-univ-branch": {
                    continue block34;
                }
                case "deterministic": {
                    it.remove();
                    continue block34;
                }
                case "complete": {
                    it.remove();
                    continue block34;
                }
                case "unambiguous": {
                    it.remove();
                    continue block34;
                }
                case "stutter-invariant": {
                    continue block34;
                }
                case "weak": 
                case "very-weak": 
                case "inherently-weak": 
                case "terminal": 
                case "tight": {
                    it.remove();
                    continue block34;
                }
            }
            it.remove();
        }
    }

    private void acceptanceToDNF() {
        this.accExpr = this.source.getStoredHeader().getAcceptanceCondition();
        this.accExpr = AcceptanceSimplify.simplify(this.accExpr);
        this.accDNF = AcceptanceSimplify.toDNF(this.accExpr);
        this.copies = this.accDNF.size();
    }

    @Override
    public StoredAutomaton manipulate(StoredAutomaton aut) throws HOAConsumerException {
        for (StoredHeader.NameAndExtra<List<Object>> accname : aut.getStoredHeader().getAcceptanceNames()) {
            if (!accname.name.equals("Buchi") && !accname.name.equals("generalized-Buchi")) continue;
            return aut;
        }
        ToNondetBuchi transform = new ToNondetBuchi(aut);
        return transform.target;
    }
}

