/*
 *  file gamma_iterator.hh
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */



// fwd decl
template< typename T > class Iterator;



// --------------------------  Aggregate<T>


template< typename T >
class Aggregate
{
public:
  virtual Iterator<T>& CreateIterator() = 0;
};



// --------------------------  Iterator<T>



template< typename T >
class Iterator
{
public:
  virtual void First() = 0;
  virtual void Next() = 0;
  virtual bool IsDone() const = 0;
  virtual T& CurrentItem() = 0;
};



// --------------------------  ConcreteAggregate<T>



template< typename T >
class ConcreteAggregate : public Aggregate<T>
{
public:
  ConcreteAggregate();
  virtual Iterator<T>& CreateIterator();
  const T& value_at( unsigned index ) const;
  T& value_at( unsigned index );
  unsigned size() const;
private:
  T _value[10];
};



// --------------------------  ConcreteIterator<T>



template< typename T >
class ConcreteIterator : public Iterator<T>
{
public:
  ConcreteIterator( ConcreteAggregate<T>& aggregate );
  virtual void First();
  virtual void Next();
  virtual bool IsDone() const;
  virtual T& CurrentItem();
private:
  ConcreteAggregate<T>& _aggregate;
  unsigned _index;
};



// --------------------------  proc



template< typename T >
void add( Aggregate<T>& input, T value );
