/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageState
extends AbstractEntityImage {
    private final TextBlock desc;
    private final TextBlock fields;
    private final Url url;
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;
    private final boolean withSymbol;
    private static final double smallRadius = 3.0;
    private static final double smallLine = 3.0;
    private static final double smallMarginX = 7.0;
    private static final double smallMarginY = 4.0;
    private final LineConfigurable lineConfig;

    public EntityImageState(IEntity entity, ISkinParam skinParam) {
        super(entity, skinParam);
        this.lineConfig = entity;
        Stereotype stereotype = entity.getStereotype();
        this.withSymbol = stereotype != null && stereotype.isWithOOSymbol();
        this.desc = entity.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.STATE, stereotype), HorizontalAlignment.CENTER, skinParam, CreoleMode.FULL, skinParam.wrapWidth());
        Display list = Display.empty();
        for (Member att : entity.getBodier().getFieldsToDisplay()) {
            list = list.addAll(Display.getWithNewlines(att.getDisplay(true)));
        }
        this.url = entity.getUrl99();
        this.fields = list.create(new FontConfiguration(this.getSkinParam(), FontParam.STATE_ATTRIBUTE, stereotype), HorizontalAlignment.LEFT, skinParam, CreoleMode.FULL, skinParam.wrapWidth());
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.fields.calculateDimension(stringBounder));
        double heightSymbol = 0.0;
        if (this.withSymbol) {
            heightSymbol += 10.0;
        }
        Dimension2D result = Dimension2DDouble.delta(dim, 20.0 + heightSymbol);
        return Dimension2DDouble.atLeast(result, 50.0, 50.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        HtmlColor classBorder;
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal, 25.0, 25.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            rect.setDeltaShadow(4.0);
        }
        if ((classBorder = this.lineConfig.getColors(this.getSkinParam()).getColor(ColorType.LINE)) == null) {
            classBorder = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder);
        }
        ug = ug.apply(this.getStroke()).apply(new UChangeColor(classBorder));
        HtmlColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground);
        }
        ug = ug.apply(new UChangeBackColor(backcolor));
        ug.draw(rect);
        double yLine = 5.0 + dimDesc.getHeight() + 5.0;
        ug.apply(new UTranslate(0.0, yLine)).draw(new ULine(widthTotal, 0.0));
        ug = ug.apply(new UStroke());
        if (this.withSymbol) {
            double xSymbol = dimTotal.getWidth();
            double ySymbol = dimTotal.getHeight();
            EntityImageState.drawSymbol(ug, xSymbol, ySymbol);
        }
        double xDesc = (widthTotal - dimDesc.getWidth()) / 2.0;
        double yDesc = 5.0;
        this.desc.drawU(ug.apply(new UTranslate(xDesc, 5.0)));
        double xFields = 5.0;
        double yFields = yLine + 5.0;
        this.fields.drawU(ug.apply(new UTranslate(5.0, yFields)));
        if (this.url != null) {
            ug.closeAction();
        }
    }

    private UStroke getStroke() {
        UStroke stroke = this.lineConfig.getColors(this.getSkinParam()).getSpecificLineStroke();
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    public static void drawSymbol(UGraphic ug, double xSymbol, double ySymbol) {
        UEllipse small = new UEllipse(6.0, 6.0);
        ug.apply(new UTranslate(xSymbol -= 22.0, ySymbol -= 10.0)).draw(small);
        ug.apply(new UTranslate(xSymbol + 3.0 + 6.0, ySymbol)).draw(small);
        ug.apply(new UTranslate(xSymbol + 6.0, ySymbol + 3.0)).draw(new ULine(3.0, 0.0));
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }
}

