/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.EnumMap;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleKind;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueImpl;

public class CommandStyleMultilines
extends CommandMultilines2<UmlDiagram> {
    public static final Pattern2 p1 = MyPattern.cmpile("^([\\w]+)[%s]+(.*)$");

    public CommandStyleMultilines() {
        super(CommandStyleMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^[%s]*\\}[%s]*$";
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandStyleMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(style|stereotype)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(\\w+(?:\\+\\w+)*)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    public boolean syntaxWithFinalBracket() {
        return true;
    }

    @Override
    protected CommandExecutionResult executeNow(UmlDiagram diagram, BlocLines lines) {
        if (SkinParam.USE_STYLES()) {
            lines = lines.trimSmart(1);
            Style modifiedStyle = this.getDeclaredStyle(lines, diagram.getSkinParam().getCurrentStyleBuilder());
            diagram.getSkinParam().muteStyle(modifiedStyle);
        }
        return CommandExecutionResult.ok();
    }

    public Style getDeclaredStyle(BlocLines lines, AutomaticCounter counter) {
        lines = lines.trimSmart(1);
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst499().getTrimmed().getString());
        String name = line0.get("NAME", 0);
        String kind = line0.get("TYPE", 0).toUpperCase();
        if (lines.size() > 1) {
            lines = lines.subExtract(1, 1);
        }
        lines = lines.trim(true);
        EnumMap<PName, Value> map = new EnumMap<PName, Value>(PName.class);
        for (StringLocated s : lines) {
            assert (s.getString().length() > 0);
            Matcher2 m = p1.matcher(s.getString());
            if (!m.find()) {
                throw new IllegalStateException();
            }
            PName key = PName.getFromName(m.group(1));
            String value = m.group(2);
            if (key == null) continue;
            map.put(key, new ValueImpl(value, counter));
        }
        return new Style(StyleKind.valueOf(kind), name, map);
    }
}

