/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import java.util.BitSet;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.XOperator;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.XDepthVisitor;
import owl.translations.delag.History;

final class SatisfactionRelation {
    private SatisfactionRelation() {
    }

    static boolean models(History past, BitSet present, Formula formula) {
        int xDepth = XDepthVisitor.getDepth(formula);
        return xDepth <= past.size() && formula.accept(new Evaluator(past, present, xDepth)) == 1;
    }

    private static class Evaluator
    implements IntVisitor {
        private final History past;
        private final BitSet present;
        private int offset;

        Evaluator(History past, BitSet present, int requiredHistory) {
            this.past = past;
            this.present = present;
            this.offset = past.size() - requiredHistory;
        }

        @Override
        public int visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? 1 : 0;
        }

        @Override
        public int visit(Conjunction conjunction) {
            for (Formula child : conjunction.operands) {
                if (child.accept(this) != 0) continue;
                return 0;
            }
            return 1;
        }

        @Override
        public int visit(Disjunction disjunction) {
            for (Formula child : disjunction.operands) {
                if (child.accept(this) != 1) continue;
                return 1;
            }
            return 0;
        }

        @Override
        public int visit(Literal literal) {
            boolean models = this.offset == this.past.size() ? this.present.get(literal.getAtom()) ^ literal.isNegated() : this.past.get(this.offset, literal);
            return models ? 1 : 0;
        }

        @Override
        public int visit(XOperator xOperator) {
            ++this.offset;
            int models = xOperator.operand().accept(this);
            --this.offset;
            return models;
        }
    }
}

