/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.algorithms;

import java.util.EnumSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.Automaton;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.ltl.Biconditional;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.translations.LtlTranslationRepository;

public final class LanguageAnalysis {
    private LanguageAnalysis() {
    }

    public static boolean isSatisfiable(Formula formula) {
        if (formula instanceof Disjunction) {
            return formula.operands.stream().anyMatch(LanguageAnalysis::isSatisfiable);
        }
        LabelledFormula labelledFormula = LanguageAnalysis.attachDummyAlphabet(formula);
        Function<LabelledFormula, Automaton<?, GeneralizedBuchiAcceptance>> translation = LtlTranslationRepository.defaultTranslation(EnumSet.of(LtlTranslationRepository.Option.SIMPLIFY_FORMULA, LtlTranslationRepository.Option.USE_PORTFOLIO_FOR_SYNTACTIC_LTL_FRAGMENTS), LtlTranslationRepository.BranchingMode.NON_DETERMINISTIC, GeneralizedBuchiAcceptance.class);
        return !LanguageEmptiness.isEmpty(translation.apply(labelledFormula));
    }

    public static boolean isUnsatisfiable(Formula formula) {
        return !LanguageAnalysis.isSatisfiable(formula);
    }

    public static boolean isUniversal(Formula formula) {
        return LanguageAnalysis.isUnsatisfiable(formula.not());
    }

    public static boolean isEqual(Formula formula1, Formula formula2) {
        return !LanguageAnalysis.isSatisfiable(Biconditional.of(formula1, formula2.not()));
    }

    private static LabelledFormula attachDummyAlphabet(Formula formula) {
        return LabelledFormula.of(formula, IntStream.range(0, formula.atomicPropositions(true).length()).mapToObj(i -> "p" + i).collect(Collectors.toUnmodifiableList()));
    }
}

