/*
 * Decompiled with CFR 0.152.
 */
package owl.logic.propositional.sat;

import com.google.common.primitives.ImmutableIntArray;
import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.BddFactory;
import de.tum.in.jbdd.ImmutableBddConfiguration;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.Optional;
import java.util.OptionalInt;
import owl.logic.propositional.sat.IncrementalSolver;

public class JbddIncrementalSolver
implements IncrementalSolver {
    private final Deque<Integer> clausesStack = new ArrayDeque<Integer>();
    private final Bdd bdd;
    private OptionalInt clauseConjunction;

    JbddIncrementalSolver() {
        ImmutableBddConfiguration configuration = ImmutableBddConfiguration.builder().logStatisticsOnShutdown(false).useGlobalComposeCache(false).integrityDuplicatesMaximalSize(50).cacheBinaryDivider(4).cacheTernaryDivider(4).growthFactor(4.0).build();
        this.bdd = BddFactory.buildBddRecursive((int)10000, (BddConfiguration)configuration);
        this.clauseConjunction = OptionalInt.of(this.bdd.trueNode());
    }

    @Override
    public void pushClauses(int ... clauses) {
        int conjunction = this.bdd.trueNode();
        int disjunction = this.bdd.falseNode();
        int max = 0;
        for (int literal : clauses) {
            max = Math.max(Math.abs(literal), max);
        }
        int requiredVariables = Math.max(max - this.bdd.numberOfVariables(), 0);
        if (requiredVariables > 0) {
            this.bdd.createVariables(requiredVariables);
        }
        for (int literal : clauses) {
            if (literal == 0) {
                conjunction = this.bdd.consume(this.bdd.and(conjunction, disjunction), conjunction, disjunction);
                disjunction = this.bdd.falseNode();
                continue;
            }
            disjunction = literal > 0 ? this.bdd.updateWith(this.bdd.or(disjunction, this.bdd.variableNode(literal - 1)), disjunction) : this.bdd.updateWith(this.bdd.or(disjunction, this.bdd.not(this.bdd.variableNode(-literal - 1))), disjunction);
        }
        conjunction = this.bdd.consume(this.bdd.and(conjunction, disjunction), conjunction, disjunction);
        if (this.clauseConjunction.isPresent()) {
            int oldClauseConjunction = this.clauseConjunction.getAsInt();
            this.clauseConjunction = OptionalInt.of(this.bdd.updateWith(this.bdd.and(oldClauseConjunction, conjunction), oldClauseConjunction));
        }
        this.clausesStack.addLast(conjunction);
    }

    @Override
    public void pushClauses(ImmutableIntArray clauses) {
        this.pushClauses(clauses.toArray());
    }

    @Override
    public void popClauses() {
        this.bdd.dereference(this.clausesStack.removeLast().intValue());
        this.clauseConjunction = OptionalInt.empty();
    }

    @Override
    public Optional<BitSet> model() {
        int conjunction = this.clauseConjunction();
        if (conjunction == this.bdd.falseNode()) {
            return Optional.empty();
        }
        BitSet model = new BitSet();
        int currentNode = conjunction;
        while (currentNode != this.bdd.trueNode()) {
            int highNode = this.bdd.high(currentNode);
            if (highNode == this.bdd.falseNode()) {
                currentNode = this.bdd.low(currentNode);
                continue;
            }
            model.set(this.bdd.variable(currentNode));
            currentNode = highNode;
        }
        return Optional.of(model);
    }

    private int clauseConjunction() {
        if (this.clauseConjunction.isEmpty()) {
            int conjunction = this.bdd.trueNode();
            for (int clauses : this.clausesStack) {
                int newConjunction = this.bdd.reference(this.bdd.and(clauses, conjunction));
                this.bdd.dereference(conjunction);
                conjunction = newConjunction;
            }
            this.clauseConjunction = OptionalInt.of(conjunction);
        }
        return this.clauseConjunction.getAsInt();
    }
}

