/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.bitset.SparseBitSets;
import de.tum.in.naturals.set.BoundedMutableSingletonNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.BoundedWrapper;
import de.tum.in.naturals.set.FixedSizeNatBitSet;
import de.tum.in.naturals.set.ForwardingNatBitSet;
import de.tum.in.naturals.set.LongBoundedNatBitSet;
import de.tum.in.naturals.set.LongNatBitSet;
import de.tum.in.naturals.set.MutableSingletonNatBitSet;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSetComplementIterator;
import de.tum.in.naturals.set.NatBitSetComplementReverseIterator;
import de.tum.in.naturals.set.NatBitSetFactory;
import de.tum.in.naturals.set.PowerNatBitSet;
import de.tum.in.naturals.set.ReverseRangeIterator;
import de.tum.in.naturals.set.RoaringBoundedNatBitSet;
import de.tum.in.naturals.set.RoaringNatBitSet;
import de.tum.in.naturals.set.RoaringNatBitSetFactory;
import de.tum.in.naturals.set.SimpleBoundedNatBitSet;
import de.tum.in.naturals.set.SimpleNatBitSet;
import de.tum.in.naturals.set.SparseBoundedNatBitSet;
import de.tum.in.naturals.set.SparseNatBitSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnegative;
import org.roaringbitmap.RoaringBitmap;

public final class NatBitSets {
    public static final int UNKNOWN_LENGTH = -1;
    public static final int UNKNOWN_SIZE = -1;
    private static NatBitSetFactory factory = new RoaringNatBitSetFactory();

    private NatBitSets() {
    }

    public static IntIterator complementIterator(NatBitSet set, @Nonnegative int length) {
        if (set.isEmpty() || set.firstInt() >= length) {
            return IntIterators.fromTo((int)0, (int)length);
        }
        if (set instanceof FixedSizeNatBitSet) {
            int size = set.size();
            if (size >= length) {
                return IntIterators.EMPTY_ITERATOR;
            }
            return IntIterators.fromTo((int)size, (int)length);
        }
        if (set instanceof MutableSingletonNatBitSet) {
            int element = set.firstInt();
            if (element == 0) {
                return IntIterators.fromTo((int)1, (int)length);
            }
            if (length <= element + 1) {
                return IntIterators.fromTo((int)0, (int)length);
            }
            return IntIterators.concat((IntIterator[])new IntIterator[]{IntIterators.fromTo((int)0, (int)element), IntIterators.fromTo((int)(element + 1), (int)length)});
        }
        return IntIterators.unmodifiable((IntIterator)new NatBitSetComplementIterator(set, length));
    }

    public static IntIterator complementReverseIterator(NatBitSet set, @Nonnegative int length) {
        if (set.isEmpty() || set.firstInt() >= length) {
            return new ReverseRangeIterator(0, length);
        }
        if (set instanceof FixedSizeNatBitSet) {
            int size = set.size();
            if (size >= length) {
                return IntIterators.EMPTY_ITERATOR;
            }
            return new ReverseRangeIterator(size, length);
        }
        if (set instanceof MutableSingletonNatBitSet) {
            int element = set.firstInt();
            if (element == 0) {
                return new ReverseRangeIterator(1, length);
            }
            if (length <= element + 1) {
                return IntIterators.fromTo((int)0, (int)length);
            }
            ReverseRangeIterator firstIterator = new ReverseRangeIterator(element + 1, length);
            ReverseRangeIterator secondIterator = new ReverseRangeIterator(0, element);
            return IntIterators.concat((IntIterator[])new IntIterator[]{firstIterator, secondIterator});
        }
        return IntIterators.unmodifiable((IntIterator)new NatBitSetComplementReverseIterator(set, length));
    }

    public static NatBitSet longSet() {
        return new LongNatBitSet();
    }

    public static NatBitSet simpleSet() {
        return new SimpleNatBitSet(new BitSet());
    }

    public static NatBitSet simpleSet(@Nonnegative int expectedSize) {
        return new SimpleNatBitSet(new BitSet(expectedSize));
    }

    public static NatBitSet sparseSet() {
        return new SparseNatBitSet(new SparseBitSet());
    }

    public static NatBitSet sparseSet(@Nonnegative int expectedSize) {
        return new SparseNatBitSet(new SparseBitSet(expectedSize));
    }

    public static NatBitSet roaringSet() {
        return new RoaringNatBitSet(new RoaringBitmap());
    }

    public static NatBitSet asSet(BitSet bitSet) {
        return new SimpleNatBitSet(bitSet);
    }

    public static NatBitSet asSet(SparseBitSet bitSet) {
        return new SparseNatBitSet(bitSet);
    }

    public static NatBitSet asSet(IntSortedSet set) {
        assert (set.isEmpty() || set.firstInt() >= 0);
        return new ForwardingNatBitSet(set);
    }

    public static BoundedNatBitSet boundedLongSet(int domainSize) {
        return new LongBoundedNatBitSet(domainSize);
    }

    public static BoundedNatBitSet boundedSimpleSet(int domainSize) {
        return new SimpleBoundedNatBitSet(new BitSet(), domainSize);
    }

    public static BoundedNatBitSet boundedSparseSet(int domainSize) {
        return new SparseBoundedNatBitSet(new SparseBitSet(), domainSize);
    }

    public static BoundedNatBitSet boundedRoaringSet(int domainSize) {
        return new RoaringBoundedNatBitSet(new RoaringBitmap(), domainSize);
    }

    public static BoundedNatBitSet asBoundedSet(BitSet bitSet, int domainSize) {
        return new SimpleBoundedNatBitSet(bitSet, domainSize);
    }

    public static BoundedNatBitSet asBoundedSet(SparseBitSet bitSet, int domainSize) {
        return new SparseBoundedNatBitSet(bitSet, domainSize);
    }

    public static BoundedNatBitSet asBounded(NatBitSet set, @Nonnegative int domainSize) {
        assert (domainSize >= 0);
        if (!set.isEmpty() && set.lastInt() >= domainSize) {
            throw new IndexOutOfBoundsException();
        }
        if (set instanceof BoundedNatBitSet) {
            BoundedNatBitSet boundedSet = (BoundedNatBitSet)set;
            int oldDomainSize = boundedSet.domainSize();
            if (oldDomainSize != domainSize) {
                throw new IllegalArgumentException(String.format("Given set has domain size %d, expected %d", boundedSet.domainSize(), domainSize));
            }
            return boundedSet;
        }
        if (set instanceof SimpleNatBitSet) {
            SimpleNatBitSet simpleSet = (SimpleNatBitSet)set;
            return new SimpleBoundedNatBitSet(simpleSet.getBitSet(), domainSize);
        }
        if (set instanceof SparseNatBitSet) {
            SparseNatBitSet sparseSet = (SparseNatBitSet)set;
            return new SparseBoundedNatBitSet(sparseSet.getBitSet(), domainSize);
        }
        if (set instanceof LongNatBitSet) {
            LongNatBitSet longSet = (LongNatBitSet)set;
            return new LongBoundedNatBitSet(longSet.getStore(), domainSize);
        }
        if (set instanceof MutableSingletonNatBitSet) {
            MutableSingletonNatBitSet singletonSet = (MutableSingletonNatBitSet)set;
            return singletonSet.isEmpty() ? new BoundedMutableSingletonNatBitSet(domainSize) : new BoundedMutableSingletonNatBitSet(singletonSet.firstInt(), domainSize);
        }
        return new BoundedWrapper(set, domainSize);
    }

    public static NatBitSet emptySet() {
        return new MutableSingletonNatBitSet();
    }

    public static BoundedNatBitSet boundedEmptySet(@Nonnegative int domainSize) {
        return new FixedSizeNatBitSet(domainSize).complement();
    }

    public static NatBitSet singleton(@Nonnegative int element) {
        return new MutableSingletonNatBitSet(element);
    }

    public static BoundedNatBitSet boundedSingleton(int domainSize, int element) {
        return new BoundedMutableSingletonNatBitSet(element, domainSize);
    }

    public static BoundedNatBitSet boundedFullSet(@Nonnegative int length) {
        return new FixedSizeNatBitSet(length);
    }

    public static Set<NatBitSet> powerSet(NatBitSet basis) {
        if (basis.isEmpty()) {
            return Collections.singleton(NatBitSets.emptySet());
        }
        return new PowerNatBitSet(basis);
    }

    public static Set<NatBitSet> powerSet(@Nonnegative int domainSize) {
        return NatBitSets.powerSet(NatBitSets.boundedFullSet(domainSize));
    }

    public static BitSet toBitSet(NatBitSet indices) {
        if (indices.isEmpty()) {
            return new BitSet(0);
        }
        if (indices instanceof SimpleNatBitSet) {
            return (BitSet)((SimpleNatBitSet)indices).getBitSet().clone();
        }
        if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet boundedSet = (SimpleBoundedNatBitSet)indices;
            BitSet bitSet = (BitSet)boundedSet.getBitSet().clone();
            if (boundedSet.isComplement()) {
                bitSet.flip(0, boundedSet.domainSize());
            }
            return bitSet;
        }
        if (indices instanceof SparseNatBitSet) {
            return BitSets.of(((SparseNatBitSet)indices).getBitSet());
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet boundedSet = (SparseBoundedNatBitSet)indices;
            if (boundedSet.isComplement()) {
                BitSet bitSet = new BitSet(boundedSet.domainSize());
                boundedSet.forEach(bitSet::set);
                return bitSet;
            }
            return BitSets.of(boundedSet.getBitSet());
        }
        BitSet bitSet = new BitSet(indices.lastInt() + 1);
        indices.forEach(bitSet::set);
        return bitSet;
    }

    public static SparseBitSet toSparseBitSet(NatBitSet indices) {
        if (indices.isEmpty()) {
            return new SparseBitSet(1);
        }
        if (indices instanceof SimpleNatBitSet) {
            return SparseBitSets.of(((SimpleNatBitSet)indices).getBitSet());
        }
        if (indices instanceof SimpleBoundedNatBitSet) {
            SimpleBoundedNatBitSet boundedSet = (SimpleBoundedNatBitSet)indices;
            if (boundedSet.isComplement()) {
                SparseBitSet bitSet = new SparseBitSet(boundedSet.domainSize());
                boundedSet.forEach(arg_0 -> ((SparseBitSet)bitSet).set(arg_0));
                return bitSet;
            }
            return SparseBitSets.of(boundedSet.getBitSet());
        }
        if (indices instanceof SparseNatBitSet) {
            return ((SparseNatBitSet)indices).getBitSet().clone();
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet boundedSet = (SparseBoundedNatBitSet)indices;
            SparseBitSet bitSet = boundedSet.getBitSet().clone();
            if (boundedSet.isComplement()) {
                bitSet.flip(0, boundedSet.domainSize());
            }
            return bitSet;
        }
        SparseBitSet bitSet = new SparseBitSet(indices.lastInt() + 1);
        indices.forEach(arg_0 -> ((SparseBitSet)bitSet).set(arg_0));
        return bitSet;
    }

    public static RoaringBitmap toRoaringBitmap(NatBitSet indices) {
        if (indices.isEmpty()) {
            return new RoaringBitmap();
        }
        if (indices instanceof RoaringNatBitSet) {
            return ((RoaringNatBitSet)indices).bitmap().clone();
        }
        if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet boundedSet = (RoaringBoundedNatBitSet)indices;
            RoaringBitmap bitmap = boundedSet.bitmap().clone();
            if (boundedSet.isComplement()) {
                bitmap.flip(0L, (long)boundedSet.domainSize());
            }
            return bitmap;
        }
        RoaringBitmap bitmap = new RoaringBitmap();
        indices.forEach(arg_0 -> ((RoaringBitmap)bitmap).add(arg_0));
        return bitmap;
    }

    public static void setFactory(NatBitSetFactory factory) {
        Objects.requireNonNull(factory);
        NatBitSets.factory = factory;
    }

    public static boolean isModifiable(NatBitSet set) {
        return factory.isModifiable(set);
    }

    public static boolean isModifiable(BoundedNatBitSet set) {
        return factory.isModifiable(set);
    }

    public static boolean isModifiable(NatBitSet set, @Nonnegative int length) {
        return factory.isModifiable(set, length);
    }

    public static BoundedNatBitSet boundedFilledSet(int domainSize) {
        return factory.boundedFilledSet(domainSize);
    }

    public static BoundedNatBitSet boundedFilledSet(int domainSize, int expectedSize) {
        return factory.boundedFilledSet(domainSize, expectedSize);
    }

    public static BoundedNatBitSet boundedSet(int domainSize) {
        return factory.boundedSet(domainSize, -1);
    }

    public static BoundedNatBitSet boundedSet(int domainSize, int expectedSize) {
        return factory.boundedSet(domainSize, expectedSize);
    }

    public static NatBitSet compact(NatBitSet set) {
        return factory.compact(set, false);
    }

    public static NatBitSet compact(NatBitSet set, boolean forceCopy) {
        return factory.compact(set, forceCopy);
    }

    public static NatBitSet copyOf(Collection<Integer> indices) {
        return factory.copyOf(indices);
    }

    public static BoundedNatBitSet ensureBounded(NatBitSet set, @Nonnegative int domainSize) {
        return factory.ensureBounded(set, domainSize);
    }

    public static NatBitSet ensureModifiable(NatBitSet set) {
        return factory.ensureModifiable(set);
    }

    public static NatBitSet ensureModifiable(NatBitSet set, @Nonnegative int length) {
        return factory.ensureModifiable(set, length);
    }

    public static NatBitSet ensureModifiable(BoundedNatBitSet set) {
        return factory.ensureModifiable(set);
    }

    public static NatBitSet modifiableCopyOf(NatBitSet set) {
        return factory.modifiableCopyOf(set);
    }

    public static NatBitSet modifiableCopyOf(NatBitSet set, @Nonnegative int length) {
        return factory.modifiableCopyOf(set, length);
    }

    public static BoundedNatBitSet modifiableCopyOf(BoundedNatBitSet set) {
        return factory.modifiableCopyOf(set);
    }

    public static NatBitSet set(int expectedSize, int expectedLength) {
        return factory.set(expectedSize, expectedLength);
    }

    public static NatBitSet set() {
        return factory.set();
    }

    public static NatBitSet setWithExpectedLength(@Nonnegative int expectedLength) {
        return factory.setWithExpectedLength(expectedLength);
    }

    public static NatBitSet setWithExpectedSize(@Nonnegative int expectedSize) {
        return factory.setWithExpectedSize(expectedSize);
    }

    public static NatBitSet setWithMaximalLength(int maximalLength) {
        return factory.setWithExpectedSize(maximalLength);
    }
}

