/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.AbstractBoundedNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSetsUtil;
import de.tum.in.naturals.set.ReverseRangeIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.SortedSet;

final class FixedSizeNatBitSet
extends AbstractBoundedNatBitSet {
    private final boolean complement;
    private final FixedSizeNatBitSet complementView;

    FixedSizeNatBitSet(int domainSize) {
        super(domainSize);
        if (domainSize == 0) {
            this.complement = true;
            this.complementView = this;
        } else {
            this.complement = false;
            this.complementView = new FixedSizeNatBitSet(this);
        }
    }

    private FixedSizeNatBitSet(FixedSizeNatBitSet other) {
        super(other.domainSize());
        this.complement = !other.complement;
        this.complementView = other;
    }

    @Override
    boolean isComplement() {
        return this.complement;
    }

    public boolean isEmpty() {
        return this.complement;
    }

    public int size() {
        return this.isEmpty() ? 0 : this.domainSize();
    }

    public boolean contains(int index) {
        return !this.complement && this.inDomain(index);
    }

    public boolean containsAll(IntCollection indices) {
        if (indices.isEmpty()) {
            return true;
        }
        if (this.complement) {
            return false;
        }
        if (indices instanceof NatBitSet) {
            NatBitSet natBitSet = (NatBitSet)indices;
            return natBitSet.lastInt() < this.domainSize();
        }
        if (indices instanceof IntSortedSet) {
            IntSortedSet sortedSet = (IntSortedSet)indices;
            return 0 <= sortedSet.firstInt() && sortedSet.lastInt() < this.domainSize();
        }
        if (indices instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)indices;
            return 0 <= (Integer)sortedSet.first() && (Integer)sortedSet.last() < this.domainSize();
        }
        IntIterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int firstInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return 0;
    }

    @Override
    public int lastInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.domainSize() - 1;
    }

    @Override
    public int nextPresentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.complement) {
            return -1;
        }
        return index < this.domainSize() ? index : -1;
    }

    @Override
    public int nextAbsentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.complement) {
            return index;
        }
        return Math.max(index, this.domainSize());
    }

    @Override
    public int previousPresentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.complement) {
            return -1;
        }
        return index >= this.domainSize() ? this.domainSize() - 1 : index;
    }

    @Override
    public int previousAbsentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.complement) {
            return index;
        }
        return index >= this.domainSize() ? index : -1;
    }

    @Override
    public IntIterator iterator() {
        return this.isEmpty() ? IntIterators.EMPTY_ITERATOR : IntIterators.fromTo((int)0, (int)this.domainSize());
    }

    @Override
    public IntIterator reverseIterator() {
        return this.isEmpty() ? IntIterators.EMPTY_ITERATOR : new ReverseRangeIterator(0, this.domainSize());
    }

    @Override
    public void set(int index) {
        this.checkInDomain(index);
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, boolean value) {
        this.checkInDomain(index);
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int from, int to) {
        this.checkInDomain(from, to);
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear(int index) {
        this.checkInDomain(index);
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear(int from, int to) {
        this.checkInDomain(from, to);
        throw new UnsupportedOperationException();
    }

    @Override
    public void flip(int index) {
        this.checkInDomain(index);
        throw new UnsupportedOperationException();
    }

    @Override
    public void flip(int from, int to) {
        this.checkInDomain(from, to);
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean intersects(Collection<Integer> indices) {
        if (this.isEmpty() || indices.isEmpty()) {
            return false;
        }
        if (indices instanceof IntCollection) {
            IntCollection intIndices = (IntCollection)indices;
            if (indices instanceof NatBitSet) {
                NatBitSet natBitSet = (NatBitSet)((Object)indices);
                return this.contains(natBitSet.firstInt());
            }
            if (indices instanceof IntSortedSet) {
                IntSortedSet sortedInts = (IntSortedSet)indices;
                return !sortedInts.subSet(0, this.domainSize()).isEmpty();
            }
            if (indices.size() <= this.domainSize()) {
                return IntIterators.any((IntIterator)intIndices.iterator(), this::contains);
            }
            return IntIterators.any((IntIterator)this.iterator(), indices::contains);
        }
        return super.intersects(indices);
    }

    @Override
    public FixedSizeNatBitSet clone() {
        return this;
    }

    @Override
    public BoundedNatBitSet complement() {
        return this.complementView;
    }
}

