/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.degeneralization;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import owl.automaton.AbstractImmutableAutomaton;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.degeneralization.AutoValue_BuchiDegeneralization_IndexedState;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;

public final class BuchiDegeneralization {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("buchi-degeneralization", "Converts generalized B\u00fcchi automata into B\u00fcchi automata.", (commandLine, environment) -> OwlModule.AutomatonTransformer.of(BuchiDegeneralization::degeneralize, GeneralizedBuchiAcceptance.class));

    private BuchiDegeneralization() {
    }

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.HOA_INPUT_MODULE, List.of(AcceptanceOptimizations.MODULE), MODULE, List.of(AcceptanceOptimizations.MODULE), OutputWriters.HOA_OUTPUT_MODULE));
    }

    public static <S> Automaton<IndexedState<S>, BuchiAcceptance> degeneralize(final Automaton<S, GeneralizedBuchiAcceptance> automaton) {
        Set<IndexedState> initialStates = Collections3.transformSet(automaton.initialStates(), IndexedState::of);
        return new AbstractImmutableAutomaton<IndexedState<S>, BuchiAcceptance>(automaton.factory(), initialStates, BuchiAcceptance.INSTANCE){
            private final Automaton<S, GeneralizedBuchiAcceptance> backingAutomaton;
            private final int sets;
            {
                super(factory, initialStates, acceptance);
                this.backingAutomaton = automaton;
                this.sets = this.backingAutomaton.acceptance().acceptanceSets();
            }

            @Override
            public Set<Edge<IndexedState<S>>> edges(IndexedState<S> state, BitSet valuation) {
                return this.transformEdges(this.backingAutomaton.edges(state.state()), state.index());
            }

            @Override
            public Map<Edge<IndexedState<S>>, ValuationSet> edgeMap(IndexedState<S> state) {
                return Collections3.transformMap(this.backingAutomaton.edgeMap(state.state()), edge -> this.transformEdge((Edge)edge, state.index()));
            }

            @Override
            public ValuationTree<Edge<IndexedState<S>>> edgeTree(IndexedState<S> state) {
                return this.backingAutomaton.edgeTree(state.state()).map(edges -> this.transformEdges((Set)edges, state.index()));
            }

            @Override
            public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
                return this.backingAutomaton.preferredEdgeAccess();
            }

            private Set<Edge<IndexedState<S>>> transformEdges(Set<Edge<S>> edges, int currentIndex) {
                return Collections3.transformSet(edges, edge -> this.transformEdge((Edge)edge, currentIndex));
            }

            private Edge<IndexedState<S>> transformEdge(Edge<S> edge, int currentIndex) {
                boolean accepting;
                int nextIndex;
                for (nextIndex = currentIndex; nextIndex < this.sets && edge.inSet(nextIndex); ++nextIndex) {
                }
                boolean bl = accepting = nextIndex == this.sets;
                while (nextIndex < currentIndex && edge.inSet(nextIndex)) {
                    ++nextIndex;
                }
                if (accepting) {
                    return Edge.of(IndexedState.of(edge.successor()), 0);
                }
                return Edge.of(IndexedState.of(edge.successor(), nextIndex));
            }
        };
    }

    @AutoValue
    public static abstract class IndexedState<S>
    implements AnnotatedState<S> {
        @Override
        public abstract S state();

        public abstract int index();

        public static <S> IndexedState<S> of(S state) {
            return IndexedState.of(state, 0);
        }

        public static <S> IndexedState<S> of(S state, int index) {
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
            return new AutoValue_BuchiDegeneralization_IndexedState<S>(state, index);
        }
    }
}

