/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.AbstractBdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.ImmutableBddConfiguration;
import de.tum.in.jbdd.MathUtil;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.function.BiConsumer;

public class BddIterative
extends AbstractBdd {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] cacheStackHash = EMPTY_INT_ARRAY;
    private int[] cacheStackFirstArg = EMPTY_INT_ARRAY;
    private int[] cacheStackSecondArg = EMPTY_INT_ARRAY;
    private int[] cacheStackThirdArg = EMPTY_INT_ARRAY;
    private int[] branchStackParentVar = EMPTY_INT_ARRAY;
    private int[] branchStackFirstArg = EMPTY_INT_ARRAY;
    private int[] branchStackSecondArg = EMPTY_INT_ARRAY;
    private int[] branchStackThirdArg = EMPTY_INT_ARRAY;

    BddIterative(int nodeSize) {
        this(nodeSize, ImmutableBddConfiguration.builder().build());
    }

    BddIterative(int nodeSize, BddConfiguration configuration) {
        super(nodeSize, configuration);
    }

    @Override
    protected void afterVariableCountChanged() {
        this.growStacks();
    }

    private void growStacks() {
        int minimumSize = this.numberOfVariables + 2;
        if (this.cacheStackHash.length > minimumSize) {
            return;
        }
        this.cacheStackHash = new int[minimumSize * 2];
        this.cacheStackFirstArg = new int[minimumSize * 2];
        this.cacheStackSecondArg = new int[minimumSize * 2];
        this.cacheStackThirdArg = new int[minimumSize * 2];
        this.branchStackParentVar = new int[minimumSize * 2];
        this.branchStackFirstArg = new int[minimumSize * 2];
        this.branchStackSecondArg = new int[minimumSize * 2];
        this.branchStackThirdArg = new int[minimumSize * 2];
    }

    @Override
    public void forEachPath(int node, int highestVariable, BiConsumer<BitSet, BitSet> action) {
        assert (this.isNodeValidOrRoot(node) && highestVariable >= 0);
        if (node == 0) {
            return;
        }
        if (node == 1) {
            action.accept(new BitSet(0), new BitSet(0));
            return;
        }
        int numberOfVariables = this.numberOfVariables();
        int depthLimit = Math.min(highestVariable, numberOfVariables);
        BitSet path = new BitSet(depthLimit);
        BitSet pathSupport = new BitSet(depthLimit);
        this.forEachPathIterative(node, depthLimit, path, pathSupport, action, 0);
    }

    public void forEachPathIterative(int node, int highestVariable, BitSet path, BitSet pathSupport, BiConsumer<BitSet, BitSet> action, int baseStackIndex) {
        int[] branchStackParentVariable = this.branchStackParentVar;
        int[] branchStackNode = this.branchStackFirstArg;
        int stackIndex = baseStackIndex;
        int current = node;
        while (true) {
            long store;
            int variable;
            assert (stackIndex >= baseStackIndex);
            while (current != 1 && (variable = (int)BddIterative.getVariableFromStore(store = this.getNodeStore(current))) <= highestVariable) {
                int lowNode = (int)BddIterative.getLowFromStore(store);
                int highNode = (int)BddIterative.getHighFromStore(store);
                if (lowNode == 0) {
                    assert (highNode != 0);
                    branchStackNode[stackIndex] = 0;
                    path.set(variable);
                    current = highNode;
                } else {
                    branchStackNode[stackIndex] = highNode;
                    current = lowNode;
                }
                pathSupport.set(variable);
                branchStackParentVariable[stackIndex] = variable;
                ++stackIndex;
            }
            action.accept(path, pathSupport);
            do {
                if (stackIndex != baseStackIndex) continue;
                return;
            } while ((current = branchStackNode[--stackIndex]) == 0);
            int variable2 = branchStackParentVariable[stackIndex];
            path.set(variable2);
            path.clear(variable2 + 1, Integer.MAX_VALUE);
            pathSupport.clear(variable2 + 1, Integer.MAX_VALUE);
        }
    }

    @Override
    public void support(int node, BitSet bitSet, int variableCutoff) {
        assert (this.isNodeValidOrRoot(node));
        assert (0 <= variableCutoff);
        this.supportIterative(node, bitSet, variableCutoff, 0);
        this.unMarkAllBelow(node);
    }

    private void supportIterative(int node, BitSet bitSet, int variableCutoff, int baseStackIndex) {
        int[] branchStackNode = this.branchStackFirstArg;
        int stackIndex = baseStackIndex;
        int current = node;
        while (true) {
            int variable;
            long store;
            assert (stackIndex >= baseStackIndex);
            while (!this.isNodeRoot(current) && !BddIterative.isNodeStoreMarked(store = this.getNodeStore(current)) && (variable = (int)BddIterative.getVariableFromStore(store)) < variableCutoff) {
                int highNode;
                bitSet.set(variable);
                this.markNode(node);
                int lowNode = (int)BddIterative.getLowFromStore(store);
                branchStackNode[stackIndex] = highNode = (int)BddIterative.getHighFromStore(store);
                current = lowNode;
                ++stackIndex;
            }
            if (stackIndex == baseStackIndex) {
                return;
            }
            current = branchStackNode[--stackIndex];
        }
    }

    @Override
    public BigInteger countSatisfyingAssignments(int node) {
        assert (this.isNodeValidOrRoot(node));
        if (node == 0) {
            return BigInteger.ZERO;
        }
        if (node == 1) {
            return TWO.pow(this.numberOfVariables);
        }
        long nodeStore = this.getNodeStore(node);
        int variable = (int)BddIterative.getVariableFromStore(nodeStore);
        return TWO.pow(variable).multiply(this.countSatisfyingAssignmentsIterative(node, 0));
    }

    private BigInteger countSatisfyingAssignmentsIterative(int node, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheStackArg = this.cacheStackFirstArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchTaskStack = this.branchStackFirstArg;
        BigInteger[] resultStack = new BigInteger[this.numberOfVariables];
        int stackIndex = baseStackIndex;
        int current = node;
        while (true) {
            int parentVar;
            int nodeVar;
            BigInteger result;
            assert (stackIndex >= baseStackIndex);
            do {
                if (current == 0) {
                    nodeVar = this.numberOfVariables;
                    result = BigInteger.ZERO;
                    continue;
                }
                if (current == 1) {
                    nodeVar = this.numberOfVariables;
                    result = BigInteger.ONE;
                    continue;
                }
                long nodeStore = this.getNodeStore(current);
                nodeVar = (int)BddIterative.getVariableFromStore(nodeStore);
                result = this.cache.lookupSatisfaction(current);
                if (result != null) continue;
                int lowNode = (int)BddIterative.getLowFromStore(nodeStore);
                int highNode = (int)BddIterative.getHighFromStore(nodeStore);
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheStackArg[stackIndex] = current;
                branchStackParentVar[stackIndex] = nodeVar;
                branchTaskStack[stackIndex] = highNode;
                current = lowNode;
                ++stackIndex;
            } while (result == null);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                if (result.signum() > 0) {
                    result = result.multiply(TWO.pow(nodeVar - variable - 1));
                }
                nodeVar = variable;
                result = result.add(resultStack[stackIndex]);
                this.cache.putSatisfaction(cacheStackHash[stackIndex], cacheStackArg[stackIndex], result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            resultStack[stackIndex] = result.multiply(TWO.pow(nodeVar - parentVar - 1));
            current = branchTaskStack[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int conjunction(int ... variables) {
        int node = 1;
        for (int variable : variables) {
            this.pushToWorkStack(node);
            node = this.andIterative(node, this.variableNodes[variable], 0);
            this.popWorkStack();
        }
        return node;
    }

    @Override
    public int conjunction(BitSet variables) {
        int node = 1;
        int currentVariableNumber = variables.nextSetBit(0);
        while (currentVariableNumber != -1) {
            this.pushToWorkStack(node);
            node = this.andIterative(node, this.variableNodes[currentVariableNumber], 0);
            this.popWorkStack();
            currentVariableNumber = variables.nextSetBit(currentVariableNumber + 1);
        }
        return node;
    }

    @Override
    public int disjunction(int ... variables) {
        int node = 0;
        for (int variable : variables) {
            this.pushToWorkStack(node);
            node = this.orIterative(node, this.variableNodes[variable], 0);
            this.popWorkStack();
        }
        return node;
    }

    @Override
    public int disjunction(BitSet variables) {
        int node = 0;
        int currentVariableNumber = variables.nextSetBit(0);
        while (currentVariableNumber != -1) {
            this.pushToWorkStack(node);
            node = this.orIterative(node, this.variableNodes[currentVariableNumber], 0);
            this.popWorkStack();
            currentVariableNumber = variables.nextSetBit(currentVariableNumber + 1);
        }
        return node;
    }

    @Override
    public int and(int node1, int node2) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.andIterative(node1, node2, 0);
        this.popWorkStack(2);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int andIterative(int node1, int node2, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheStackLeft = this.cacheStackFirstArg;
        int[] cacheStackRight = this.cacheStackSecondArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchStackLeft = this.branchStackFirstArg;
        int[] branchStackRight = this.branchStackSecondArg;
        int stackIndex = baseStackIndex;
        int current1 = node1;
        int current2 = node2;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            do {
                if (current1 == current2 || current2 == 1) {
                    result = current1;
                    continue;
                }
                if (current1 == 0 || current2 == 0) {
                    result = 0;
                    continue;
                }
                if (current1 == 1) {
                    result = current2;
                    continue;
                }
                long node1store = this.getNodeStore(current1);
                long node2store = this.getNodeStore(current2);
                int node1var = (int)BddIterative.getVariableFromStore(node1store);
                int node2var = (int)BddIterative.getVariableFromStore(node2store);
                if (node2var < node1var || node2var == node1var && current2 < current1) {
                    int nodeSwap = current1;
                    current1 = current2;
                    current2 = nodeSwap;
                    int varSwap = node1var;
                    node1var = node2var;
                    node2var = varSwap;
                    long storeSwap = node1store;
                    node1store = node2store;
                    node2store = storeSwap;
                }
                if (this.cache.lookupAnd(current1, current2)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheStackLeft[stackIndex] = current1;
                cacheStackRight[stackIndex] = current2;
                assert (this.isNodeValid(current1) && this.isNodeValid(current2));
                branchStackParentVar[stackIndex] = node1var;
                branchStackLeft[stackIndex] = (int)BddIterative.getHighFromStore(node1store);
                if (node1var == node2var) {
                    branchStackRight[stackIndex] = (int)BddIterative.getHighFromStore(node2store);
                    current2 = (int)BddIterative.getLowFromStore(node2store);
                } else {
                    branchStackRight[stackIndex] = current2;
                }
                current1 = (int)BddIterative.getLowFromStore(node1store);
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                int left = cacheStackLeft[stackIndex];
                int right = cacheStackRight[stackIndex];
                this.cache.putAnd(cacheStackHash[stackIndex], left, right, result);
                this.popWorkStack(2);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current1 = branchStackLeft[stackIndex];
            current2 = branchStackRight[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int compose(int node, int[] variableNodes) {
        int hash;
        assert (this.isWorkStackEmpty());
        assert (variableNodes.length <= this.numberOfVariables);
        if (node == 1 || node == 0) {
            return node;
        }
        this.pushToWorkStack(node);
        int workStackCount = 1;
        for (int i = 0; i < variableNodes.length; ++i) {
            int variableNode = variableNodes[i];
            if (variableNode == -1) {
                variableNodes[i] = this.variableNodes[i];
                continue;
            }
            assert (this.isNodeValidOrRoot(variableNode));
            if (this.isNodeSaturated(variableNode)) continue;
            this.pushToWorkStack(variableNode);
            ++workStackCount;
        }
        int highestReplacedVariable = variableNodes.length - 1;
        for (int i = variableNodes.length - 1; i >= 0; --i) {
            if (variableNodes[i] == -1) continue;
            highestReplacedVariable = i;
            break;
        }
        if (highestReplacedVariable == -1) {
            this.popWorkStack(workStackCount);
            return node;
        }
        if (this.getConfiguration().useGlobalComposeCache()) {
            if (this.cache.lookupCompose(node, variableNodes)) {
                this.popWorkStack(workStackCount);
                return this.cache.getLookupResult();
            }
            hash = this.cache.getLookupHash();
        } else {
            hash = -1;
        }
        this.cache.clearVolatileCache();
        int result = this.composeIterative(node, variableNodes, highestReplacedVariable);
        if (this.getConfiguration().useGlobalComposeCache()) {
            this.cache.putCompose(hash, node, variableNodes, result);
        }
        this.popWorkStack(workStackCount);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int composeIterative(int node, int[] variableNodes, int highestReplacedVariable) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheArgStack = this.cacheStackFirstArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchTaskStack = this.branchStackFirstArg;
        int initialSize = this.workStackSize();
        int stackIndex = 0;
        int current = node;
        while (true) {
            int parentVar;
            assert (stackIndex >= 0);
            assert (this.workStackSize() >= initialSize);
            int result = -1;
            do {
                if (current == 1 || current == 0) {
                    result = current;
                    continue;
                }
                long nodeStore = this.getNodeStore(current);
                int nodeVariable = (int)BddIterative.getVariableFromStore(nodeStore);
                if (nodeVariable > highestReplacedVariable) {
                    result = current;
                    continue;
                }
                int replacementNode = variableNodes[nodeVariable];
                if (replacementNode == 1) {
                    current = (int)BddIterative.getHighFromStore(nodeStore);
                    continue;
                }
                if (replacementNode == 0) {
                    current = (int)BddIterative.getLowFromStore(nodeStore);
                    continue;
                }
                if (this.cache.lookupVolatile(current)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheArgStack[stackIndex] = current;
                branchStackParentVar[stackIndex] = nodeVariable;
                branchTaskStack[stackIndex] = (int)BddIterative.getHighFromStore(nodeStore);
                current = (int)BddIterative.getLowFromStore(nodeStore);
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == 0) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                int replacementNode = variableNodes[variable];
                int currentHash = cacheStackHash[stackIndex];
                int currentNode = cacheArgStack[stackIndex];
                int lowResult = this.getWorkStack();
                this.pushToWorkStack(result);
                result = this.ifThenElseIterative(replacementNode, result, lowResult, stackIndex);
                this.popWorkStack(2);
                this.cache.putVolatile(currentHash, currentNode, result);
                if (stackIndex != 0) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current = branchTaskStack[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int equivalence(int node1, int node2) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.equivalenceIterative(node1, node2, 0);
        this.popWorkStack(2);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int equivalenceIterative(int node1, int node2, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheStackLeft = this.cacheStackFirstArg;
        int[] cacheStackRight = this.cacheStackSecondArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchStackLeft = this.branchStackFirstArg;
        int[] branchStackRight = this.branchStackSecondArg;
        int stackIndex = baseStackIndex;
        int current1 = node1;
        int current2 = node2;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            do {
                if (current1 == current2) {
                    result = 1;
                    continue;
                }
                if (current1 == 0) {
                    result = this.notIterative(current2, stackIndex);
                    continue;
                }
                if (current1 == 1) {
                    result = current2;
                    continue;
                }
                if (current2 == 0) {
                    result = this.notIterative(current1, stackIndex);
                    continue;
                }
                if (current2 == 1) {
                    result = current1;
                    continue;
                }
                long node1store = this.getNodeStore(current1);
                long node2store = this.getNodeStore(current2);
                int node1var = (int)BddIterative.getVariableFromStore(node1store);
                int node2var = (int)BddIterative.getVariableFromStore(node2store);
                if (node2var < node1var || node2var == node1var && current2 < current1) {
                    int nodeSwap = current1;
                    current1 = current2;
                    current2 = nodeSwap;
                    int varSwap = node1var;
                    node1var = node2var;
                    node2var = varSwap;
                    long storeSwap = node1store;
                    node1store = node2store;
                    node2store = storeSwap;
                }
                if (this.cache.lookupEquivalence(current1, current2)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheStackLeft[stackIndex] = current1;
                cacheStackRight[stackIndex] = current2;
                branchStackParentVar[stackIndex] = node1var;
                branchStackLeft[stackIndex] = (int)BddIterative.getHighFromStore(node1store);
                if (node1var == node2var) {
                    branchStackRight[stackIndex] = (int)BddIterative.getHighFromStore(node2store);
                    current2 = (int)BddIterative.getLowFromStore(node2store);
                } else {
                    branchStackRight[stackIndex] = current2;
                }
                current1 = (int)BddIterative.getLowFromStore(node1store);
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                this.popWorkStack(2);
                int left = cacheStackLeft[stackIndex];
                int right = cacheStackRight[stackIndex];
                this.cache.putEquivalence(cacheStackHash[stackIndex], left, right, result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current1 = branchStackLeft[stackIndex];
            current2 = branchStackRight[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int exists(int node, BitSet quantifiedVariables) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node));
        this.pushToWorkStack(node);
        int result = this.getConfiguration().useShannonExists() ? this.existsShannon(node, quantifiedVariables) : this.existsSelfSubstitution(node, quantifiedVariables);
        this.popWorkStack();
        assert (this.isWorkStackEmpty());
        return result;
    }

    @Override
    int existsSelfSubstitution(int node, BitSet quantifiedVariables) {
        assert (quantifiedVariables.previousSetBit(quantifiedVariables.length()) <= this.numberOfVariables);
        if (quantifiedVariables.cardinality() == this.numberOfVariables) {
            return 1;
        }
        if (node == 1 || node == 0) {
            return node;
        }
        this.pushToWorkStack(node);
        int[] replacementArray = new int[quantifiedVariables.length()];
        System.arraycopy(this.variableNodes, 0, replacementArray, 0, replacementArray.length);
        int quantifiedNode = node;
        int workStackElements = 1;
        for (int i = 0; i < quantifiedVariables.length(); ++i) {
            if (!quantifiedVariables.get(i)) continue;
            int variableNode = replacementArray[i];
            replacementArray[i] = 1;
            this.cache.clearVolatileCache();
            replacementArray[i] = this.pushToWorkStack(this.composeIterative(quantifiedNode, replacementArray, i));
            this.cache.clearVolatileCache();
            quantifiedNode = this.composeIterative(quantifiedNode, replacementArray, i);
            this.popWorkStack();
            replacementArray[i] = variableNode;
            this.pushToWorkStack(quantifiedNode);
            ++workStackElements;
        }
        this.popWorkStack(workStackElements);
        return quantifiedNode;
    }

    @Override
    int existsShannon(int node, BitSet quantifiedVariables) {
        assert (quantifiedVariables.previousSetBit(quantifiedVariables.length()) <= this.numberOfVariables);
        if (quantifiedVariables.cardinality() == this.numberOfVariables) {
            return 1;
        }
        this.pushToWorkStack(node);
        int quantifiedVariablesConjunction = this.conjunction(quantifiedVariables);
        this.pushToWorkStack(quantifiedVariablesConjunction);
        int result = this.existsShannonIterative(node, quantifiedVariablesConjunction, 0);
        this.popWorkStack(2);
        return result;
    }

    private int existsShannonIterative(int node, int quantifiedVariableCube, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheStackArg = this.cacheStackFirstArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchStackArg = this.branchStackFirstArg;
        int[] branchStackCubeNode = this.branchStackSecondArg;
        int stackIndex = baseStackIndex;
        int current = node;
        int currentCubeNode = quantifiedVariableCube;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            block1: do {
                if (current == 1 || current == 0) {
                    result = current;
                    continue;
                }
                if (quantifiedVariableCube == 1) {
                    result = current;
                    continue;
                }
                long nodeStore = this.getNodeStore(current);
                int nodeVariable = (int)BddIterative.getVariableFromStore(nodeStore);
                long currentCubeNodeStore = this.getNodeStore(currentCubeNode);
                int currentCubeNodeVariable = (int)BddIterative.getVariableFromStore(currentCubeNodeStore);
                while (currentCubeNodeVariable < nodeVariable) {
                    currentCubeNode = (int)BddIterative.getHighFromStore(currentCubeNodeStore);
                    if (currentCubeNode == 1) {
                        result = current;
                        break block1;
                    }
                    currentCubeNodeStore = this.getNodeStore(currentCubeNode);
                    currentCubeNodeVariable = (int)BddIterative.getVariableFromStore(currentCubeNodeStore);
                }
                if (BddIterative.isVariableOrNegatedStore(nodeStore)) {
                    if (nodeVariable == currentCubeNodeVariable) {
                        result = 1;
                        continue;
                    }
                    result = current;
                    continue;
                }
                if (this.cache.lookupExists(current, currentCubeNode)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheStackArg[stackIndex] = current;
                branchStackParentVar[stackIndex] = nodeVariable;
                branchStackArg[stackIndex] = (int)BddIterative.getHighFromStore(nodeStore);
                branchStackCubeNode[stackIndex] = currentCubeNode;
                current = (int)BddIterative.getLowFromStore(nodeStore);
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                int currentNode = cacheStackArg[stackIndex];
                int currentHash = cacheStackHash[stackIndex];
                currentCubeNode = branchStackCubeNode[stackIndex];
                if (BddIterative.getVariableFromStore(this.getNodeStore(currentCubeNode)) > (long)variable) {
                    result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                    this.popWorkStack(2);
                } else {
                    result = this.orIterative(this.getAndPopWorkStack(), result, stackIndex);
                }
                this.cache.putExists(currentHash, currentNode, currentCubeNode, result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            currentCubeNode = branchStackCubeNode[stackIndex];
            current = branchStackArg[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int ifThenElse(int ifNode, int thenNode, int elseNode) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(ifNode) && this.isNodeValidOrRoot(thenNode) && this.isNodeValidOrRoot(elseNode));
        this.pushToWorkStack(ifNode);
        this.pushToWorkStack(thenNode);
        this.pushToWorkStack(elseNode);
        int result = this.ifThenElseIterative(ifNode, thenNode, elseNode, 0);
        this.popWorkStack(3);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int ifThenElseIterative(int ifNode, int thenNode, int elseNode, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheIfArgStack = this.cacheStackFirstArg;
        int[] cacheThenArgStack = this.cacheStackSecondArg;
        int[] cacheElseArgStack = this.cacheStackThirdArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchTaskIfStack = this.branchStackFirstArg;
        int[] branchTaskThenStack = this.branchStackSecondArg;
        int[] branchTaskElseStack = this.branchStackThirdArg;
        int stackIndex = baseStackIndex;
        int currentIf = ifNode;
        int currentThen = thenNode;
        int currentElse = elseNode;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            do {
                int elseHighNode;
                int elseLowNode;
                int thenHighNode;
                int thenLowNode;
                int ifHighNode;
                int ifLowNode;
                int elseVar;
                int thenVar;
                int minVar;
                if (currentIf == 1) {
                    result = currentThen;
                    continue;
                }
                if (currentIf == 0) {
                    result = currentElse;
                    continue;
                }
                if (currentThen == currentElse) {
                    result = currentThen;
                    continue;
                }
                if (currentThen == 1) {
                    result = currentElse == 0 ? currentIf : this.orIterative(currentIf, currentElse, stackIndex);
                    continue;
                }
                if (currentThen == 0) {
                    if (currentElse == 1) {
                        result = this.notIterative(currentIf, stackIndex);
                        continue;
                    }
                    int not = this.notIterative(currentIf, stackIndex);
                    result = this.andIterative(this.pushToWorkStack(not), currentElse, stackIndex);
                    this.popWorkStack();
                    continue;
                }
                if (currentElse == 1) {
                    int not = this.notIterative(currentThen, stackIndex);
                    result = this.notAndIterative(currentIf, this.pushToWorkStack(not), stackIndex);
                    this.popWorkStack();
                    continue;
                }
                if (currentElse == 0) {
                    result = this.andIterative(currentIf, currentThen, stackIndex);
                    continue;
                }
                if (currentIf == currentThen) {
                    result = this.orIterative(currentIf, currentElse, stackIndex);
                    continue;
                }
                if (currentIf == currentElse) {
                    result = this.andIterative(currentIf, currentThen, stackIndex);
                    continue;
                }
                if (this.cache.lookupIfThenElse(currentIf, currentThen, currentElse)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                long ifStore = this.getNodeStore(currentIf);
                long thenStore = this.getNodeStore(currentThen);
                long elseStore = this.getNodeStore(currentElse);
                int ifVar = (int)BddIterative.getVariableFromStore(ifStore);
                if (ifVar == (minVar = MathUtil.min(ifVar, thenVar = (int)BddIterative.getVariableFromStore(thenStore), elseVar = (int)BddIterative.getVariableFromStore(elseStore)))) {
                    ifLowNode = (int)BddIterative.getLowFromStore(ifStore);
                    ifHighNode = (int)BddIterative.getHighFromStore(ifStore);
                } else {
                    ifLowNode = currentIf;
                    ifHighNode = currentIf;
                }
                if (thenVar == minVar) {
                    thenLowNode = (int)BddIterative.getLowFromStore(thenStore);
                    thenHighNode = (int)BddIterative.getHighFromStore(thenStore);
                } else {
                    thenLowNode = currentThen;
                    thenHighNode = currentThen;
                }
                if (elseVar == minVar) {
                    elseLowNode = (int)BddIterative.getLowFromStore(elseStore);
                    elseHighNode = (int)BddIterative.getHighFromStore(elseStore);
                } else {
                    elseLowNode = currentElse;
                    elseHighNode = currentElse;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheIfArgStack[stackIndex] = currentIf;
                cacheThenArgStack[stackIndex] = currentThen;
                cacheElseArgStack[stackIndex] = currentElse;
                branchStackParentVar[stackIndex] = minVar;
                branchTaskIfStack[stackIndex] = ifHighNode;
                branchTaskThenStack[stackIndex] = thenHighNode;
                branchTaskElseStack[stackIndex] = elseHighNode;
                currentIf = ifLowNode;
                currentThen = thenLowNode;
                currentElse = elseLowNode;
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                this.popWorkStack(2);
                int cacheIf = cacheIfArgStack[stackIndex];
                int cacheThen = cacheThenArgStack[stackIndex];
                int cacheElse = cacheElseArgStack[stackIndex];
                this.cache.putIfThenElse(cacheStackHash[stackIndex], cacheIf, cacheThen, cacheElse, result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            assert (stackIndex >= baseStackIndex);
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            currentIf = branchTaskIfStack[stackIndex];
            currentThen = branchTaskThenStack[stackIndex];
            currentElse = branchTaskElseStack[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int implication(int node1, int node2) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.implicationIterative(node1, node2, 0);
        this.popWorkStack(2);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int implicationIterative(int node1, int node2, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheStackLeft = this.cacheStackFirstArg;
        int[] cacheStackRight = this.cacheStackSecondArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchStackLeft = this.branchStackFirstArg;
        int[] branchStackRight = this.branchStackSecondArg;
        int stackIndex = baseStackIndex;
        int current1 = node1;
        int current2 = node2;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            do {
                if (current1 == 0 || current2 == 1 || current1 == current2) {
                    result = 1;
                    continue;
                }
                if (current1 == 1) {
                    result = current2;
                    continue;
                }
                if (current2 == 0) {
                    result = this.notIterative(current1, stackIndex);
                    continue;
                }
                if (this.cache.lookupImplication(current1, current2)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                long node1store = this.getNodeStore(current1);
                long node2store = this.getNodeStore(current2);
                int node1var = (int)BddIterative.getVariableFromStore(node1store);
                int node2var = (int)BddIterative.getVariableFromStore(node2store);
                int node1low = (int)BddIterative.getLowFromStore(node1store);
                int node1high = (int)BddIterative.getHighFromStore(node1store);
                int node2low = (int)BddIterative.getLowFromStore(node2store);
                int node2high = (int)BddIterative.getHighFromStore(node2store);
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheStackLeft[stackIndex] = current1;
                cacheStackRight[stackIndex] = current2;
                if (node1var > node2var) {
                    branchStackParentVar[stackIndex] = node2var;
                    branchStackLeft[stackIndex] = current1;
                    branchStackRight[stackIndex] = node2high;
                    current2 = node2low;
                } else if (node1var == node2var) {
                    branchStackParentVar[stackIndex] = node1var;
                    branchStackLeft[stackIndex] = node1high;
                    branchStackRight[stackIndex] = node2high;
                    current1 = node1low;
                    current2 = node2low;
                } else {
                    branchStackParentVar[stackIndex] = node1var;
                    branchStackLeft[stackIndex] = node1high;
                    branchStackRight[stackIndex] = current2;
                    current1 = node1low;
                }
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                this.popWorkStack(2);
                int left = cacheStackLeft[stackIndex];
                int right = cacheStackRight[stackIndex];
                this.cache.putImplication(cacheStackHash[stackIndex], left, right, result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current1 = branchStackLeft[stackIndex];
            current2 = branchStackRight[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public boolean implies(int node1, int node2) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        boolean result = this.impliesIterative(node1, node2, 0);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private boolean impliesIterative(int node1, int node2, int baseStackIndex) {
        int[] branchStackLeft = this.branchStackFirstArg;
        int[] branchStackRight = this.branchStackSecondArg;
        int stackIndex = baseStackIndex;
        int current1 = node1;
        int current2 = node2;
        while (true) {
            assert (stackIndex >= baseStackIndex);
            while (current1 != 0) {
                if (current2 == 0) {
                    return false;
                }
                if (current2 == 1) break;
                if (current1 == 1) {
                    return false;
                }
                if (current1 == current2) break;
                if (this.cache.lookupImplication(current1, current2)) {
                    if (this.cache.getLookupResult() == 1) break;
                    return false;
                }
                long node1store = this.getNodeStore(current1);
                long node2store = this.getNodeStore(current2);
                int node1var = (int)BddIterative.getVariableFromStore(node1store);
                int node2var = (int)BddIterative.getVariableFromStore(node2store);
                int node1low = (int)BddIterative.getLowFromStore(node1store);
                int node1high = (int)BddIterative.getHighFromStore(node1store);
                int node2low = (int)BddIterative.getLowFromStore(node2store);
                int node2high = (int)BddIterative.getHighFromStore(node2store);
                if (node1var > node2var) {
                    branchStackLeft[stackIndex] = current1;
                    branchStackRight[stackIndex] = node2high;
                    current2 = node2low;
                } else if (node1var == node2var) {
                    branchStackLeft[stackIndex] = node1high;
                    branchStackRight[stackIndex] = node2high;
                    current1 = node1low;
                    current2 = node2low;
                } else {
                    branchStackLeft[stackIndex] = node1high;
                    branchStackRight[stackIndex] = current2;
                    current1 = node1low;
                }
                ++stackIndex;
            }
            if (stackIndex == baseStackIndex) {
                return true;
            }
            current1 = branchStackLeft[--stackIndex];
            current2 = branchStackRight[stackIndex];
        }
    }

    @Override
    public int not(int node) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node));
        this.pushToWorkStack(node);
        int result = this.notIterative(node, 0);
        this.popWorkStack();
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int notIterative(int node, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheArgStack = this.cacheStackFirstArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchTaskStack = this.branchStackFirstArg;
        int stackIndex = baseStackIndex;
        int current = node;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            do {
                if (current == 0) {
                    result = 1;
                    continue;
                }
                if (current == 1) {
                    result = 0;
                    continue;
                }
                if (this.cache.lookupNot(current)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                long nodeStore = this.getNodeStore(current);
                int nodeVar = (int)BddIterative.getVariableFromStore(nodeStore);
                int nodeLow = (int)BddIterative.getLowFromStore(nodeStore);
                int nodeHigh = (int)BddIterative.getHighFromStore(nodeStore);
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheArgStack[stackIndex] = current;
                branchStackParentVar[stackIndex] = nodeVar;
                branchTaskStack[stackIndex] = nodeHigh;
                current = nodeLow;
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                assert (stackIndex >= baseStackIndex);
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                this.popWorkStack(2);
                this.cache.putNot(cacheStackHash[stackIndex], cacheArgStack[stackIndex], result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            assert (stackIndex >= baseStackIndex);
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current = branchTaskStack[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int notAnd(int node1, int node2) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.notAndIterative(node1, node2, 0);
        this.popWorkStack(2);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int notAndIterative(int node1, int node2, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheStackLeft = this.cacheStackFirstArg;
        int[] cacheStackRight = this.cacheStackSecondArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchStackLeft = this.branchStackFirstArg;
        int[] branchStackRight = this.branchStackSecondArg;
        int stackIndex = baseStackIndex;
        int current1 = node1;
        int current2 = node2;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            do {
                if (current1 == 0 || current2 == 0) {
                    result = 1;
                    continue;
                }
                if (current1 == 1 || current1 == current2) {
                    result = this.notIterative(current2, stackIndex);
                    continue;
                }
                if (current2 == 1) {
                    result = this.notIterative(current1, stackIndex);
                    continue;
                }
                long node1store = this.getNodeStore(current1);
                long node2store = this.getNodeStore(current2);
                int node1var = (int)BddIterative.getVariableFromStore(node1store);
                int node2var = (int)BddIterative.getVariableFromStore(node2store);
                if (node2var < node1var || node2var == node1var && current2 < current1) {
                    int nodeSwap = current1;
                    current1 = current2;
                    current2 = nodeSwap;
                    int varSwap = node1var;
                    node1var = node2var;
                    node2var = varSwap;
                    long storeSwap = node1store;
                    node1store = node2store;
                    node2store = storeSwap;
                }
                if (this.cache.lookupNAnd(current1, current2)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheStackLeft[stackIndex] = current1;
                cacheStackRight[stackIndex] = current2;
                branchStackParentVar[stackIndex] = node1var;
                branchStackLeft[stackIndex] = (int)BddIterative.getHighFromStore(node1store);
                if (node1var == node2var) {
                    branchStackRight[stackIndex] = (int)BddIterative.getHighFromStore(node2store);
                    current2 = (int)BddIterative.getLowFromStore(node2store);
                } else {
                    branchStackRight[stackIndex] = current2;
                }
                current1 = (int)BddIterative.getLowFromStore(node1store);
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                this.popWorkStack(2);
                int left = cacheStackLeft[stackIndex];
                int right = cacheStackRight[stackIndex];
                this.cache.putNAnd(cacheStackHash[stackIndex], left, right, result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current1 = branchStackLeft[stackIndex];
            current2 = branchStackRight[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int or(int node1, int node2) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.orIterative(node1, node2, 0);
        this.popWorkStack(2);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int orIterative(int node1, int node2, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheStackLeft = this.cacheStackFirstArg;
        int[] cacheStackRight = this.cacheStackSecondArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchStackLeft = this.branchStackFirstArg;
        int[] branchStackRight = this.branchStackSecondArg;
        int stackIndex = baseStackIndex;
        int current1 = node1;
        int current2 = node2;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            do {
                if (current1 == 1 || current2 == 1) {
                    result = 1;
                    continue;
                }
                if (current1 == 0 || current1 == current2) {
                    result = current2;
                    continue;
                }
                if (current2 == 0) {
                    result = current1;
                    continue;
                }
                long node1store = this.getNodeStore(current1);
                long node2store = this.getNodeStore(current2);
                int node1var = (int)BddIterative.getVariableFromStore(node1store);
                int node2var = (int)BddIterative.getVariableFromStore(node2store);
                if (node2var < node1var || node2var == node1var && current2 < current1) {
                    int nodeSwap = current1;
                    current1 = current2;
                    current2 = nodeSwap;
                    int varSwap = node1var;
                    node1var = node2var;
                    node2var = varSwap;
                    long storeSwap = node1store;
                    node1store = node2store;
                    node2store = storeSwap;
                }
                if (this.cache.lookupOr(current1, current2)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheStackLeft[stackIndex] = current1;
                cacheStackRight[stackIndex] = current2;
                branchStackParentVar[stackIndex] = node1var;
                branchStackLeft[stackIndex] = (int)BddIterative.getHighFromStore(node1store);
                if (node1var == node2var) {
                    branchStackRight[stackIndex] = (int)BddIterative.getHighFromStore(node2store);
                    current2 = (int)BddIterative.getLowFromStore(node2store);
                } else {
                    branchStackRight[stackIndex] = current2;
                }
                current1 = (int)BddIterative.getLowFromStore(node1store);
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                this.popWorkStack(2);
                int left = cacheStackLeft[stackIndex];
                int right = cacheStackRight[stackIndex];
                this.cache.putOr(cacheStackHash[stackIndex], left, right, result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current1 = branchStackLeft[stackIndex];
            current2 = branchStackRight[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int restrict(int node, BitSet restrictedVariables, BitSet restrictedVariableValues) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node));
        this.pushToWorkStack(node);
        this.cache.clearVolatileCache();
        int result = this.restrictIterative(node, restrictedVariables, restrictedVariableValues, 0);
        this.popWorkStack();
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int restrictIterative(int node, BitSet restrictedVariables, BitSet restrictedVariableValues, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheArgStack = this.cacheStackFirstArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchTaskStack = this.branchStackFirstArg;
        int initialSize = this.workStackSize();
        int stackIndex = baseStackIndex;
        int current = node;
        int highestRestrictedVariable = restrictedVariables.length();
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            assert (this.workStackSize() >= initialSize);
            int result = -1;
            do {
                if (current == 1 || current == 0) {
                    result = current;
                    continue;
                }
                long nodeStore = this.getNodeStore(current);
                int nodeVariable = (int)BddIterative.getVariableFromStore(nodeStore);
                if (nodeVariable > highestRestrictedVariable) {
                    result = current;
                    continue;
                }
                if (restrictedVariables.get(nodeVariable)) {
                    current = restrictedVariableValues.get(nodeVariable) ? (int)BddIterative.getHighFromStore(nodeStore) : (int)BddIterative.getLowFromStore(nodeStore);
                    continue;
                }
                if (this.cache.lookupVolatile(current)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheArgStack[stackIndex] = current;
                branchStackParentVar[stackIndex] = nodeVariable;
                branchTaskStack[stackIndex] = (int)BddIterative.getHighFromStore(nodeStore);
                current = (int)BddIterative.getLowFromStore(nodeStore);
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                this.popWorkStack(2);
                this.cache.putVolatile(cacheStackHash[stackIndex], cacheArgStack[stackIndex], result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current = branchTaskStack[stackIndex];
            ++stackIndex;
        }
    }

    @Override
    public int xor(int node1, int node2) {
        assert (this.isWorkStackEmpty());
        assert (this.isNodeValidOrRoot(node1) && this.isNodeValidOrRoot(node2));
        this.pushToWorkStack(node1);
        this.pushToWorkStack(node2);
        int result = this.xorIterative(node1, node2, 0);
        this.popWorkStack(2);
        assert (this.isWorkStackEmpty());
        return result;
    }

    private int xorIterative(int node1, int node2, int baseStackIndex) {
        int[] cacheStackHash = this.cacheStackHash;
        int[] cacheStackLeft = this.cacheStackFirstArg;
        int[] cacheStackRight = this.cacheStackSecondArg;
        int[] branchStackParentVar = this.branchStackParentVar;
        int[] branchStackLeft = this.branchStackFirstArg;
        int[] branchStackRight = this.branchStackSecondArg;
        int stackIndex = baseStackIndex;
        int current1 = node1;
        int current2 = node2;
        while (true) {
            int parentVar;
            assert (stackIndex >= baseStackIndex);
            int result = -1;
            do {
                if (current1 == current2) {
                    result = 0;
                    continue;
                }
                if (current1 == 0) {
                    result = current2;
                    continue;
                }
                if (current2 == 0) {
                    result = current1;
                    continue;
                }
                if (current1 == 1) {
                    result = this.notIterative(current2, stackIndex);
                    continue;
                }
                if (current2 == 1) {
                    result = this.notIterative(current1, stackIndex);
                    continue;
                }
                long node1store = this.getNodeStore(current1);
                long node2store = this.getNodeStore(current2);
                int node1var = (int)BddIterative.getVariableFromStore(node1store);
                int node2var = (int)BddIterative.getVariableFromStore(node2store);
                if (node2var < node1var || node2var == node1var && current2 < current1) {
                    int nodeSwap = current1;
                    current1 = current2;
                    current2 = nodeSwap;
                    int varSwap = node1var;
                    node1var = node2var;
                    node2var = varSwap;
                    long storeSwap = node1store;
                    node1store = node2store;
                    node2store = storeSwap;
                }
                if (this.cache.lookupXor(current1, current2)) {
                    result = this.cache.getLookupResult();
                    continue;
                }
                cacheStackHash[stackIndex] = this.cache.getLookupHash();
                cacheStackLeft[stackIndex] = current1;
                cacheStackRight[stackIndex] = current2;
                branchStackParentVar[stackIndex] = node1var;
                branchStackLeft[stackIndex] = (int)BddIterative.getHighFromStore(node1store);
                if (node1var == node2var) {
                    branchStackRight[stackIndex] = (int)BddIterative.getHighFromStore(node2store);
                    current2 = (int)BddIterative.getLowFromStore(node2store);
                } else {
                    branchStackRight[stackIndex] = current2;
                }
                current1 = (int)BddIterative.getLowFromStore(node1store);
                ++stackIndex;
            } while (result == -1);
            if (stackIndex == baseStackIndex) {
                return result;
            }
            while ((parentVar = branchStackParentVar[--stackIndex]) < 0) {
                int variable = -parentVar - 1;
                result = this.makeNode(variable, this.getWorkStack(), this.pushToWorkStack(result));
                this.popWorkStack(2);
                int left = cacheStackLeft[stackIndex];
                int right = cacheStackRight[stackIndex];
                this.cache.putXor(cacheStackHash[stackIndex], left, right, result);
                if (stackIndex != baseStackIndex) continue;
                return result;
            }
            branchStackParentVar[stackIndex] = -(parentVar + 1);
            this.pushToWorkStack(result);
            current1 = branchStackLeft[stackIndex];
            current2 = branchStackRight[stackIndex];
            ++stackIndex;
        }
    }
}

