/*
 * Decompiled with CFR 0.152.
 */
package owl.run.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.run.DefaultCli;
import owl.run.Environment;
import owl.run.Pipeline;
import owl.run.RunUtil;
import owl.run.modules.OwlModule;
import owl.run.parser.OwlParser;
import owl.run.parser.ParseUtil;
import owl.run.parser.PartialModuleConfiguration;

public final class PartialConfigurationParser {
    private PartialConfigurationParser() {
    }

    private static void printHelp(OwlModule<?> settings) {
        Options options = settings.options();
        ParseUtil.printHelp(settings.key(), options);
    }

    public static void run(String[] args, PartialModuleConfiguration configuration) throws IOException {
        Object[] remainingArgs;
        CommandLine emptyCommandLine;
        CommandLine streamSettings;
        RunUtil.checkForVersion(args);
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("");
        Options globalOptions = DefaultCli.getOptions();
        String name = configuration.configurableTransformer().key();
        if (ParseUtil.isHelp(args)) {
            ParseUtil.println("This is the specialized construction " + name + ". Available options are listed below. Specify them in the given order. To specify input, either write a single argument at the _end_ or use the corresponding flags.");
            ParseUtil.printHelp("Global options: ", globalOptions);
            PartialConfigurationParser.printHelp(configuration.configurableTransformer());
            return;
        }
        DefaultParser parser = new DefaultParser();
        try {
            streamSettings = parser.parse(globalOptions, args, true);
            emptyCommandLine = parser.parse(new Options(), new String[0], true);
        }
        catch (ParseException e) {
            ParseUtil.printHelp(name, globalOptions, e.getMessage());
            System.exit(1);
            return;
        }
        Environment environment = OwlParser.getEnvironment(streamSettings);
        OwlModule.InputReader reader = PartialConfigurationParser.parse(configuration.input(), emptyCommandLine, environment);
        ArrayList<OwlModule.Transformer> transformers = new ArrayList<OwlModule.Transformer>();
        for (OwlModule<OwlModule.Transformer> module : configuration.preprocessing()) {
            transformers.add(PartialConfigurationParser.parse(module, emptyCommandLine, environment));
        }
        OwlModule<OwlModule.Transformer> mainModule = configuration.configurableTransformer();
        try {
            CommandLine commandLine = parser.parse(mainModule.options(), (String[])streamSettings.getArgList().toArray(String[]::new), true);
            remainingArgs = (String[])commandLine.getArgList().toArray(String[]::new);
            commandLine.getArgList().clear();
            transformers.add(mainModule.constructor().newInstance(commandLine, environment));
        }
        catch (ParseException e) {
            ParseUtil.printHelp(mainModule.key(), mainModule.options(), e.getMessage());
            System.exit(1);
            throw new AssertionError((Object)e);
        }
        for (OwlModule<OwlModule.Transformer> module : configuration.postprocessing()) {
            transformers.add(PartialConfigurationParser.parse(module, emptyCommandLine, environment));
        }
        OwlModule.OutputWriter writer = PartialConfigurationParser.parse(configuration.output(), emptyCommandLine, environment);
        if (remainingArgs.length > 1) {
            ParseUtil.println("Multiple unmatched arguments: " + Arrays.toString(remainingArgs) + ". To specify multiple inputs, use the corresponding flags (see --help).");
            System.exit(1);
            return;
        }
        streamSettings.getArgList().clear();
        if (remainingArgs.length == 1) {
            streamSettings.getArgList().add(remainingArgs[0]);
        }
        DefaultCli.run(streamSettings, Pipeline.of(reader, transformers, writer));
    }

    private static <M extends OwlModule.Instance> M parse(OwlModule<M> module, CommandLine commandLine, Environment environment) {
        try {
            return (M)((OwlModule.Instance)module.constructor().newInstance(commandLine, environment));
        }
        catch (ParseException e) {
            ParseUtil.printHelp(module.key(), module.options(), e.getMessage());
            System.exit(1);
            throw new AssertionError((Object)e);
        }
    }
}

