/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.collect.Iterables;
import de.tum.in.naturals.bitset.BitSets;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.AutomatonUtil;
import owl.automaton.DefaultImplementations;
import owl.automaton.Properties;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;

public interface Automaton<S, A extends OmegaAcceptance> {
    default public String name() {
        return this.getClass() + " for " + this.initialStates();
    }

    public A acceptance();

    public ValuationSetFactory factory();

    default public S onlyInitialState() {
        Iterator<S> iterator = this.initialStates().iterator();
        S first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        throw new IllegalStateException("Multiple initial states: " + this.initialStates().toString());
    }

    public Set<S> initialStates();

    default public int size() {
        return this.states().size();
    }

    public Set<S> states();

    public Set<Edge<S>> edges(S var1, BitSet var2);

    @Nullable
    default public Edge<S> edge(S state, BitSet valuation) {
        return (Edge)Iterables.getFirst(this.edges(state, valuation), null);
    }

    default public Set<Edge<S>> edges(S state) {
        switch (this.preferredEdgeAccess().get(0)) {
            case EDGES: {
                HashSet<Edge<S>> edges = new HashSet<Edge<S>>();
                for (BitSet valuation : BitSets.powerSet((int)this.factory().atomicPropositions().size())) {
                    edges.addAll(this.edges(state, valuation));
                }
                return edges;
            }
            case EDGE_TREE: {
                return this.edgeTree(state).flatValues();
            }
            case EDGE_MAP: {
                return this.edgeMap(state).keySet();
            }
        }
        throw new AssertionError((Object)"Unreachable.");
    }

    public Map<Edge<S>, ValuationSet> edgeMap(S var1);

    public ValuationTree<Edge<S>> edgeTree(S var1);

    default public Set<S> successors(S state, BitSet valuation) {
        return Edges.successors(this.edges(state, valuation));
    }

    @Nullable
    default public S successor(S state, BitSet valuation) {
        return (S)Iterables.getFirst(this.successors(state, valuation), null);
    }

    default public Set<S> successors(S state) {
        return Edges.successors(this.edges(state));
    }

    default public Set<S> predecessors(final S successor) {
        final HashSet predecessors = new HashSet();
        EdgeMapVisitor visitor = new EdgeMapVisitor<S>(){

            @Override
            public void visit(S state, Map<Edge<S>, ValuationSet> edgeMap) {
                if (edgeMap.keySet().stream().anyMatch(x -> x.successor().equals(successor))) {
                    predecessors.add(state);
                }
            }
        };
        this.accept(visitor);
        return predecessors;
    }

    default public void accept(EdgeVisitor<S> visitor) {
        DefaultImplementations.visit(this, visitor);
    }

    default public void accept(EdgeMapVisitor<S> visitor) {
        DefaultImplementations.visit(this, visitor);
    }

    default public void accept(EdgeTreeVisitor<S> visitor) {
        DefaultImplementations.visit(this, visitor);
    }

    default public void accept(Visitor<S> visitor) {
        List<PreferredEdgeAccess> preferredEdgeAccesses = this.preferredEdgeAccess();
        for (PreferredEdgeAccess mode : preferredEdgeAccesses) {
            if (!mode.matches(visitor)) continue;
            mode.dispatch(this, visitor);
            return;
        }
        throw new IllegalArgumentException(String.format("No common access mode for %s and %s.", preferredEdgeAccesses, Arrays.toString(visitor.getClass().getInterfaces())));
    }

    public List<PreferredEdgeAccess> preferredEdgeAccess();

    default public boolean is(Property property) {
        switch (property) {
            case COMPLETE: {
                return Properties.isComplete(this);
            }
            case DETERMINISTIC: {
                return Properties.isDeterministic(this);
            }
            case SEMI_DETERMINISTIC: {
                return Properties.isSemiDeterministic(this);
            }
            case LIMIT_DETERMINISTIC: {
                if (this.acceptance() instanceof GeneralizedBuchiAcceptance) {
                    return AutomatonUtil.ldbaSplit(OmegaAcceptanceCast.cast(this, GeneralizedBuchiAcceptance.class)).isPresent();
                }
                return false;
            }
        }
        throw new UnsupportedOperationException("Property detection for " + property + " is not implemented");
    }

    @FunctionalInterface
    public static interface EdgeTreeVisitor<S>
    extends Visitor<S> {
        public void visit(S var1, ValuationTree<Edge<S>> var2);
    }

    @FunctionalInterface
    public static interface EdgeMapVisitor<S>
    extends Visitor<S> {
        public void visit(S var1, Map<Edge<S>, ValuationSet> var2);
    }

    @FunctionalInterface
    public static interface EdgeVisitor<S>
    extends Visitor<S> {
        public void visit(S var1, BitSet var2, Edge<S> var3);
    }

    public static interface Visitor<S> {
        default public void enter(S state) {
        }

        default public void exit(S state) {
        }
    }

    public static enum Property {
        COMPLETE,
        DETERMINISTIC,
        SEMI_DETERMINISTIC,
        LIMIT_DETERMINISTIC;

    }

    public static enum PreferredEdgeAccess {
        EDGES{

            @Override
            <S> void dispatch(Automaton<S, ?> automaton, Visitor<S> visitor) {
                automaton.accept((EdgeVisitor)visitor);
            }

            @Override
            boolean matches(Visitor<?> visitor) {
                return visitor instanceof EdgeVisitor;
            }
        }
        ,
        EDGE_MAP{

            @Override
            <S> void dispatch(Automaton<S, ?> automaton, Visitor<S> visitor) {
                automaton.accept((EdgeMapVisitor)visitor);
            }

            @Override
            boolean matches(Visitor<?> visitor) {
                return visitor instanceof EdgeMapVisitor;
            }
        }
        ,
        EDGE_TREE{

            @Override
            <S> void dispatch(Automaton<S, ?> automaton, Visitor<S> visitor) {
                automaton.accept((EdgeTreeVisitor)visitor);
            }

            @Override
            boolean matches(Visitor<?> visitor) {
                return visitor instanceof EdgeTreeVisitor;
            }
        };


        abstract boolean matches(Visitor<?> var1);

        abstract <S> void dispatch(Automaton<S, ?> var1, Visitor<S> var2);
    }
}

