/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.immutables.value.Value;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.Formulas;
import owl.ltl.GOperator;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.translations.mastertheorem.FixpointsTuple;
import owl.translations.mastertheorem.Predicates;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
public abstract class Fixpoints
implements Comparable<Fixpoints> {
    public abstract Set<Formula.ModalOperator> leastFixpoints();

    public abstract Set<Formula.ModalOperator> greatestFixpoints();

    public static Fixpoints of(Collection<? extends Formula.ModalOperator> leastFixpoints, Collection<? extends Formula.ModalOperator> greatestFixpoints) {
        return FixpointsTuple.create(leastFixpoints, greatestFixpoints);
    }

    public static Fixpoints of(Collection<? extends Formula.ModalOperator> fixpoints) {
        HashSet<Formula.ModalOperator> leastFixpoints = new HashSet<Formula.ModalOperator>();
        HashSet<Formula.ModalOperator> greatestFixpoints = new HashSet<Formula.ModalOperator>();
        for (Formula.ModalOperator modalOperator : fixpoints) {
            if (Predicates.IS_LEAST_FIXPOINT.test(modalOperator)) {
                leastFixpoints.add(modalOperator);
                continue;
            }
            assert (Predicates.IS_GREATEST_FIXPOINT.test(modalOperator));
            greatestFixpoints.add(modalOperator);
        }
        return Fixpoints.of(leastFixpoints, greatestFixpoints);
    }

    public boolean allFixpointsPresent(Collection<? extends Formula.ModalOperator> formulas) {
        HashSet<Formula.ModalOperator> waitingFixpoints = new HashSet<Formula.ModalOperator>(this.leastFixpoints());
        waitingFixpoints.addAll(this.greatestFixpoints());
        waitingFixpoints.removeAll(formulas);
        return waitingFixpoints.isEmpty();
    }

    @Value.Check
    protected void check() {
        Preconditions.checkArgument((boolean)this.greatestFixpoints().stream().allMatch(Predicates.IS_GREATEST_FIXPOINT));
        Preconditions.checkArgument((boolean)this.leastFixpoints().stream().allMatch(Predicates.IS_LEAST_FIXPOINT));
    }

    @Override
    public int compareTo(Fixpoints that) {
        return Formulas.compare(this.fixpoints(), that.fixpoints());
    }

    public abstract boolean equals(Object var1);

    @Value.Lazy
    public Set<Formula.ModalOperator> fixpoints() {
        return Set.copyOf(Sets.union(this.leastFixpoints(), this.greatestFixpoints()));
    }

    public abstract int hashCode();

    @Value.Lazy
    public Fixpoints simplified() {
        HashSet fOperators = new HashSet();
        HashSet gOperators = new HashSet();
        this.leastFixpoints().forEach(x -> {
            if (x instanceof MOperator) {
                fOperators.add(new FOperator(((MOperator)x).left));
            } else if (x instanceof UOperator) {
                fOperators.add(new FOperator(((UOperator)x).right));
            } else {
                fOperators.add((FOperator)x);
            }
        });
        this.greatestFixpoints().forEach(x -> {
            if (x instanceof ROperator) {
                gOperators.add(new GOperator(((ROperator)x).right));
            } else if (x instanceof WOperator) {
                gOperators.add(new GOperator(((WOperator)x).left));
            } else {
                gOperators.add((GOperator)x);
            }
        });
        Fixpoints simplifiedFixpoints = Fixpoints.of(fOperators, gOperators);
        return this.equals(simplifiedFixpoints) ? this : simplifiedFixpoints;
    }
}

