/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.transformations;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.ParityAcceptance;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.OwlModuleParser;

public final class ParityUtil {
    public static final OwlModuleParser.TransformerParser COMPLEMENT_CLI = ImmutableTransformerParser.builder().key("complement-parity").description("Complements a parity automaton").parser(settings -> environment -> (input, context) -> {
        Automaton<Object, ParityAcceptance> automaton = AutomatonUtil.cast(input, ParityAcceptance.class);
        return ParityUtil.complement(MutableAutomatonUtil.asMutable(automaton), new MutableAutomatonUtil.Sink());
    }).build();
    public static final OwlModuleParser.TransformerParser CONVERSION_CLI = ImmutableTransformerParser.builder().key("convert-parity").optionsDirect(new Options().addOptionGroup(new OptionGroup().addOption(new Option(null, "max", false, null)).addOption(new Option(null, "min", false, null))).addOptionGroup(new OptionGroup().addOption(new Option(null, "even", false, null)).addOption(new Option(null, "odd", false, null)))).description("Converts a parity automaton into the desired type").parser(settings -> {
        Boolean toMax = settings.hasOption("max") ? Boolean.TRUE : (settings.hasOption("min") ? Boolean.FALSE : null);
        Boolean toEven = settings.hasOption("even") ? Boolean.TRUE : (settings.hasOption("odd") ? Boolean.FALSE : null);
        return environment -> (input, context) -> {
            Automaton<Object, ParityAcceptance> automaton = AutomatonUtil.cast(input, ParityAcceptance.class);
            ParityAcceptance.Parity target = automaton.acceptance().parity();
            if (toEven != null) {
                target = target.setEven(toEven);
            }
            if (toMax != null) {
                target = target.setMax(toMax);
            }
            return ParityUtil.convert(automaton, target, new MutableAutomatonUtil.Sink());
        };
    }).build();

    private ParityUtil() {
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> complement(MutableAutomaton<S, ParityAcceptance> automaton, S sinkState) {
        assert (automaton.is(Automaton.Property.DETERMINISTIC));
        ParityAcceptance acceptance = (ParityAcceptance)automaton.acceptance();
        if (acceptance.acceptanceSets() == 0 && !acceptance.emptyIsAccepting()) {
            ParityAcceptance parityAcceptance = new ParityAcceptance(1, ParityAcceptance.Parity.MIN_EVEN);
            Automaton<S, ParityAcceptance> universalAutomaton = AutomatonFactory.singleton(automaton.factory(), sinkState, parityAcceptance, parityAcceptance.acceptingSet());
            return MutableAutomatonFactory.copy(universalAutomaton);
        }
        if (acceptance.acceptanceSets() <= 1) {
            acceptance = acceptance.withAcceptanceSets(2);
            automaton.acceptance(acceptance);
        }
        MutableAutomatonUtil.complete(automaton, sinkState);
        automaton.acceptance(acceptance.complement());
        return automaton;
    }

    public static <S> Automaton<S, ParityAcceptance> convert(Automaton<S, ParityAcceptance> automaton, ParityAcceptance.Parity toParity, S sink) {
        IntUnaryOperator mapping;
        if (automaton.acceptance().parity().equals((Object)toParity)) {
            return automaton;
        }
        MutableAutomaton<Object, ParityAcceptance> mutableAutomaton = MutableAutomatonUtil.asMutable(automaton);
        mutableAutomaton.updateAcceptance(x -> x.withAcceptanceSets(Math.max(3, x.acceptanceSets())));
        MutableAutomatonUtil.complete(mutableAutomaton, sink);
        ParityAcceptance fromAcceptance = (ParityAcceptance)mutableAutomaton.acceptance();
        if (fromAcceptance.parity().max() == toParity.max()) {
            assert (fromAcceptance.parity().even() != toParity.even());
            mapping = i -> i + 1;
        } else {
            int leastImportantColor;
            int acceptanceSets = fromAcceptance.acceptanceSets();
            int n = leastImportantColor = fromAcceptance.parity().max() ? 0 : acceptanceSets - 1;
            int offset = fromAcceptance.parity().even() == toParity.even() ? (fromAcceptance.isAccepting(leastImportantColor) ? 0 : 1) : (fromAcceptance.isAccepting(leastImportantColor) ? -1 : -2);
            int newAcceptanceSets = acceptanceSets + offset;
            mapping = i -> newAcceptanceSets - i;
        }
        AtomicInteger maximalNewAcceptance = new AtomicInteger(0);
        mutableAutomaton.updateEdges((state, edge) -> {
            if (!edge.hasAcceptanceSets()) {
                return edge;
            }
            int newAcceptance = mapping.applyAsInt(edge.smallestAcceptanceSet());
            if (newAcceptance == -1) {
                return edge.withoutAcceptance();
            }
            if (maximalNewAcceptance.get() < newAcceptance) {
                maximalNewAcceptance.set(newAcceptance);
            }
            return edge.withAcceptance(newAcceptance);
        });
        mutableAutomaton.trim();
        mutableAutomaton.acceptance(new ParityAcceptance(maximalNewAcceptance.get() + 1, toParity));
        return mutableAutomaton;
    }
}

