/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import owl.automaton.AbstractCachedStatesAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EdgeTreeAutomatonMixin;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationTree;
import owl.collections.ValuationTrees;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.factories.ValuationSetFactory;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.translations.canonical.BreakpointState;
import owl.translations.canonical.RoundRobinState;
import owl.translations.canonical.Util;

public final class DeterministicConstructions {
    private DeterministicConstructions() {
    }

    public static final class GCoSafety
    extends Base<BreakpointState<EquivalenceClass>, BuchiAcceptance> {
        private final EquivalenceClass initialState;

        public GCoSafety(Factories factories, boolean unfold, Formula formula) {
            super(factories, unfold);
            Preconditions.checkArgument((SyntacticFragments.isGCoSafety(formula) && !(Util.unwrap(formula) instanceof FOperator) && !SyntacticFragment.FINITE.contains(Util.unwrap(formula)) ? 1 : 0) != 0, (Object)formula);
            this.initialState = this.initialStateInternal(this.factory.of(Util.unwrap(formula)));
        }

        @Override
        public BreakpointState<EquivalenceClass> onlyInitialState() {
            return BreakpointState.of(this.initialState, this.factory.getTrue());
        }

        @Override
        public BuchiAcceptance acceptance() {
            return BuchiAcceptance.INSTANCE;
        }

        @Nullable
        private Edge<BreakpointState<EquivalenceClass>> buildEdge(EquivalenceClass current, EquivalenceClass next) {
            if (current.isFalse() || next.isFalse()) {
                return null;
            }
            if (current.isTrue()) {
                EquivalenceClass newCurrent = next.and(this.initialState);
                return newCurrent.isFalse() ? null : Edge.of(BreakpointState.of(newCurrent, current), 0);
            }
            boolean accepting = false;
            EquivalenceClass newCurrent = current;
            EquivalenceClass newNext = next;
            if (current.implies(next)) {
                newNext = this.factory.getTrue();
            } else if (next.modalOperators().stream().allMatch(SyntacticFragment.FINITE::contains)) {
                newCurrent = current.and(next);
                newNext = this.factory.getTrue();
                if (current.modalOperators().stream().allMatch(SyntacticFragment.FINITE::contains)) {
                    accepting = true;
                }
            }
            if (!newCurrent.and(newNext).implies(this.initialState)) {
                newNext = newNext.and(this.initialState);
            }
            if (newCurrent.isFalse() || newNext.isFalse()) {
                return null;
            }
            BreakpointState<EquivalenceClass> successor = BreakpointState.of(newCurrent, newNext);
            return accepting ? Edge.of(successor, 0) : Edge.of(successor);
        }

        @Override
        @Nullable
        public Edge<BreakpointState<EquivalenceClass>> edge(BreakpointState<EquivalenceClass> breakpointState, BitSet valuation) {
            EquivalenceClass currentSuccessor = this.successorInternal(breakpointState.current(), valuation);
            EquivalenceClass nextSuccessor = this.successorInternal(breakpointState.next(), valuation);
            return this.buildEdge(currentSuccessor, nextSuccessor);
        }

        @Override
        public ValuationTree<Edge<BreakpointState<EquivalenceClass>>> edgeTree(BreakpointState<EquivalenceClass> breakpointState) {
            ValuationTree<EquivalenceClass> currentSuccessorTree = super.successorTreeInternal(breakpointState.current());
            ValuationTree<EquivalenceClass> nextSuccessorTree = super.successorTreeInternal(breakpointState.next());
            return ValuationTrees.cartesianProduct(currentSuccessorTree, nextSuccessorTree, this::buildEdge);
        }
    }

    public static class GfCoSafety
    extends Base<RoundRobinState<EquivalenceClass>, GeneralizedBuchiAcceptance> {
        private final GeneralizedBuchiAcceptance acceptance;
        private final RoundRobinState<EquivalenceClass> initialState;
        private final ValuationTree<Util.Pair<List<RoundRobinState<EquivalenceClass>>, BitSet>> initialStatesSuccessorTree;

        /*
         * WARNING - void declaration
         */
        public GfCoSafety(Factories factories, boolean unfold, Set<? extends Formula> formulas, boolean generalized) {
            super(factories, unfold);
            void var8_10;
            Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
            ArrayList<FOperator> automata = new ArrayList<FOperator>();
            ArrayList<Formula> singletonAutomata = new ArrayList<Formula>();
            for (Formula formula : formulas) {
                Preconditions.checkArgument((boolean)SyntacticFragments.isGfCoSafety(formula), (Object)formula);
                Formula unwrapped = Util.unwrap(Util.unwrap(formula));
                if (generalized && SyntacticFragment.SINGLE_STEP.contains(unwrapped)) {
                    singletonAutomata.add(unwrapped);
                    continue;
                }
                automata.add(new FOperator(unwrapped));
            }
            singletonAutomata.sort(Comparator.naturalOrder());
            if (automata.isEmpty()) {
                automata.add(new FOperator((Formula)singletonAutomata.remove(0)));
            } else {
                automata.sort(Comparator.naturalOrder());
            }
            ValuationTree initialStatesSuccessorTree = ValuationTree.of(Set.of(List.of()));
            boolean bl = false;
            while (var8_10 < automata.size()) {
                void j = var8_10++;
                EquivalenceClass initialState = this.initialStateInternal(this.factory.of((Formula)automata.get((int)j)));
                ValuationTree initialStateSuccessorTree = super.successorTreeInternal(initialState, arg_0 -> this.lambda$new$0((int)j, arg_0));
                initialStatesSuccessorTree = ValuationTrees.cartesianProduct(initialStatesSuccessorTree, initialStateSuccessorTree, Collections3::add);
            }
            this.acceptance = GeneralizedBuchiAcceptance.of(singletonAutomata.size() + 1);
            this.initialState = RoundRobinState.of(0, this.initialStateInternal(this.factory.of((Formula)automata.get(0))));
            this.initialStatesSuccessorTree = ValuationTrees.cartesianProduct(initialStatesSuccessorTree, Util.singleStepTree(singletonAutomata), (x, y) -> Util.Pair.of(List.copyOf(x), y));
        }

        @Override
        public GeneralizedBuchiAcceptance acceptance() {
            return this.acceptance;
        }

        @Override
        public final RoundRobinState<EquivalenceClass> onlyInitialState() {
            return this.edge(this.initialState, new BitSet()).successor();
        }

        private Edge<RoundRobinState<EquivalenceClass>> buildEdge(int index, EquivalenceClass successor, Util.Pair<List<RoundRobinState<EquivalenceClass>>, BitSet> initialStateSuccessors) {
            if (!successor.isTrue()) {
                return Edge.of(RoundRobinState.of(index, successor), initialStateSuccessors.b());
            }
            int size = initialStateSuccessors.a().size();
            List<RoundRobinState<EquivalenceClass>> latterSuccessors = initialStateSuccessors.a().subList(index + 1, size);
            for (RoundRobinState<EquivalenceClass> initialStateSuccessor : latterSuccessors) {
                if (initialStateSuccessor.state().isTrue()) continue;
                return Edge.of(initialStateSuccessor, initialStateSuccessors.b());
            }
            BitSet acceptance = (BitSet)initialStateSuccessors.b().clone();
            acceptance.set(0);
            List<RoundRobinState<EquivalenceClass>> earlierSuccessors = initialStateSuccessors.a().subList(0, index + 1);
            for (RoundRobinState<EquivalenceClass> initialStateSuccessor : earlierSuccessors) {
                if (initialStateSuccessor.state().isTrue()) continue;
                return Edge.of(initialStateSuccessor, acceptance);
            }
            return Edge.of(this.initialState, acceptance);
        }

        @Override
        @Nonnull
        public final Edge<RoundRobinState<EquivalenceClass>> edge(RoundRobinState<EquivalenceClass> state, BitSet valuation) {
            EquivalenceClass successor = super.successorInternal(state.state(), valuation);
            Set<Util.Pair<List<RoundRobinState<EquivalenceClass>>, BitSet>> initialStateSuccessors = this.initialStatesSuccessorTree.get(valuation);
            return this.buildEdge(state.index(), successor, initialStateSuccessors.iterator().next());
        }

        @Override
        public final ValuationTree<Edge<RoundRobinState<EquivalenceClass>>> edgeTree(RoundRobinState<EquivalenceClass> state) {
            ValuationTree<EquivalenceClass> successorTree = super.successorTreeInternal(state.state());
            return ValuationTrees.cartesianProduct(successorTree, this.initialStatesSuccessorTree, (x, y) -> this.buildEdge(state.index(), (EquivalenceClass)x, (Util.Pair<List<RoundRobinState<EquivalenceClass>>, BitSet>)y));
        }

        @Override
        public final boolean is(Automaton.Property property) {
            if (property == Automaton.Property.COMPLETE) {
                return true;
            }
            return super.is(property);
        }
    }

    public static final class FgSafety
    extends Looping<CoBuchiAcceptance> {
        public FgSafety(Factories factories, boolean unfold, Formula formula) {
            super(factories, unfold, formula, SyntacticFragments::isFgSafety);
        }

        @Override
        public CoBuchiAcceptance acceptance() {
            return CoBuchiAcceptance.INSTANCE;
        }

        @Override
        protected Edge<EquivalenceClass> buildEdge(EquivalenceClass successor, EquivalenceClass initialStateSuccessor) {
            if (!successor.isFalse()) {
                return Edge.of(successor);
            }
            if (!initialStateSuccessor.isFalse()) {
                return Edge.of(initialStateSuccessor, 0);
            }
            return Edge.of(this.initialState, 0);
        }
    }

    private static abstract class Looping<A extends OmegaAcceptance>
    extends Base<EquivalenceClass, A> {
        protected final EquivalenceClass initialState;
        protected final ValuationTree<EquivalenceClass> initialStateSuccessorTree;

        private Looping(Factories factories, boolean unfold, Formula formula, Predicate<Formula> isSupported) {
            super(factories, unfold);
            Preconditions.checkArgument((boolean)isSupported.test(formula), (Object)formula);
            this.initialState = this.initialStateInternal(this.factory.of(Util.unwrap(formula)));
            this.initialStateSuccessorTree = super.successorTreeInternal(this.initialState);
        }

        public final EquivalenceClass onlyInitialStateUnstepped() {
            return this.initialState;
        }

        @Override
        public final EquivalenceClass onlyInitialState() {
            return this.edge(this.onlyInitialStateUnstepped(), new BitSet()).successor();
        }

        @Override
        @Nonnull
        public final Edge<EquivalenceClass> edge(EquivalenceClass clazz, BitSet valuation) {
            EquivalenceClass successor = super.successorInternal(clazz, valuation);
            Set<EquivalenceClass> initialStateSuccessors = this.initialStateSuccessorTree.get(valuation);
            return this.buildEdge(successor, initialStateSuccessors.iterator().next());
        }

        @Override
        public final ValuationTree<Edge<EquivalenceClass>> edgeTree(EquivalenceClass clazz) {
            ValuationTree<EquivalenceClass> successorTree = super.successorTreeInternal(clazz);
            return ValuationTrees.cartesianProduct(successorTree, this.initialStateSuccessorTree, this::buildEdge);
        }

        @Override
        public final boolean is(Automaton.Property property) {
            if (property == Automaton.Property.COMPLETE) {
                return true;
            }
            return super.is(property);
        }

        protected abstract Edge<EquivalenceClass> buildEdge(EquivalenceClass var1, EquivalenceClass var2);
    }

    public static final class Tracking
    extends Base<EquivalenceClass, NoneAcceptance> {
        public Tracking(Factories factories, boolean unfold) {
            super(factories, unfold);
            Preconditions.checkArgument((boolean)unfold, (Object)"Only eager unfold supported");
        }

        @Override
        public NoneAcceptance acceptance() {
            return NoneAcceptance.INSTANCE;
        }

        public EquivalenceClass asInitialState(Formula state) {
            return this.factory.of(state).unfold();
        }

        @Override
        public EquivalenceClass onlyInitialState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Edge<EquivalenceClass> edge(EquivalenceClass clazz, BitSet valuation) {
            return Edge.of(clazz.temporalStep(valuation).unfold());
        }

        public ValuationTree<EquivalenceClass> successorTree(EquivalenceClass clazz) {
            return clazz.temporalStepTree(x -> Set.of(x.unfold()));
        }

        @Override
        public ValuationTree<Edge<EquivalenceClass>> edgeTree(EquivalenceClass clazz) {
            return clazz.temporalStepTree(x -> Set.of(Edge.of(x.unfold())));
        }
    }

    public static final class Safety
    extends Terminal<AllAcceptance> {
        public Safety(Factories factories, boolean unfold, Formula formula) {
            super(factories, unfold, formula);
            Preconditions.checkArgument((boolean)SyntacticFragment.SAFETY.contains(formula), (Object)formula);
        }

        @Override
        public AllAcceptance acceptance() {
            return AllAcceptance.INSTANCE;
        }

        @Override
        @Nullable
        protected Edge<EquivalenceClass> buildEdge(EquivalenceClass successor) {
            return successor.isFalse() ? null : Edge.of(successor);
        }

        public EquivalenceClass onlyInitialStateWithRemainder(EquivalenceClass remainder) {
            return this.onlyInitialState().and(super.initialStateInternal(remainder));
        }
    }

    public static final class CoSafety
    extends Terminal<BuchiAcceptance> {
        public CoSafety(Factories factories, boolean eagerUnfold, Formula formula) {
            super(factories, eagerUnfold, formula);
            Preconditions.checkArgument((boolean)SyntacticFragment.CO_SAFETY.contains(formula), (Object)formula);
        }

        @Override
        public BuchiAcceptance acceptance() {
            return BuchiAcceptance.INSTANCE;
        }

        @Override
        @Nullable
        protected Edge<EquivalenceClass> buildEdge(EquivalenceClass successor) {
            if (successor.isFalse()) {
                return null;
            }
            return successor.isTrue() ? Edge.of(successor, 0) : Edge.of(successor);
        }
    }

    private static abstract class Terminal<A extends OmegaAcceptance>
    extends Base<EquivalenceClass, A> {
        private final EquivalenceClass initialState;

        private Terminal(Factories factories, boolean eagerUnfold, Formula formula) {
            super(factories, eagerUnfold);
            this.initialState = this.initialStateInternal(this.factory.of(formula));
        }

        @Override
        public final EquivalenceClass onlyInitialState() {
            return this.initialState;
        }

        @Override
        @Nullable
        public final Edge<EquivalenceClass> edge(EquivalenceClass clazz, BitSet valuation) {
            return this.buildEdge(super.successorInternal(clazz, valuation));
        }

        @Override
        public final ValuationTree<Edge<EquivalenceClass>> edgeTree(EquivalenceClass clazz) {
            return super.successorTreeInternal(clazz, x -> Collections3.ofNullable(this.buildEdge((EquivalenceClass)x)));
        }

        @Nullable
        protected abstract Edge<EquivalenceClass> buildEdge(EquivalenceClass var1);
    }

    static abstract class Base<S, A extends OmegaAcceptance>
    extends AbstractCachedStatesAutomaton<S, A>
    implements EdgeTreeAutomatonMixin<S, A> {
        final boolean eagerUnfold;
        final EquivalenceClassFactory factory;
        final ValuationSetFactory valuationSetFactory;

        Base(Factories factories, boolean eagerUnfold) {
            this.eagerUnfold = eagerUnfold;
            this.factory = factories.eqFactory;
            this.valuationSetFactory = factories.vsFactory;
        }

        @Override
        public final ValuationSetFactory factory() {
            return this.valuationSetFactory;
        }

        @Override
        public abstract S onlyInitialState();

        @Override
        public final Set<S> initialStates() {
            return Set.of(this.onlyInitialState());
        }

        @Override
        @Nullable
        public abstract Edge<S> edge(S var1, BitSet var2);

        @Override
        public final Set<Edge<S>> edges(S state, BitSet valuation) {
            return Collections3.ofNullable(this.edge(state, valuation));
        }

        @Override
        public abstract ValuationTree<Edge<S>> edgeTree(S var1);

        @Override
        public boolean is(Automaton.Property property) {
            if (property == Automaton.Property.DETERMINISTIC || property == Automaton.Property.SEMI_DETERMINISTIC || property == Automaton.Property.LIMIT_DETERMINISTIC) {
                return true;
            }
            return super.is(property);
        }

        EquivalenceClass initialStateInternal(EquivalenceClass clazz) {
            return this.eagerUnfold ? clazz.unfold() : clazz;
        }

        EquivalenceClass successorInternal(EquivalenceClass clazz, BitSet valuation) {
            return this.eagerUnfold ? clazz.temporalStepUnfold(valuation) : clazz.unfoldTemporalStep(valuation);
        }

        ValuationTree<EquivalenceClass> successorTreeInternal(EquivalenceClass clazz) {
            return this.eagerUnfold ? clazz.temporalStepTree(preSuccessor -> Set.of(preSuccessor.unfold())) : clazz.unfold().temporalStepTree(Set::of);
        }

        <T> ValuationTree<T> successorTreeInternal(EquivalenceClass clazz, Function<EquivalenceClass, Set<T>> edgeFunction) {
            return this.eagerUnfold ? clazz.temporalStepTree(x -> (Set)edgeFunction.apply(x.unfold())) : clazz.unfold().temporalStepTree(edgeFunction);
        }
    }
}

