/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import owl.cinterface.Acceptance;
import owl.cinterface.DeterministicAutomaton;
import owl.cinterface.Hacks;
import owl.cinterface.RealizabilityRewriter;
import owl.collections.LabelledTree;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.PropositionalFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UnaryModalOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.LiteralMapper;
import owl.ltl.rewriter.PullUpXVisitor;
import owl.ltl.rewriter.SimplifierFactory;
import owl.ltl.util.FormulaIsomorphism;
import owl.ltl.visitors.PropositionalVisitor;
import owl.util.annotation.CEntryPoint;

public final class DecomposedDPA {
    public final LabelledTree<Tag, Reference> structure;
    private final List<Reference> leaves;
    public final List<DeterministicAutomaton<?, ?>> automata;
    private final Map<ImmutableIntArray, Status> profiles = new HashMap<ImmutableIntArray, Status>();

    private DecomposedDPA(LabelledTree<Tag, Reference> structure, List<DeterministicAutomaton<?, ?>> automata) {
        this.automata = automata;
        this.leaves = structure.leavesStream().collect(Collectors.toUnmodifiableList());
        this.structure = structure;
    }

    @CEntryPoint
    public static DecomposedDPA of(Formula formula, boolean simplify, boolean monolithic, int firstOutputVariable) {
        Formula nnfLight = formula.substitute(Formula::nnf);
        BitSet inputVariables = new BitSet();
        inputVariables.set(0, firstOutputVariable);
        Formula processedFormula = simplify ? SimplifierFactory.apply(RealizabilityRewriter.removeSingleValuedInputLiterals(inputVariables, SimplifierFactory.apply(nnfLight, SimplifierFactory.Mode.SYNTACTIC_FIXPOINT)), SimplifierFactory.Mode.SYNTACTIC_FIXPOINT) : nnfLight;
        Builder builder = new Builder(processedFormula.accept(Annotator.INSTANCE));
        LabelledTree<Tag, Reference> structure1 = monolithic ? builder.createLeaf(processedFormula) : processedFormula.accept(builder);
        return new DecomposedDPA(structure1, List.copyOf(builder.automata));
    }

    @CEntryPoint
    public boolean declare(int status, int ... profile) {
        ImmutableIntArray normalisedProfile = this.normalise(profile);
        Status newStatus = Status.values()[status];
        assert (newStatus == Status.REALIZABLE || newStatus == Status.UNREALIZABLE);
        Status oldStatus = this.profiles.put(normalisedProfile, newStatus);
        assert (oldStatus == null || oldStatus == newStatus);
        return oldStatus == null;
    }

    @CEntryPoint
    public int query(int ... profile) {
        return this.profiles.getOrDefault(this.normalise(profile), Status.UNKNOWN).ordinal();
    }

    private ImmutableIntArray normalise(int ... stateIndices) {
        ImmutableIntArray.Builder builder = ImmutableIntArray.builder((int)stateIndices.length);
        int i = 0;
        for (Reference reference : this.leaves) {
            builder.add(this.automata.get(reference.index).normalise(stateIndices[i]));
            ++i;
        }
        assert (stateIndices.length == i) : "Length mismatch.";
        return builder.build();
    }

    private static boolean isSingleStep(Formula formula) {
        if (formula instanceof Conjunction) {
            return ((Conjunction)formula).children.stream().allMatch(DecomposedDPA::isSingleStep);
        }
        return formula instanceof GOperator && SyntacticFragment.SINGLE_STEP.contains(((GOperator)formula).operand);
    }

    static class Annotator
    extends PropositionalVisitor<Map<Formula, Acceptance>> {
        static final Annotator INSTANCE = new Annotator();

        Annotator() {
        }

        @Override
        protected Map<Formula, Acceptance> visit(Formula.TemporalOperator formula) {
            if (SyntacticFragment.SAFETY.contains(formula)) {
                return Map.of(formula, Acceptance.SAFETY);
            }
            if (SyntacticFragment.CO_SAFETY.contains(formula)) {
                return Map.of(formula, Acceptance.CO_SAFETY);
            }
            if (SyntacticFragments.isDetBuchiRecognisable(formula)) {
                return Map.of(formula, Acceptance.BUCHI);
            }
            if (SyntacticFragments.isDetCoBuchiRecognisable(formula)) {
                return Map.of(formula, Acceptance.CO_BUCHI);
            }
            return Map.of(formula, Acceptance.PARITY);
        }

        @Override
        public Map<Formula, Acceptance> visit(Biconditional biconditional) {
            HashMap<Formula, Acceptance> acceptanceMap = new HashMap<Formula, Acceptance>();
            acceptanceMap.putAll(biconditional.left.accept(this));
            acceptanceMap.putAll(biconditional.right.accept(this));
            Acceptance leftAcceptance = (Acceptance)((Object)acceptanceMap.get(biconditional.left));
            Acceptance rightAcceptance = (Acceptance)((Object)acceptanceMap.get(biconditional.right));
            if (leftAcceptance.lub(rightAcceptance).isLessOrEqualWeak()) {
                acceptanceMap.put(biconditional, Acceptance.WEAK);
            } else {
                acceptanceMap.put(biconditional, Acceptance.PARITY);
            }
            return acceptanceMap;
        }

        @Override
        public Map<Formula, Acceptance> visit(BooleanConstant booleanConstant) {
            return Map.of(booleanConstant, Acceptance.BOTTOM);
        }

        @Override
        public Map<Formula, Acceptance> visit(Conjunction conjunction) {
            return this.visitPropositional(conjunction);
        }

        @Override
        public Map<Formula, Acceptance> visit(Disjunction disjunction) {
            return this.visitPropositional(disjunction);
        }

        private Map<Formula, Acceptance> visitPropositional(PropositionalFormula formula) {
            Acceptance acceptance = Acceptance.BOTTOM;
            HashMap<Formula, Acceptance> acceptanceMap = new HashMap<Formula, Acceptance>();
            for (Formula child : formula.children) {
                Map<Formula, Acceptance> childDecisions = child.accept(this);
                acceptanceMap.putAll(childDecisions);
                acceptance = acceptance.lub((Acceptance)((Object)acceptanceMap.get(child)));
            }
            acceptanceMap.put(formula, acceptance);
            return acceptanceMap;
        }
    }

    static class Clusters {
        private static final Predicate<Formula> INTERESTING_OPERATOR = o -> o instanceof Formula.ModalOperator && !(o instanceof XOperator);
        List<Set<Formula>> clusterList = new ArrayList<Set<Formula>>();

        Clusters() {
        }

        void insert(Formula formula) {
            HashSet<Formula> cluster = new HashSet<Formula>();
            cluster.add(formula);
            this.clusterList.removeIf(x -> {
                Set modalOperators2;
                Set<Formula.TemporalOperator> modalOperators1 = formula.subformulas(INTERESTING_OPERATOR);
                if (!Collections.disjoint(modalOperators1, modalOperators2 = x.stream().flatMap(y -> y.subformulas(INTERESTING_OPERATOR).stream()).collect(Collectors.toSet()))) {
                    cluster.addAll((Collection<Formula>)x);
                    return true;
                }
                return false;
            });
            this.clusterList.add(cluster);
        }
    }

    static final class Builder
    extends PropositionalVisitor<LabelledTree<Tag, Reference>> {
        private final Map<Formula, Acceptance> annotatedTree;
        private final List<DeterministicAutomaton<?, ?>> automata = new ArrayList();
        private final Map<Formula, Reference> lookup = new HashMap<Formula, Reference>();

        Builder(Map<Formula, Acceptance> annotatedTree) {
            this.annotatedTree = new HashMap<Formula, Acceptance>(annotatedTree);
        }

        private LabelledTree<Tag, Reference> createLeaf(Formula formula) {
            assert (SyntacticFragment.NNF.contains(formula));
            Reference reference = this.lookup.get(formula);
            if (reference != null) {
                return new LabelledTree.Leaf<Tag, Reference>(reference);
            }
            for (Map.Entry<Formula, Reference> entry : this.lookup.entrySet()) {
                int[] mapping = FormulaIsomorphism.compute(formula, entry.getKey());
                if (mapping == null) continue;
                reference = entry.getValue();
                int[] newMapping = Arrays.copyOf(mapping, mapping.length);
                for (int i = 0; i < newMapping.length; ++i) {
                    int j = newMapping[i];
                    if (j == -1) continue;
                    newMapping[i] = reference.alphabetMapping.get(j);
                    assert (newMapping[i] != -1);
                }
                return new LabelledTree.Leaf<Tag, Reference>(new Reference(formula, reference.index, newMapping));
            }
            LiteralMapper.ShiftedFormula shiftedFormula = LiteralMapper.shiftLiterals(formula);
            Reference newReference = new Reference(formula, this.automata.size(), shiftedFormula.mapping);
            this.automata.add(DeterministicAutomaton.of(Hacks.attachDummyAlphabet(shiftedFormula.formula)));
            this.lookup.put(formula, newReference);
            return new LabelledTree.Leaf<Tag, Reference>(newReference);
        }

        private List<LabelledTree<Tag, Reference>> createLeaves(PropositionalFormula formula) {
            Clusters safety = new Clusters();
            HashMap<Integer, Clusters> safetySingleStep = new HashMap<Integer, Clusters>();
            Clusters coSafety = new Clusters();
            TreeSet<Formula> fgSafety = new TreeSet<Formula>();
            TreeSet<Formula> gfCoSafety = new TreeSet<Formula>();
            TreeSet<Formula> fSafety = new TreeSet<Formula>();
            TreeSet<Formula> gCoSafety = new TreeSet<Formula>();
            TreeSet<Formula> lessThanParityRequired = new TreeSet<Formula>();
            TreeSet<Formula> parityRequired = new TreeSet<Formula>();
            for (Formula x2 : formula.children) {
                if (SyntacticFragment.SAFETY.contains(x2)) {
                    PullUpXVisitor.XFormula rewrittenX = x2.accept(PullUpXVisitor.INSTANCE);
                    if (DecomposedDPA.isSingleStep(rewrittenX.rawFormula())) {
                        safetySingleStep.computeIfAbsent(rewrittenX.depth(), ignore -> new Clusters()).insert(XOperator.of(rewrittenX.rawFormula(), rewrittenX.depth()));
                        continue;
                    }
                    safety.insert(x2);
                    continue;
                }
                if (SyntacticFragment.CO_SAFETY.contains(x2)) {
                    coSafety.insert(x2);
                    continue;
                }
                if (SyntacticFragments.isGfCoSafety(x2)) {
                    gfCoSafety.add(x2);
                    continue;
                }
                if (SyntacticFragments.isDetBuchiRecognisable(x2)) {
                    gCoSafety.add(x2);
                    continue;
                }
                if (SyntacticFragments.isFgSafety(x2)) {
                    fgSafety.add(x2);
                    continue;
                }
                if (SyntacticFragments.isDetCoBuchiRecognisable(x2)) {
                    fSafety.add(x2);
                    continue;
                }
                if (this.annotatedTree.get(x2) == Acceptance.PARITY) {
                    parityRequired.add(x2);
                    continue;
                }
                assert (this.annotatedTree.get(x2).isLessThanParity());
                lessThanParityRequired.add(x2);
            }
            ArrayList<LabelledTree<Tag, Reference>> children = new ArrayList<LabelledTree<Tag, Reference>>();
            Function<Iterable, Formula> merger = formula instanceof Conjunction ? Conjunction::of : Disjunction::of;
            safetySingleStep.values().forEach(x -> x.clusterList.forEach(y -> {
                assert (!y.isEmpty());
                children.add(this.createLeaf((Formula)merger.apply((Iterable)y)));
            }));
            safety.clusterList.forEach(x -> {
                assert (!x.isEmpty());
                children.add(this.createLeaf((Formula)merger.apply((Iterable)x)));
            });
            coSafety.clusterList.forEach(x -> {
                assert (!x.isEmpty());
                children.add(this.createLeaf((Formula)merger.apply((Iterable)x)));
            });
            fgSafety.forEach(x -> children.add(this.createLeaf((Formula)x)));
            gfCoSafety.forEach(x -> children.add(this.createLeaf((Formula)x)));
            fSafety.forEach(x -> children.add(this.createLeaf((Formula)x)));
            gCoSafety.forEach(x -> children.add(this.createLeaf((Formula)x)));
            for (Formula child : lessThanParityRequired) {
                children.add(child.accept(this));
            }
            if (parityRequired.size() == 1) {
                children.add(((Formula)parityRequired.first()).accept(this));
            } else if (parityRequired.size() > 1) {
                Formula mergedFormula = merger.apply(parityRequired).nnf();
                children.add(this.createLeaf(mergedFormula));
            }
            return children;
        }

        @Override
        protected LabelledTree<Tag, Reference> visit(Formula.TemporalOperator formula) {
            return this.createLeaf(formula);
        }

        private boolean keepTreeStructureBiconditional(Formula formula) {
            if (formula instanceof PropositionalFormula) {
                if (formula.children().stream().filter(x -> this.annotatedTree.get(x) == Acceptance.PARITY).count() > 1L) {
                    return false;
                }
            } else {
                return false;
            }
            return formula.accept(new PropositionalVisitor<Boolean>(){

                @Override
                protected Boolean visit(Formula.TemporalOperator formula) {
                    return (SyntacticFragments.isAlmostAll(formula) || SyntacticFragments.isInfinitelyOften(formula)) && SyntacticFragment.SINGLE_STEP.contains(((UnaryModalOperator)((UnaryModalOperator)formula).operand).operand);
                }

                @Override
                public Boolean visit(Biconditional biconditional) {
                    return biconditional.left.accept(this) != false && biconditional.right.accept(this) != false;
                }

                @Override
                public Boolean visit(Conjunction conjunction) {
                    return conjunction.children.stream().allMatch(this::apply);
                }

                @Override
                public Boolean visit(Disjunction disjunction) {
                    return disjunction.children.stream().allMatch(this::apply);
                }
            });
        }

        @Override
        public LabelledTree<Tag, Reference> visit(Biconditional biconditional) {
            if (this.annotatedTree.get(biconditional.left) == Acceptance.PARITY && this.annotatedTree.get(biconditional.right) == Acceptance.PARITY) {
                if (this.keepTreeStructureBiconditional(biconditional.left) || this.keepTreeStructureBiconditional(biconditional.right)) {
                    return new LabelledTree.Node<Tag, Reference>(Tag.BICONDITIONAL, List.of(biconditional.left.accept(this), biconditional.right.accept(this)));
                }
                Formula nnf = biconditional.nnf();
                this.annotatedTree.putAll(nnf.accept(Annotator.INSTANCE));
                return nnf.accept(this);
            }
            return new LabelledTree.Node<Tag, Reference>(Tag.BICONDITIONAL, List.of(biconditional.left.accept(this), biconditional.right.accept(this)));
        }

        @Override
        public LabelledTree<Tag, Reference> visit(BooleanConstant booleanConstant) {
            return this.createLeaf(booleanConstant);
        }

        @Override
        public LabelledTree<Tag, Reference> visit(Conjunction conjunction) {
            List leaves = this.createLeaves(conjunction);
            return leaves.size() == 1 ? leaves.get(0) : new LabelledTree.Node(Tag.CONJUNCTION, leaves);
        }

        @Override
        public LabelledTree<Tag, Reference> visit(Disjunction disjunction) {
            List leaves = this.createLeaves(disjunction);
            return leaves.size() == 1 ? leaves.get(0) : new LabelledTree.Node(Tag.DISJUNCTION, leaves);
        }
    }

    public static final class Reference {
        public final Formula formula;
        public final int index;
        public final ImmutableIntArray alphabetMapping;

        Reference(Formula formula, int index, ImmutableIntArray alphabetMapping) {
            this.formula = formula;
            this.index = index;
            this.alphabetMapping = alphabetMapping;
        }

        Reference(Formula formula, int index, int[] alphabetMapping) {
            this(formula, index, ImmutableIntArray.copyOf((int[])alphabetMapping));
        }

        @CEntryPoint
        public int[] alphabetMapping() {
            return this.alphabetMapping.toArray();
        }
    }

    static enum Tag {
        BICONDITIONAL,
        CONJUNCTION,
        DISJUNCTION;

    }

    static enum Status {
        REALIZABLE,
        UNREALIZABLE,
        UNKNOWN;

    }
}

