/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.WOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;
import owl.util.annotation.CEntryPoint;

public final class MOperator
extends BinaryModalOperator {
    public MOperator(Formula leftOperand, Formula rightOperand) {
        super(MOperator.class, leftOperand, rightOperand);
    }

    @CEntryPoint
    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (leftOperand instanceof BooleanConstant || leftOperand instanceof FOperator || leftOperand.equals(rightOperand) || rightOperand.equals(BooleanConstant.FALSE)) {
            return Conjunction.of(leftOperand, rightOperand);
        }
        if (rightOperand == BooleanConstant.TRUE) {
            return FOperator.of(leftOperand);
        }
        if (leftOperand instanceof MOperator && rightOperand.equals(((MOperator)leftOperand).right)) {
            return leftOperand;
        }
        return new MOperator(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String operatorSymbol() {
        return "M";
    }

    @Override
    public Formula nnf() {
        return MOperator.of(this.left.nnf(), this.right.nnf());
    }

    @Override
    public Formula not() {
        return WOperator.of(this.left.not(), this.right.not());
    }

    @Override
    public Formula unfold() {
        return Conjunction.of(this.right.unfold(), Disjunction.of(this.left.unfold(), (Formula)this));
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Conjunction.of(this.right.unfoldTemporalStep(valuation), Disjunction.of(this.left.unfoldTemporalStep(valuation), (Formula)this));
    }
}

