/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.analysis;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jhoafparser.analysis.AcceptanceSimplify;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerFactory;
import jhoafparser.consumer.HOAIntermediateBatchProcessState;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredState;
import jhoafparser.util.PropertyFilter;

public class DeduceAccName
extends HOAIntermediateBatchProcessState {
    private int numberOfAccSets;
    private BooleanExpression<AtomAcceptance> accExpr;
    private List<String> allowedAcceptance = new ArrayList<String>();
    private Transformed chosenTransformation = null;
    private boolean defaultPlaceAcceptanceOnState = false;
    private PropertyFilter propertyFilter = new PropertyFilter(true, true, true, true);
    private boolean propertyStateAcc = false;
    private boolean propertyTransAcc = false;

    public DeduceAccName(HOAConsumer next) {
        super(next);
        this.allowedAcceptance.add("all");
        this.allowedAcceptance.add("none");
        this.allowedAcceptance.add("Buchi");
        this.allowedAcceptance.add("co-Buchi");
        this.allowedAcceptance.add("generalized-Buchi");
        this.allowedAcceptance.add("generalized-co-Buchi");
        this.allowedAcceptance.add("Rabin");
        this.allowedAcceptance.add("Streett");
    }

    public DeduceAccName(HOAConsumer next, List<String> allowedAcceptance) {
        super(next);
        this.allowedAcceptance.addAll(allowedAcceptance);
    }

    @Override
    public void setAcceptanceCondition(int numberOfSets, BooleanExpression<AtomAcceptance> accExpr) throws HOAConsumerException {
        this.numberOfAccSets = numberOfSets;
        this.accExpr = accExpr;
    }

    @Override
    public void provideAcceptanceName(String name, List<Object> extraInfo) throws HOAConsumerException {
    }

    @Override
    public void addProperties(List<String> properties) throws HOAConsumerException {
        for (String property : properties) {
            if (property.equals("state-acc")) {
                this.propertyStateAcc = true;
            }
            if (!property.equals("trans-acc")) continue;
            this.propertyTransAcc = true;
        }
        this.next.addProperties(this.propertyFilter.filter(properties));
    }

    @Override
    public void notifyBodyStart() throws HOAConsumerException {
        if (this.accExpr == null) {
            throw new HOAConsumerException("Missing acceptance condition!");
        }
        if (this.propertyStateAcc) {
            this.defaultPlaceAcceptanceOnState = true;
        } else if (this.propertyTransAcc) {
            this.defaultPlaceAcceptanceOnState = false;
        }
        BooleanExpression<AtomAcceptance> simplified = AcceptanceSimplify.simplify(this.accExpr);
        boolean deducedAccName = false;
        for (String allowed : this.allowedAcceptance) {
            Transformed transformed = new Transformed();
            String name = null;
            ArrayList<Object> extra = new ArrayList<Object>();
            switch (allowed) {
                case "all": {
                    if (!this.toAll(simplified, transformed)) break;
                    name = "all";
                    break;
                }
                case "none": {
                    if (!this.toNone(simplified, transformed)) break;
                    name = "none";
                    break;
                }
                case "Buchi": {
                    if (!this.toBuchi(simplified, transformed)) break;
                    name = "Buchi";
                    break;
                }
                case "co-Buchi": {
                    if (!this.toCoBuchi(simplified, transformed)) break;
                    name = "co-Buchi";
                    break;
                }
                case "generalized-Buchi": {
                    if (!this.toGeneralizedBuchi(simplified, transformed)) break;
                    extra.add(transformed.getNumberOfAccSets());
                    name = "generalized-Buchi";
                    break;
                }
                case "generalized-co-Buchi": {
                    if (!this.toGeneralizedCoBuchi(simplified, transformed)) break;
                    extra.add(transformed.getNumberOfAccSets());
                    name = "generalized-co-Buchi";
                    break;
                }
                case "Rabin": {
                    if (!this.toRabin(simplified, transformed)) break;
                    extra.add(transformed.getNumberOfAccSets() / 2);
                    name = "Rabin";
                    break;
                }
                case "Streett": {
                    if (!this.toStreett(simplified, transformed)) break;
                    extra.add(transformed.getNumberOfAccSets() / 2);
                    name = "Streett";
                    break;
                }
            }
            if (name == null) continue;
            this.next.setAcceptanceCondition(transformed.getNumberOfAccSets(), transformed.getExpression());
            this.next.provideAcceptanceName(name, extra);
            this.chosenTransformation = transformed;
            deducedAccName = true;
            break;
        }
        if (!deducedAccName) {
            this.next.setAcceptanceCondition(this.numberOfAccSets, this.accExpr);
        }
        this.next.notifyBodyStart();
    }

    @Override
    public boolean processState(StoredState state, List<StoredEdgeImplicit> edgesImplicit, List<StoredEdgeWithLabel> edgesWithLabel) throws HOAConsumerException {
        block8: {
            boolean hasStateAcceptance;
            block7: {
                if (this.chosenTransformation == null) {
                    return true;
                }
                hasStateAcceptance = this.hasStateAcceptance(state);
                boolean placeAcceptanceOnState = hasStateAcceptance ? !this.hasTransitionAcceptance(edgesImplicit, edgesWithLabel) : (this.hasTransitionAcceptance(edgesImplicit, edgesWithLabel) ? false : this.defaultPlaceAcceptanceOnState);
                if (placeAcceptanceOnState) {
                    this.next.addState(state.getStateId(), state.getInfo(), state.getLabelExpr(), this.transformAcceptance(state.getAccSignature()));
                } else {
                    this.next.addState(state.getStateId(), state.getInfo(), state.getLabelExpr(), null);
                }
                if (edgesImplicit == null) break block7;
                for (StoredEdgeImplicit edge : edgesImplicit) {
                    List<Integer> accEdge = edge.getAccSignature();
                    if (accEdge != null && hasStateAcceptance) {
                        accEdge = new ArrayList<Integer>(accEdge);
                        accEdge.addAll(state.getAccSignature());
                    }
                    this.next.addEdgeImplicit(state.getStateId(), edge.getConjSuccessors(), this.transformAcceptance(accEdge));
                }
                break block8;
            }
            if (edgesWithLabel == null) break block8;
            for (StoredEdgeWithLabel edge : edgesWithLabel) {
                List<Integer> accEdge = edge.getAccSignature();
                if (accEdge != null && hasStateAcceptance) {
                    accEdge = new ArrayList<Integer>(accEdge);
                    accEdge.addAll(state.getAccSignature());
                }
                this.next.addEdgeWithLabel(state.getStateId(), edge.getLabelExpr(), edge.getConjSuccessors(), this.transformAcceptance(accEdge));
            }
        }
        return false;
    }

    private boolean toAll(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        switch (acc.getType()) {
            case EXP_TRUE: {
                transformed.setExpression(new BooleanExpression<AtomAcceptance>(true));
                return true;
            }
        }
        return false;
    }

    private boolean toNone(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        switch (acc.getType()) {
            case EXP_FALSE: {
                transformed.setExpression(new BooleanExpression<AtomAcceptance>(false));
                return true;
            }
        }
        return false;
    }

    private boolean toBuchi(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        int inf;
        switch (acc.getType()) {
            case EXP_TRUE: {
                inf = transformed.createAccSet(true);
                break;
            }
            case EXP_FALSE: {
                inf = transformed.createAccSet(false);
                break;
            }
            case EXP_ATOM: {
                AtomAcceptance atom = acc.getAtom();
                if (atom.getType() == AtomAcceptance.Type.TEMPORAL_FIN) {
                    return false;
                }
                inf = transformed.createAccSet(atom.getAcceptanceSet(), atom.isNegated());
                break;
            }
            default: {
                return false;
            }
        }
        BooleanExpression<AtomAcceptance> Inf = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(inf));
        if (transformed.getExpression() != null) {
            transformed.setExpression(transformed.getExpression().and(Inf));
        } else {
            transformed.setExpression(Inf);
        }
        return true;
    }

    private boolean toCoBuchi(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        int fin;
        switch (acc.getType()) {
            case EXP_TRUE: {
                fin = transformed.createAccSet(false);
                break;
            }
            case EXP_FALSE: {
                fin = transformed.createAccSet(true);
                break;
            }
            case EXP_ATOM: {
                AtomAcceptance atom = acc.getAtom();
                if (atom.getType() == AtomAcceptance.Type.TEMPORAL_INF) {
                    return false;
                }
                fin = transformed.createAccSet(atom.getAcceptanceSet(), atom.isNegated());
                break;
            }
            default: {
                return false;
            }
        }
        BooleanExpression<AtomAcceptance> Fin = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(fin));
        if (transformed.getExpression() != null) {
            transformed.setExpression(transformed.getExpression().and(Fin));
        } else {
            transformed.setExpression(Fin);
        }
        return true;
    }

    private boolean toGeneralizedBuchi(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        switch (acc.getType()) {
            case EXP_TRUE: {
                return this.toBuchi(acc, transformed);
            }
            case EXP_FALSE: {
                transformed.setExpression(new BooleanExpression<AtomAcceptance>(false));
                return true;
            }
            case EXP_ATOM: {
                return this.toBuchi(acc, transformed);
            }
            case EXP_AND: {
                if (!this.toGeneralizedBuchi(acc.getLeft(), transformed)) {
                    return false;
                }
                return this.toGeneralizedBuchi(acc.getRight(), transformed);
            }
        }
        return false;
    }

    private boolean toGeneralizedCoBuchi(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        switch (acc.getType()) {
            case EXP_TRUE: {
                transformed.setExpression(new BooleanExpression<AtomAcceptance>(true));
                return true;
            }
            case EXP_FALSE: {
                return this.toCoBuchi(acc, transformed);
            }
            case EXP_ATOM: {
                return this.toCoBuchi(acc, transformed);
            }
            case EXP_AND: {
                if (!this.toGeneralizedCoBuchi(acc.getLeft(), transformed)) {
                    return false;
                }
                return this.toGeneralizedCoBuchi(acc.getRight(), transformed);
            }
        }
        return false;
    }

    private boolean toRabin(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        switch (acc.getType()) {
            case EXP_OR: {
                if (this.toRabin(acc.getLeft(), transformed)) {
                    return this.toRabin(acc.getRight(), transformed);
                }
                return false;
            }
            case EXP_TRUE: 
            case EXP_ATOM: 
            case EXP_AND: {
                return this.toRabinPair(acc, transformed);
            }
            case EXP_FALSE: {
                transformed.setExpression(new BooleanExpression<AtomAcceptance>(false));
                return true;
            }
        }
        return false;
    }

    private boolean toRabinPair(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        int inf;
        int fin;
        switch (acc.getType()) {
            case EXP_FALSE: {
                return true;
            }
            case EXP_TRUE: {
                fin = transformed.createAccSet(false);
                inf = transformed.createAccSet(true);
                break;
            }
            case EXP_ATOM: {
                AtomAcceptance atom = acc.getAtom();
                if (atom.getType() == AtomAcceptance.Type.TEMPORAL_FIN) {
                    fin = transformed.createAccSet(atom.getAcceptanceSet(), atom.isNegated());
                    inf = transformed.createAccSet(true);
                    break;
                }
                fin = transformed.createAccSet(false);
                inf = transformed.createAccSet(atom.getAcceptanceSet(), atom.isNegated());
                break;
            }
            case EXP_AND: {
                BooleanExpression<AtomAcceptance> left = acc.getLeft();
                BooleanExpression<AtomAcceptance> right = acc.getRight();
                if (left.isAtom() && left.getAtom().getType() == AtomAcceptance.Type.TEMPORAL_INF) {
                    left = acc.getRight();
                    right = acc.getLeft();
                } else if (right.isAtom() && right.getAtom().getType() == AtomAcceptance.Type.TEMPORAL_FIN) {
                    left = acc.getRight();
                    right = acc.getLeft();
                }
                if (!left.isAtom() || left.getAtom().getType() != AtomAcceptance.Type.TEMPORAL_FIN) {
                    return false;
                }
                if (!right.isAtom() || right.getAtom().getType() != AtomAcceptance.Type.TEMPORAL_INF) {
                    return false;
                }
                fin = transformed.createAccSet(left.getAtom().getAcceptanceSet(), left.getAtom().isNegated());
                inf = transformed.createAccSet(right.getAtom().getAcceptanceSet(), right.getAtom().isNegated());
                break;
            }
            default: {
                return false;
            }
        }
        BooleanExpression<AtomAcceptance> pair = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(fin));
        pair = pair.and(new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(inf)));
        if (transformed.getExpression() == null) {
            transformed.setExpression(pair);
        } else {
            transformed.setExpression(transformed.getExpression().or(pair));
        }
        return true;
    }

    private boolean toStreett(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        switch (acc.getType()) {
            case EXP_AND: {
                if (this.toStreett(acc.getLeft(), transformed)) {
                    return this.toStreett(acc.getRight(), transformed);
                }
                return false;
            }
            case EXP_FALSE: 
            case EXP_ATOM: 
            case EXP_OR: {
                return this.toStreettPair(acc, transformed);
            }
            case EXP_TRUE: {
                transformed.setExpression(new BooleanExpression<AtomAcceptance>(true));
                return true;
            }
        }
        return false;
    }

    private boolean toStreettPair(BooleanExpression<AtomAcceptance> acc, Transformed transformed) {
        int inf;
        int fin;
        switch (acc.getType()) {
            case EXP_TRUE: {
                return true;
            }
            case EXP_FALSE: {
                fin = transformed.createAccSet(true);
                inf = transformed.createAccSet(false);
                break;
            }
            case EXP_ATOM: {
                AtomAcceptance atom = acc.getAtom();
                if (atom.getType() == AtomAcceptance.Type.TEMPORAL_FIN) {
                    fin = transformed.createAccSet(atom.getAcceptanceSet(), atom.isNegated());
                    inf = transformed.createAccSet(true);
                    break;
                }
                fin = transformed.createAccSet(false);
                inf = transformed.createAccSet(atom.getAcceptanceSet(), atom.isNegated());
                break;
            }
            case EXP_OR: {
                BooleanExpression<AtomAcceptance> left = acc.getLeft();
                BooleanExpression<AtomAcceptance> right = acc.getRight();
                if (left.isAtom() && left.getAtom().getType() == AtomAcceptance.Type.TEMPORAL_INF) {
                    left = acc.getRight();
                    right = acc.getLeft();
                } else if (right.isAtom() && right.getAtom().getType() == AtomAcceptance.Type.TEMPORAL_FIN) {
                    left = acc.getRight();
                    right = acc.getLeft();
                }
                if (!left.isAtom() || left.getAtom().getType() != AtomAcceptance.Type.TEMPORAL_FIN) {
                    return false;
                }
                if (!right.isAtom() || right.getAtom().getType() != AtomAcceptance.Type.TEMPORAL_INF) {
                    return false;
                }
                fin = transformed.createAccSet(left.getAtom().getAcceptanceSet(), left.getAtom().isNegated());
                inf = transformed.createAccSet(right.getAtom().getAcceptanceSet(), right.getAtom().isNegated());
                break;
            }
            default: {
                return false;
            }
        }
        BooleanExpression<AtomAcceptance> pair = new BooleanExpression<AtomAcceptance>(AtomAcceptance.Fin(fin));
        pair = pair.or(new BooleanExpression<AtomAcceptance>(AtomAcceptance.Inf(inf)));
        if (transformed.getExpression() == null) {
            transformed.setExpression(pair);
        } else {
            transformed.setExpression(transformed.getExpression().and(pair));
        }
        return true;
    }

    private boolean hasStateAcceptance(StoredState state) {
        return state.getAccSignature() != null;
    }

    private boolean hasTransitionAcceptance(List<StoredEdgeImplicit> edgesImplicit, List<StoredEdgeWithLabel> edgesWithLabel) {
        block3: {
            block2: {
                if (edgesImplicit == null) break block2;
                for (StoredEdgeImplicit edge : edgesImplicit) {
                    if (edge.getAccSignature() == null) continue;
                    return true;
                }
                break block3;
            }
            if (edgesWithLabel == null) break block3;
            for (StoredEdgeWithLabel edge : edgesWithLabel) {
                if (edge.getAccSignature() == null) continue;
                return true;
            }
        }
        return false;
    }

    private List<Integer> transformAcceptance(List<Integer> acceptance) {
        BitSet acc = new BitSet();
        if (acceptance != null) {
            for (Integer a : acceptance) {
                acc.set(a);
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int n = this.chosenTransformation.getNumberOfAccSets();
        for (int accSetTransformed = 0; accSetTransformed < n; ++accSetTransformed) {
            if (this.chosenTransformation.isAccSetBoolean(accSetTransformed)) {
                if (!this.chosenTransformation.getAccSetBoolean(accSetTransformed)) continue;
                result.add(accSetTransformed);
                continue;
            }
            boolean negated = this.chosenTransformation.isAccSetNegated(accSetTransformed);
            int setIndex = this.chosenTransformation.getOriginalAccSet(accSetTransformed);
            if (!(acc.get(setIndex) ^ negated)) continue;
            result.add(accSetTransformed);
        }
        if (result.isEmpty() && acceptance == null) {
            result = null;
        }
        return result;
    }

    public static HOAConsumerFactory getFactory(final HOAConsumerFactory next) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new DeduceAccName(next.getNewHOAConsumer());
            }
        };
    }

    public static HOAConsumerFactory getFactory(final HOAConsumerFactory next, final List<String> allowedAcceptance) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new DeduceAccName(next.getNewHOAConsumer(), allowedAcceptance);
            }
        };
    }

    private class Transformed {
        private BooleanExpression<AtomAcceptance> expression;
        private List<Object> transformedSets = new ArrayList<Object>();

        private Transformed() {
        }

        public BooleanExpression<AtomAcceptance> getExpression() {
            return this.expression;
        }

        public void setExpression(BooleanExpression<AtomAcceptance> expression) {
            this.expression = expression;
        }

        public int createAccSet(Integer index, boolean negated) {
            int result = this.transformedSets.size();
            this.transformedSets.add((index + 1) * (negated ? -1 : 1));
            return result;
        }

        public int createAccSet(boolean value) {
            int result = this.transformedSets.size();
            this.transformedSets.add(new Boolean(value));
            return result;
        }

        public int getNumberOfAccSets() {
            return this.transformedSets.size();
        }

        public boolean isAccSetBoolean(int transformedAccSet) {
            return this.transformedSets.get(transformedAccSet) instanceof Boolean;
        }

        public boolean getAccSetBoolean(int transformedAccSet) {
            return (Boolean)this.transformedSets.get(transformedAccSet);
        }

        public int getOriginalAccSet(int transformedAccSet) {
            if (this.isAccSetBoolean(transformedAccSet)) {
                throw new UnsupportedOperationException("Acceptance set is boolean");
            }
            int i = (Integer)this.transformedSets.get(transformedAccSet);
            if (i < 0) {
                i = -i;
            }
            return i - 1;
        }

        public boolean isAccSetNegated(int transformedAccSet) {
            if (this.isAccSetBoolean(transformedAccSet)) {
                throw new UnsupportedOperationException("Acceptance set is boolean");
            }
            return (Integer)this.transformedSets.get(transformedAccSet) < 0;
        }
    }
}

