/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.parser.generated;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerFactory;
import jhoafparser.consumer.HOAIntermediateCheckValidity;
import jhoafparser.consumer.HOAIntermediateResolveAliases;
import jhoafparser.parser.HOAFParserSettings;
import jhoafparser.parser.generated.HOAFParserCCConstants;
import jhoafparser.parser.generated.HOAFParserCCTokenManager;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.parser.generated.SimpleCharStream;
import jhoafparser.parser.generated.Token;

public class HOAFParserCC
implements HOAFParserCCConstants {
    private static HOAFParserCC theParser = null;
    private static HOAConsumerFactory consumerFactory = null;
    private static HOAConsumer consumer = null;
    private static HOAFParserSettings settings;
    private static Integer currentState;
    private static boolean currentStateHasStateLabel;
    private static boolean jj_initialized_once;
    public static HOAFParserCCTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    private static void initializeParser(Reader str) {
        if (theParser == null) {
            theParser = new HOAFParserCC(str);
        } else {
            HOAFParserCC.ReInit(str);
        }
    }

    public static void parseHOA(Reader str, HOAConsumer userConsumer) throws ParseException {
        HOAFParserCC.parseHOA(str, userConsumer, null);
    }

    public static void parseHOA(Reader str, final HOAConsumer userConsumer, HOAFParserSettings settings) throws ParseException {
        HOAFParserCC.initializeParser(str);
        if (settings == null) {
            settings = new HOAFParserSettings();
        }
        HOAFParserCC.settings = settings;
        consumerFactory = HOAFParserCC.factoryFromSettings(new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return userConsumer;
            }
        });
        consumer = consumerFactory.getNewHOAConsumer();
        HOAFParserCC.newAutomaton();
        try {
            HOAFParserCC.SingleAutomaton();
        }
        finally {
            consumer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseHOA(Reader str, HOAConsumerFactory userFactory, HOAFParserSettings settings) throws ParseException {
        HOAFParserCC.initializeParser(str);
        if (settings == null) {
            settings = new HOAFParserSettings();
        }
        HOAFParserCC.settings = settings;
        consumerFactory = HOAFParserCC.factoryFromSettings(userFactory);
        try {
            while (true) {
                try {
                    HOAFParserCC.Automata();
                    if (consumer != null) {
                        consumer.notifyAbort();
                        consumer = null;
                    }
                }
                catch (AbortedException e) {
                    if (consumer == null) {
                        consumer = consumerFactory.getNewHOAConsumer();
                    }
                    consumer.notifyAbort();
                    consumer = null;
                    continue;
                }
                break;
            }
        }
        finally {
            consumer = null;
            consumerFactory = null;
        }
    }

    public static void notifyAbort() {
        throw new AbortedException();
    }

    private static HOAConsumerFactory factoryFromSettings(final HOAConsumerFactory userFactory) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                HOAConsumer consumer = userFactory.getNewHOAConsumer();
                if (consumer.parserResolvesAliases()) {
                    consumer = new HOAIntermediateResolveAliases(consumer);
                }
                if (settings.getFlagValidate()) {
                    consumer = new HOAIntermediateCheckValidity(consumer);
                    ((HOAIntermediateCheckValidity)consumer).setFlagRejectSemanticMiscHeaders(settings.getFlagRejectSemanticMiscHeaders());
                }
                return consumer;
            }
        };
    }

    private static void newAutomaton() {
        currentState = null;
        currentStateHasStateLabel = false;
    }

    public static final void Automata() throws ParseException {
        block7: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 0: {
                    HOAFParserCC.jj_consume_token(0);
                    return;
                }
                case 12: {
                    consumer = consumerFactory.getNewHOAConsumer();
                    HOAFParserCC.newAutomaton();
                    HOAFParserCC.Automaton();
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[0] = jj_gen;
                    HOAFParserCC.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 0: 
                case 12: {
                    continue block7;
                }
            }
            break;
        }
        HOAFParserCC.jj_la1[1] = jj_gen;
    }

    public static final void SingleAutomaton() throws ParseException {
        HOAFParserCC.Automaton();
        HOAFParserCC.jj_consume_token(0);
    }

    public static final void Automaton() throws ParseException {
        HOAFParserCC.Header();
        HOAFParserCC.jj_consume_token(9);
        consumer.notifyBodyStart();
        HOAFParserCC.Body();
        HOAFParserCC.jj_consume_token(10);
        if (currentState != null) {
            consumer.notifyEndOfState(currentState);
        }
        consumer.notifyEnd();
        consumer = null;
    }

    public static final void Header() throws ParseException {
        HOAFParserCC.Format();
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 37: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[2] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.HeaderItem();
        }
    }

    public static final void Format() throws ParseException {
        HOAFParserCC.jj_consume_token(12);
        String version = HOAFParserCC.Identifier();
        consumer.notifyHeaderStart(version);
    }

    public static final void HeaderItem() throws ParseException {
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 14: {
                HOAFParserCC.HeaderItemStates();
                break;
            }
            case 15: {
                HOAFParserCC.HeaderItemStart();
                break;
            }
            case 16: {
                HOAFParserCC.HeaderItemAP();
                break;
            }
            case 17: {
                HOAFParserCC.HeaderItemAlias();
                break;
            }
            case 18: {
                HOAFParserCC.HeaderItemAcceptance();
                break;
            }
            case 19: {
                HOAFParserCC.HeaderItemAccName();
                break;
            }
            case 20: {
                HOAFParserCC.HeaderItemTool();
                break;
            }
            case 21: {
                HOAFParserCC.HeaderItemName();
                break;
            }
            case 22: {
                HOAFParserCC.HeaderItemProperties();
                break;
            }
            case 37: {
                HOAFParserCC.HeaderItemMisc();
                break;
            }
            default: {
                HOAFParserCC.jj_la1[3] = jj_gen;
                HOAFParserCC.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void HeaderItemStates() throws ParseException {
        HOAFParserCC.jj_consume_token(14);
        Integer numberOfStates = HOAFParserCC.Integer();
        consumer.setNumberOfStates(numberOfStates);
    }

    public static final void HeaderItemStart() throws ParseException {
        ArrayList<Integer> startStates = new ArrayList<Integer>();
        HOAFParserCC.jj_consume_token(15);
        int startState = HOAFParserCC.Integer();
        startStates.add(startState);
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[4] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.jj_consume_token(24);
            startState = HOAFParserCC.Integer();
            startStates.add(startState);
        }
        consumer.addStartStates(startStates);
    }

    public static final void HeaderItemAP() throws ParseException {
        ArrayList<String> aps = new ArrayList<String>();
        HashSet<String> apSet = new HashSet<String>();
        HOAFParserCC.jj_consume_token(16);
        int apCount = HOAFParserCC.Integer();
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[5] = jj_gen;
                    break block3;
                }
            }
            String ap = HOAFParserCC.QuotedString();
            if (apSet.contains(ap)) {
                throw new ParseException("Atomic proposition: " + ap + " is a duplicate!");
            }
            aps.add(ap);
            apSet.add(ap);
        }
        if (aps.size() != apCount) {
            throw new ParseException("Number of provided APs (" + aps.size() + ") " + ((Object)aps).toString() + " does not match number of APs that was specified (" + apCount + ")");
        }
        consumer.setAPs(aps);
    }

    public static final void HeaderItemAlias() throws ParseException {
        HOAFParserCC.jj_consume_token(17);
        String alias = HOAFParserCC.AliasName();
        BooleanExpression<AtomLabel> labelExpression = HOAFParserCC.LabelExpr();
        consumer.addAlias(alias, labelExpression);
    }

    public static final void HeaderItemAcceptance() throws ParseException {
        HOAFParserCC.jj_consume_token(18);
        int accSetCount = HOAFParserCC.Integer();
        BooleanExpression<AtomAcceptance> accExpr = HOAFParserCC.AcceptanceCondition();
        consumer.setAcceptanceCondition(accSetCount, accExpr);
    }

    public static final BooleanExpression<AtomAcceptance> AcceptanceCondition() throws ParseException {
        BooleanExpression<AtomAcceptance> left = HOAFParserCC.AcceptanceConditionAnd();
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 25: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[6] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.jj_consume_token(25);
            BooleanExpression<AtomAcceptance> right = HOAFParserCC.AcceptanceConditionAnd();
            left = left.or(right);
        }
        return left;
    }

    public static final BooleanExpression<AtomAcceptance> AcceptanceConditionAnd() throws ParseException {
        BooleanExpression<AtomAcceptance> left = HOAFParserCC.AcceptanceConditionAtom();
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[7] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.jj_consume_token(24);
            BooleanExpression<AtomAcceptance> right = HOAFParserCC.AcceptanceConditionAtom();
            left = left.and(right);
        }
        return left;
    }

    public static final BooleanExpression<AtomAcceptance> AcceptanceConditionAtom() throws ParseException {
        BooleanExpression<Object> expression = null;
        boolean negated = false;
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 26: {
                HOAFParserCC.jj_consume_token(26);
                expression = HOAFParserCC.AcceptanceCondition();
                HOAFParserCC.jj_consume_token(27);
                break;
            }
            case 36: {
                AtomAcceptance.Type temporalOperator = HOAFParserCC.AcceptanceConditionTemporalOperator();
                HOAFParserCC.jj_consume_token(26);
                switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                    case 23: {
                        HOAFParserCC.jj_consume_token(23);
                        negated = true;
                        break;
                    }
                    default: {
                        HOAFParserCC.jj_la1[8] = jj_gen;
                    }
                }
                int accSet = HOAFParserCC.Integer();
                HOAFParserCC.jj_consume_token(27);
                AtomAcceptance acc = new AtomAcceptance(temporalOperator, accSet, negated);
                expression = new BooleanExpression<AtomAcceptance>(acc);
                break;
            }
            case 32: {
                HOAFParserCC.jj_consume_token(32);
                expression = new BooleanExpression<boolean>(true);
                break;
            }
            case 33: {
                HOAFParserCC.jj_consume_token(33);
                expression = new BooleanExpression<boolean>(false);
                break;
            }
            default: {
                HOAFParserCC.jj_la1[9] = jj_gen;
                HOAFParserCC.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final AtomAcceptance.Type AcceptanceConditionTemporalOperator() throws ParseException {
        String temporalOperator = HOAFParserCC.Identifier();
        if (temporalOperator.equals("Fin")) {
            return AtomAcceptance.Type.TEMPORAL_FIN;
        }
        if (temporalOperator.equals("Inf")) {
            return AtomAcceptance.Type.TEMPORAL_INF;
        }
        throw new ParseException("Illegal operator '" + temporalOperator + "' in acceptance condition, expected either 'Fin' or 'Inf'");
    }

    public static final void HeaderItemAccName() throws ParseException {
        String accName;
        ArrayList<Object> extraInfo;
        block9: {
            extraInfo = new ArrayList<Object>();
            HOAFParserCC.jj_consume_token(19);
            accName = HOAFParserCC.Identifier();
            block7: while (true) {
                switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                    case 34: 
                    case 36: {
                        break;
                    }
                    default: {
                        HOAFParserCC.jj_la1[10] = jj_gen;
                        break block9;
                    }
                }
                switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                    case 36: {
                        String identifier = HOAFParserCC.Identifier();
                        extraInfo.add(identifier);
                        continue block7;
                    }
                    case 34: {
                        Integer integer = HOAFParserCC.Integer();
                        extraInfo.add(integer);
                        continue block7;
                    }
                }
                break;
            }
            HOAFParserCC.jj_la1[11] = jj_gen;
            HOAFParserCC.jj_consume_token(-1);
            throw new ParseException();
        }
        if (settings == null || !settings.getFlagIgnoreAccName()) {
            consumer.provideAcceptanceName(accName, extraInfo);
        }
    }

    public static final void HeaderItemTool() throws ParseException {
        String version = null;
        HOAFParserCC.jj_consume_token(20);
        String tool = HOAFParserCC.QuotedString();
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 35: {
                version = HOAFParserCC.QuotedString();
                break;
            }
            default: {
                HOAFParserCC.jj_la1[12] = jj_gen;
            }
        }
        consumer.setTool(tool, version);
    }

    public static final void HeaderItemName() throws ParseException {
        HOAFParserCC.jj_consume_token(21);
        String name = HOAFParserCC.QuotedString();
        consumer.setName(name);
    }

    public static final void HeaderItemProperties() throws ParseException {
        ArrayList<String> properties = new ArrayList<String>();
        HOAFParserCC.jj_consume_token(22);
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 36: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[13] = jj_gen;
                    break block3;
                }
            }
            String property = HOAFParserCC.Identifier();
            properties.add(property);
        }
        consumer.addProperties(properties);
    }

    public static final void HeaderItemMisc() throws ParseException {
        String headerName;
        ArrayList<Object> content;
        block11: {
            content = new ArrayList<Object>();
            headerName = HOAFParserCC.HeaderName();
            block10: while (true) {
                switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: {
                        break;
                    }
                    default: {
                        HOAFParserCC.jj_la1[14] = jj_gen;
                        break block11;
                    }
                }
                switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                    case 34: {
                        Object o = HOAFParserCC.Integer();
                        content.add(o);
                        continue block10;
                    }
                    case 36: {
                        Object o = HOAFParserCC.Identifier();
                        content.add(o);
                        continue block10;
                    }
                    case 35: {
                        Object o = HOAFParserCC.QuotedString();
                        content.add(o);
                        continue block10;
                    }
                    case 32: {
                        Object o = HOAFParserCC.jj_consume_token(32);
                        content.add("t");
                        continue block10;
                    }
                    case 33: {
                        Object o = HOAFParserCC.jj_consume_token(33);
                        content.add("f");
                        continue block10;
                    }
                }
                break;
            }
            HOAFParserCC.jj_la1[15] = jj_gen;
            HOAFParserCC.jj_consume_token(-1);
            throw new ParseException();
        }
        consumer.addMiscHeader(headerName, content);
    }

    public static final void Body() throws ParseException {
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[16] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.StateName();
            HOAFParserCC.Edges();
        }
    }

    public static final void StateName() throws ParseException {
        BooleanExpression<AtomLabel> labelExpr = null;
        String stateComment = null;
        List<Integer> accSignature = null;
        HOAFParserCC.jj_consume_token(13);
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 28: {
                labelExpr = HOAFParserCC.Label();
                break;
            }
            default: {
                HOAFParserCC.jj_la1[17] = jj_gen;
            }
        }
        Integer state = HOAFParserCC.Integer();
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 35: {
                stateComment = HOAFParserCC.QuotedString();
                break;
            }
            default: {
                HOAFParserCC.jj_la1[18] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 30: {
                accSignature = HOAFParserCC.AcceptanceSignature();
                break;
            }
            default: {
                HOAFParserCC.jj_la1[19] = jj_gen;
            }
        }
        if (currentState != null) {
            consumer.notifyEndOfState(currentState);
        }
        consumer.addState(state, stateComment, labelExpr, accSignature);
        currentState = state;
        currentStateHasStateLabel = labelExpr != null;
    }

    public static final void Edges() throws ParseException {
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 28: 
                case 34: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[20] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.Edge();
        }
    }

    public static final void Edge() throws ParseException {
        BooleanExpression<AtomLabel> labelExpr = null;
        List<Integer> accSignature = null;
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 28: {
                labelExpr = HOAFParserCC.Label();
                break;
            }
            default: {
                HOAFParserCC.jj_la1[21] = jj_gen;
            }
        }
        List<Integer> conjStates = HOAFParserCC.StateConjunction();
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 30: {
                accSignature = HOAFParserCC.AcceptanceSignature();
                break;
            }
            default: {
                HOAFParserCC.jj_la1[22] = jj_gen;
            }
        }
        if (labelExpr != null || currentStateHasStateLabel) {
            consumer.addEdgeWithLabel(currentState, labelExpr, conjStates, accSignature);
        } else {
            consumer.addEdgeImplicit(currentState, conjStates, accSignature);
        }
    }

    public static final BooleanExpression<AtomLabel> Label() throws ParseException {
        HOAFParserCC.jj_consume_token(28);
        BooleanExpression<AtomLabel> labelExpr = HOAFParserCC.LabelExpr();
        HOAFParserCC.jj_consume_token(29);
        return labelExpr;
    }

    public static final BooleanExpression<AtomLabel> LabelExpr() throws ParseException {
        BooleanExpression<AtomLabel> left = HOAFParserCC.LabelExprAnd();
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 25: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[23] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.jj_consume_token(25);
            BooleanExpression<AtomLabel> right = HOAFParserCC.LabelExprAnd();
            left = left.or(right);
        }
        return left;
    }

    public static final BooleanExpression<AtomLabel> LabelExprAnd() throws ParseException {
        BooleanExpression<AtomLabel> left = HOAFParserCC.LabelExprAtom();
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[24] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.jj_consume_token(24);
            BooleanExpression<AtomLabel> right = HOAFParserCC.LabelExprAtom();
            left = left.and(right);
        }
        return left;
    }

    public static final BooleanExpression<AtomLabel> LabelExprAtom() throws ParseException {
        BooleanExpression<Object> expression = null;
        switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
            case 26: {
                HOAFParserCC.jj_consume_token(26);
                expression = HOAFParserCC.LabelExpr();
                HOAFParserCC.jj_consume_token(27);
                break;
            }
            case 32: {
                HOAFParserCC.jj_consume_token(32);
                expression = new BooleanExpression<boolean>(true);
                break;
            }
            case 33: {
                HOAFParserCC.jj_consume_token(33);
                expression = new BooleanExpression<boolean>(false);
                break;
            }
            case 23: {
                HOAFParserCC.jj_consume_token(23);
                expression = HOAFParserCC.LabelExprAtom();
                expression = expression.not();
                break;
            }
            case 34: {
                int apIndex = HOAFParserCC.Integer();
                expression = new BooleanExpression<AtomLabel>(AtomLabel.createAPIndex(apIndex));
                break;
            }
            case 38: {
                String aliasName = HOAFParserCC.AliasName();
                expression = new BooleanExpression<AtomLabel>(AtomLabel.createAlias(aliasName));
                break;
            }
            default: {
                HOAFParserCC.jj_la1[25] = jj_gen;
                HOAFParserCC.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public static final List<Integer> AcceptanceSignature() throws ParseException {
        ArrayList<Integer> accSignature = new ArrayList<Integer>();
        HOAFParserCC.jj_consume_token(30);
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 34: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[26] = jj_gen;
                    break block3;
                }
            }
            Integer accSet = HOAFParserCC.Integer();
            accSignature.add(accSet);
        }
        HOAFParserCC.jj_consume_token(31);
        return accSignature;
    }

    public static final List<Integer> StateConjunction() throws ParseException {
        ArrayList<Integer> conjStates = new ArrayList<Integer>();
        Integer state = HOAFParserCC.Integer();
        conjStates.add(state);
        block3: while (true) {
            switch (jj_ntk == -1 ? HOAFParserCC.jj_ntk() : jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    HOAFParserCC.jj_la1[27] = jj_gen;
                    break block3;
                }
            }
            HOAFParserCC.jj_consume_token(24);
            state = HOAFParserCC.Integer();
            conjStates.add(state);
        }
        return conjStates;
    }

    public static final String Identifier() throws ParseException {
        HOAFParserCC.jj_consume_token(36);
        return HOAFParserCC.getToken((int)0).image;
    }

    public static final int Integer() throws ParseException {
        HOAFParserCC.jj_consume_token(34);
        return Integer.parseInt(HOAFParserCC.getToken((int)0).image);
    }

    public static final String QuotedString() throws ParseException {
        HOAFParserCC.jj_consume_token(35);
        String s = HOAFParserCC.getToken((int)0).image;
        s = s.substring(1, s.length() - 1);
        return s;
    }

    public static final String HeaderName() throws ParseException {
        HOAFParserCC.jj_consume_token(37);
        String s = HOAFParserCC.getToken((int)0).image;
        return s.substring(0, s.length() - 1);
    }

    public static final String AliasName() throws ParseException {
        HOAFParserCC.jj_consume_token(38);
        String s = HOAFParserCC.getToken((int)0).image;
        return s.substring(1);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4097, 4097, 8372224, 8372224, 0x1000000, 0, 0x2000000, 0x1000000, 0x800000, 0x4000000, 0, 0, 0, 0, 0, 0, 8192, 0x10000000, 0, 0x40000000, 0x10000000, 0x10000000, 0x40000000, 0x2000000, 0x1000000, 0x4800000, 0, 0x1000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 32, 32, 0, 8, 0, 0, 0, 19, 20, 20, 8, 16, 31, 31, 0, 0, 8, 0, 4, 0, 0, 0, 0, 71, 4, 0};
    }

    public HOAFParserCC(InputStream stream) {
        this(stream, null);
    }

    public HOAFParserCC(InputStream stream, String encoding) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new HOAFParserCCTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            HOAFParserCC.jj_la1[i] = -1;
        }
    }

    public static void ReInit(InputStream stream) {
        HOAFParserCC.ReInit(stream, null);
    }

    public static void ReInit(InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HOAFParserCCTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            HOAFParserCC.jj_la1[i] = -1;
        }
    }

    public HOAFParserCC(Reader stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new HOAFParserCCTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            HOAFParserCC.jj_la1[i] = -1;
        }
    }

    public static void ReInit(Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        HOAFParserCCTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            HOAFParserCC.jj_la1[i] = -1;
        }
    }

    public HOAFParserCC(HOAFParserCCTokenManager tm) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            HOAFParserCC.jj_la1[i] = -1;
        }
    }

    public void ReInit(HOAFParserCCTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            HOAFParserCC.jj_la1[i] = -1;
        }
    }

    private static Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = oldToken.next != null ? HOAFParserCC.token.next : (HOAFParserCC.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (HOAFParserCC.token.kind == kind) {
            ++jj_gen;
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw HOAFParserCC.generateParseException();
    }

    public static final Token getNextToken() {
        token = HOAFParserCC.token.next != null ? HOAFParserCC.token.next : (HOAFParserCC.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = token_source.getNextToken());
        }
        return t;
    }

    private static int jj_ntk() {
        jj_nt = HOAFParserCC.token.next;
        if (jj_nt == null) {
            HOAFParserCC.token.next = token_source.getNextToken();
            jj_ntk = HOAFParserCC.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = HOAFParserCC.jj_nt.kind;
        return jj_ntk;
    }

    public static ParseException generateParseException() {
        int i;
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[40];
        if (jj_kind >= 0) {
            la1tokens[HOAFParserCC.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 28; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 40; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            HOAFParserCC.jj_expentry[0] = i;
            jj_expentries.add(jj_expentry);
        }
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = jj_expentries.get(i2);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    static {
        jj_initialized_once = false;
        jj_la1 = new int[28];
        HOAFParserCC.jj_la1_init_0();
        HOAFParserCC.jj_la1_init_1();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
    }

    private static class AbortedException
    extends RuntimeException {
        private AbortedException() {
        }
    }
}

