/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class PowerSetIterator
implements Iterator<boolean[]> {
    private final boolean[] base;
    private final boolean[] current;
    private final int domainSize;
    private boolean first = true;

    public PowerSetIterator(boolean[] base) {
        this.base = (boolean[])base.clone();
        this.current = new boolean[base.length];
        int domainSize = 0;
        for (boolean value : this.base) {
            if (!value) continue;
            ++domainSize;
        }
        this.domainSize = domainSize;
    }

    public int currentIndex() {
        if (this.domainSize > 32) {
            throw new IllegalStateException();
        }
        int index = 0;
        for (int i = 0; i < this.base.length; ++i) {
            if (!this.current[i]) continue;
            index |= 1 << i;
        }
        return index;
    }

    public long currentIndexLong() {
        if (this.domainSize > 64) {
            throw new IllegalStateException();
        }
        long index = 0L;
        for (int i = 0; i < this.base.length; ++i) {
            if (!this.current[i]) continue;
            index |= 1L << i;
        }
        return index;
    }

    @Override
    public boolean hasNext() {
        if (this.first) {
            return true;
        }
        for (int i = 0; i < this.base.length; ++i) {
            if (!this.base[i] || this.current[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] next() {
        if (this.first) {
            this.first = false;
            return this.current;
        }
        for (int i = 0; i < this.base.length; ++i) {
            if (!this.base[i]) continue;
            if (this.current[i]) {
                this.current[i] = false;
                continue;
            }
            this.current[i] = true;
            return this.current;
        }
        throw new NoSuchElementException("No next element");
    }
}

