/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.safra;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.immutables.value.Value;
import owl.translations.safra.TreeTuple;
import owl.util.annotation.HashedTuple;

@HashedTuple
@Value.Immutable
public abstract class Tree<L> {
    abstract L label();

    abstract List<Tree<L>> children();

    static <L> Tree<L> of(L label) {
        return TreeTuple.create(label, List.of());
    }

    static <L> Tree<L> of(L label, Collection<Tree<L>> children) {
        return TreeTuple.create(label, children);
    }

    public Tree<L> with(L label) {
        return Tree.of(label, this.children());
    }

    public Tree<L> map(BiFunction<L, List<Tree<L>>, Tree<L>> function) {
        return function.apply(this.label(), Lists.transform(this.children(), child -> child.map(function)));
    }

    public Tree<L> map(Function<L, L> function) {
        return Tree.of(function.apply(this.label()), Lists.transform(this.children(), child -> child.map(function)));
    }

    public void forEach(Consumer<L> action) {
        this.children().forEach((? super T child) -> child.forEach(action));
        action.accept(this.label());
    }

    public void forEach(BiConsumer<L, List<L>> action) {
        action.accept(this.label(), Lists.transform(this.children(), Tree::label));
        this.children().forEach((? super T child) -> child.forEach(action));
    }

    public String toString() {
        return this.children().isEmpty() ? "(" + this.label() + ")" : "(" + this.label() + " - " + this.children() + ")";
    }
}

