/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.automaton.AutomatonFactory;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.factories.ValuationSetFactory;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.SyntacticFragment;
import owl.translations.rabinizer.GSet;
import owl.translations.rabinizer.MonitorAutomaton;
import owl.translations.rabinizer.MonitorState;
import owl.translations.rabinizer.MonitorStateFactory;

final class MonitorBuilderNoAcceptance {
    private static final Logger logger = Logger.getLogger(MonitorBuilderNoAcceptance.class.getName());
    private final GOperator gOperator;
    private final EquivalenceClass initialClass;
    private final boolean isFinite;
    private final Set<GSet> relevantSets;
    private final MonitorStateFactory stateFactory;
    private final ValuationSetFactory vsFactory;

    private MonitorBuilderNoAcceptance(GOperator gOperator, EquivalenceClass formula, Collection<GSet> relevantSets, ValuationSetFactory vsFactory, boolean eager) {
        this.gOperator = gOperator;
        this.vsFactory = vsFactory;
        Set<Formula> modalOperators = formula.modalOperators();
        this.isFinite = modalOperators.stream().allMatch(SyntacticFragment.FINITE::contains);
        boolean isCoSafety = modalOperators.stream().allMatch(SyntacticFragment.CO_SAFETY::contains);
        logger.log(Level.FINE, "Creating builder for formula {0} and relevant sets {1}; safety: {2}, no G-sub: {3}", new Object[]{formula, relevantSets, this.isFinite, isCoSafety});
        this.stateFactory = new MonitorStateFactory(eager, isCoSafety);
        this.relevantSets = Set.copyOf(relevantSets);
        this.initialClass = this.stateFactory.getInitialState(formula);
    }

    static MonitorAutomaton create(GOperator gOperator, EquivalenceClass operand, Collection<GSet> relevantSets, ValuationSetFactory vsFactory, boolean eager) {
        return new MonitorBuilderNoAcceptance(gOperator, operand, relevantSets, vsFactory, eager).build();
    }

    private static void optimizeInitialState(MutableAutomaton<MonitorState, ParityAcceptance> monitor) {
        logger.log(Level.FINER, "Optimizing initial state");
        List<Set<MonitorState>> sccs = SccDecomposition.computeSccs(monitor, false);
        MonitorState initialState = (MonitorState)monitor.onlyInitialState();
        BitSet emptyBitSet = new BitSet(0);
        MonitorState optimizedInitialState = initialState;
        Predicate<MonitorState> isTransient = state -> sccs.parallelStream().noneMatch(scc -> scc.contains(state));
        while (isTransient.test(optimizedInitialState)) {
            assert (optimizedInitialState != null);
            optimizedInitialState = monitor.successor(optimizedInitialState, emptyBitSet);
        }
        assert (optimizedInitialState != null);
        if (!Objects.equals(optimizedInitialState, initialState)) {
            monitor.initialStates(Set.of(optimizedInitialState));
            monitor.trim();
        }
    }

    private MonitorAutomaton build() {
        MonitorState initialState = MonitorState.of(this.initialClass);
        BiFunction<MonitorState, BitSet, Edge> successorFunction = this.isFinite ? this::getSuccessorSafety : this::getSuccessor;
        MutableAutomaton<MonitorState, ParityAcceptance> monitor = MutableAutomatonFactory.copy(AutomatonFactory.create(this.vsFactory, initialState, new ParityAcceptance(0, ParityAcceptance.Parity.MIN_ODD), successorFunction));
        monitor.name(String.format("Monitor for %s", this.initialClass));
        if (!this.isFinite) {
            MonitorBuilderNoAcceptance.optimizeInitialState(monitor);
        }
        return new MonitorAutomaton(this.gOperator, Maps.asMap(this.relevantSets, set -> monitor));
    }

    private Edge<MonitorState> getSuccessor(MonitorState currentState, BitSet valuation) {
        List<EquivalenceClass> currentRanking = currentState.formulaRanking();
        int currentRankingSize = currentRanking.size();
        ArrayList<EquivalenceClass> successorRanking = new ArrayList<EquivalenceClass>(currentRankingSize + 1);
        boolean successorContainsInitial = false;
        block0: for (int rank = 0; rank < currentRankingSize; ++rank) {
            assert (successorRanking.size() <= rank);
            EquivalenceClass currentClass = currentRanking.get(rank);
            EquivalenceClass successorClass = this.stateFactory.getRankSuccessor(currentClass, valuation);
            if (successorClass.isFalse() || MonitorStateFactory.isSink(successorClass)) continue;
            for (EquivalenceClass olderSuccessorClass : successorRanking) {
                assert (olderSuccessorClass != null && !MonitorStateFactory.isSink(olderSuccessorClass));
                if (!successorClass.equals(olderSuccessorClass)) continue;
                continue block0;
            }
            successorContainsInitial |= this.initialClass.equals(successorClass);
            successorRanking.add(successorClass);
        }
        assert (successorContainsInitial == successorRanking.contains(this.initialClass));
        if (!successorContainsInitial) {
            successorRanking.add(this.initialClass);
        }
        return Edge.of(MonitorState.of(successorRanking));
    }

    private Edge<MonitorState> getSuccessorSafety(MonitorState currentState, BitSet valuation) {
        EquivalenceClass currentRanking = (EquivalenceClass)Iterables.getOnlyElement(currentState.formulaRanking());
        EquivalenceClass successorClass = this.stateFactory.getRankSuccessor(currentRanking, valuation);
        EquivalenceClass successorRanking = successorClass.isFalse() ? this.initialClass : successorClass.and(this.initialClass);
        return Edge.of(MonitorState.of(successorRanking));
    }
}

