/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.ltl.EquivalenceClass;
import owl.translations.ltl2ldba.RecurringObligation;

public class Jump<U extends RecurringObligation> {
    private static final Logger logger = Logger.getLogger(Jump.class.getName());
    final U obligations;
    final EquivalenceClass remainder;
    private final EquivalenceClass language;

    Jump(EquivalenceClass remainder, U obligations) {
        this.remainder = remainder;
        this.obligations = obligations;
        this.language = remainder.and(obligations.getLanguage());
    }

    boolean containsLanguageOf(Jump<U> jump) {
        boolean contains;
        boolean bl = contains = jump.remainder.implies(this.remainder) && this.obligations.containsLanguageOf((RecurringObligation)jump.obligations);
        if (contains) {
            logger.log(Level.FINER, () -> this + " contains the language of " + jump);
        }
        return contains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Jump jump = (Jump)o;
        return Objects.equals(this.remainder, jump.remainder) && Objects.equals(this.obligations, jump.obligations);
    }

    EquivalenceClass getLanguage() {
        return this.language;
    }

    public int hashCode() {
        return Objects.hash(this.remainder, this.obligations);
    }

    public String toString() {
        return "Jump{obligations=" + this.obligations + ", remainder=" + this.remainder + ", language=" + this.language + "}";
    }
}

