/*
 * Decompiled with CFR 0.152.
 */
package owl.run.modules;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.immutables.value.Value;
import owl.run.modules.InputReader;
import owl.run.modules.OutputWriter;
import owl.run.modules.OwlModule;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;

abstract class AbstractOwlModuleParser<M extends OwlModule>
implements OwlModuleParser<M> {
    private AbstractOwlModuleParser() {
    }

    @Override
    @Value.Default
    public String getDescription() {
        return OwlModuleParser.super.getDescription();
    }

    @Override
    @Value.Derived
    public Options getOptions() {
        Options directOptions = this.optionsDirect();
        Supplier<Options> optionsBuilder = this.optionsBuilder();
        if (directOptions == null) {
            return optionsBuilder == null ? new Options() : optionsBuilder.get();
        }
        if (optionsBuilder == null) {
            return directOptions;
        }
        throw new IllegalStateException("Both optionsDirect() and optionsBuilder() used");
    }

    @Nullable
    @Value.Default
    public Options optionsDirect() {
        return null;
    }

    @Nullable
    @Value.Default
    public Supplier<Options> optionsBuilder() {
        return null;
    }

    @Override
    public final M parse(CommandLine commandLine) throws ParseException {
        return (M)((OwlModule)this.parser().parse(commandLine));
    }

    abstract ParseFunction<CommandLine, M> parser();

    @Value.Immutable
    @Value.Style(typeAbstract={"Abstract*"}, visibility=Value.Style.ImplementationVisibility.PUBLIC)
    static abstract class AbstractWriterParser
    extends AbstractOwlModuleParser<OutputWriter>
    implements OwlModuleParser.WriterParser {
        AbstractWriterParser() {
        }
    }

    @Value.Immutable
    @Value.Style(typeAbstract={"Abstract*"}, visibility=Value.Style.ImplementationVisibility.PUBLIC)
    static abstract class AbstractTransformerParser
    extends AbstractOwlModuleParser<Transformer>
    implements OwlModuleParser.TransformerParser {
        AbstractTransformerParser() {
        }
    }

    @Value.Style(typeAbstract={"Abstract*"}, visibility=Value.Style.ImplementationVisibility.PUBLIC)
    @Value.Immutable
    static abstract class AbstractReaderParser
    extends AbstractOwlModuleParser<InputReader>
    implements OwlModuleParser.ReaderParser {
        AbstractReaderParser() {
        }
    }

    @FunctionalInterface
    public static interface ParseFunction<K, V> {
        public V parse(K var1) throws ParseException;
    }
}

