/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.util;

import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.collections.Collections3;
import owl.ltl.Biconditional;
import owl.ltl.BinaryModalOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.PropositionalFormula;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.UnaryModalOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.Collector;

public final class FormulaIsomorphism {
    private FormulaIsomorphism() {
    }

    @Nullable
    public static int[] compute(Formula formula1, Formula formula2) {
        BitSet atoms1 = Collector.collectAtoms(formula1);
        BitSet atoms2 = Collector.collectAtoms(formula2);
        if (atoms1.cardinality() != atoms2.cardinality()) {
            return null;
        }
        ValidationVisitor preValidationVisitor = new ValidationVisitor(null);
        if (!formula1.accept(preValidationVisitor, formula2).booleanValue()) {
            return null;
        }
        List atomsList1 = atoms1.stream().boxed().collect(Collectors.toList());
        List atomsList2 = atoms2.stream().boxed().collect(Collectors.toList());
        int[] mapping = new int[atoms1.length()];
        Arrays.fill(mapping, -1);
        ValidationVisitor validationVisitor = new ValidationVisitor(mapping);
        for (List atomsList2Perm : Collections2.permutations(atomsList2)) {
            Collections3.zip(atomsList1, atomsList2Perm, (x, y) -> {
                mapping[x.intValue()] = y;
            });
            if (!formula1.accept(validationVisitor, formula2).booleanValue()) continue;
            return mapping;
        }
        return null;
    }

    private static final class ValidationVisitor
    implements BinaryVisitor<Formula, Boolean> {
        @Nullable
        private final int[] mapping;

        private ValidationVisitor(@Nullable int[] mapping) {
            this.mapping = mapping;
        }

        @Override
        public Boolean visit(Biconditional biconditional, Formula formula) {
            if (!(formula instanceof Biconditional)) {
                return Boolean.FALSE;
            }
            return biconditional.left.accept(this, ((Biconditional)formula).left) != false && biconditional.right.accept(this, ((Biconditional)formula).right) != false;
        }

        @Override
        public Boolean visit(BooleanConstant booleanConstant, Formula formula) {
            return booleanConstant.equals(formula);
        }

        @Override
        public Boolean visit(Conjunction conjunction, Formula formula) {
            return this.visitPropositionalOperator(conjunction, formula);
        }

        @Override
        public Boolean visit(Disjunction disjunction, Formula formula) {
            return this.visitPropositionalOperator(disjunction, formula);
        }

        @Override
        public Boolean visit(FOperator fOperator, Formula formula) {
            return this.visitUnaryOperator(fOperator, formula);
        }

        @Override
        public Boolean visit(GOperator gOperator, Formula formula) {
            return this.visitUnaryOperator(gOperator, formula);
        }

        @Override
        public Boolean visit(Literal literal, Formula formula) {
            if (!(formula instanceof Literal)) {
                return Boolean.FALSE;
            }
            Literal otherLiteral = (Literal)formula;
            if (literal.isNegated() ^ otherLiteral.isNegated()) {
                return Boolean.FALSE;
            }
            return this.mapping == null ? Boolean.TRUE : this.mapping[literal.getAtom()] == otherLiteral.getAtom();
        }

        @Override
        public Boolean visit(MOperator mOperator, Formula formula) {
            return this.visitBinaryOperator(mOperator, formula);
        }

        @Override
        public Boolean visit(UOperator uOperator, Formula formula) {
            return this.visitBinaryOperator(uOperator, formula);
        }

        @Override
        public Boolean visit(ROperator rOperator, Formula formula) {
            return this.visitBinaryOperator(rOperator, formula);
        }

        @Override
        public Boolean visit(WOperator wOperator, Formula formula) {
            return this.visitBinaryOperator(wOperator, formula);
        }

        @Override
        public Boolean visit(XOperator xOperator, Formula formula) {
            return this.visitUnaryOperator(xOperator, formula);
        }

        private Boolean visitUnaryOperator(UnaryModalOperator operator, Formula formula) {
            if (!operator.getClass().isInstance(formula)) {
                return Boolean.FALSE;
            }
            return operator.operand.accept(this, ((UnaryModalOperator)formula).operand);
        }

        private Boolean visitBinaryOperator(BinaryModalOperator operator, Formula formula) {
            if (!operator.getClass().isInstance(formula)) {
                return Boolean.FALSE;
            }
            return operator.left.accept(this, ((BinaryModalOperator)formula).left) != false && operator.right.accept(this, ((BinaryModalOperator)formula).right) != false;
        }

        private Boolean visitPropositionalOperator(PropositionalFormula formula1, Formula formula2) {
            if (!formula1.getClass().isInstance(formula2)) {
                return Boolean.FALSE;
            }
            PropositionalFormula formula2Casted = (PropositionalFormula)formula2;
            if (formula1.children.size() != formula2Casted.children.size()) {
                return Boolean.FALSE;
            }
            ArrayList<Formula> children1 = new ArrayList<Formula>(formula1.children);
            ArrayList<Formula> children2 = new ArrayList<Formula>(formula2Casted.children);
            for (List children2Permutation : Collections2.permutations(children2)) {
                int i;
                for (i = 0; i < children1.size() && ((Formula)children1.get(i)).accept(this, (Formula)children2Permutation.get(i)).booleanValue(); ++i) {
                }
                if (i != children1.size()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

