/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.ltl.BooleanConstant;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.PropositionalFormula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class Conjunction
extends PropositionalFormula {
    public Conjunction(Collection<? extends Formula> conjuncts) {
        super(conjuncts);
    }

    public Conjunction(Formula ... conjuncts) {
        this(Set.of(conjuncts));
    }

    public Conjunction(Stream<? extends Formula> formulaStream) {
        this(formulaStream.collect(Collectors.toUnmodifiableSet()));
    }

    public static Formula of(Formula left, Formula right) {
        return Conjunction.of(Stream.of(left, right));
    }

    public static Formula of(Formula ... formulas) {
        return Conjunction.of(Stream.of(formulas));
    }

    public static Formula of(Iterable<? extends Formula> iterable) {
        return Conjunction.of(iterable.iterator());
    }

    public static Formula of(Stream<? extends Formula> stream) {
        return Conjunction.of(stream.iterator());
    }

    public static Formula of(Iterator<? extends Formula> iterator) {
        HashSet<Formula> set = new HashSet<Formula>();
        while (iterator.hasNext()) {
            Formula child = iterator.next();
            assert (child != null);
            if (child == BooleanConstant.FALSE) {
                return BooleanConstant.FALSE;
            }
            if (child == BooleanConstant.TRUE) continue;
            if (child instanceof Conjunction) {
                set.addAll(((Conjunction)child).children);
                continue;
            }
            set.add(child);
        }
        if (set.isEmpty()) {
            return BooleanConstant.TRUE;
        }
        if (set.size() == 1) {
            return (Formula)set.iterator().next();
        }
        return new Conjunction(set);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    protected char getOperator() {
        return '&';
    }

    @Override
    protected int hashCodeOnce() {
        return Objects.hash(Conjunction.class, this.children);
    }

    @Override
    public Formula nnf() {
        return new Conjunction(this.map(Formula::nnf));
    }

    @Override
    public Formula not() {
        return new Disjunction(this.map(Formula::not));
    }

    @Override
    public Formula temporalStep(BitSet valuation) {
        return Conjunction.of(this.map(c -> c.temporalStep(valuation)));
    }

    @Override
    public Formula temporalStepUnfold(BitSet valuation) {
        return Conjunction.of(this.map(c -> c.temporalStepUnfold(valuation)));
    }

    @Override
    public Formula unfold() {
        return Conjunction.of(this.map(Formula::unfold));
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Conjunction.of(this.map(c -> c.unfoldTemporalStep(valuation)));
    }
}

