/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.Objects;
import java.util.function.Predicate;
import owl.ltl.AbstractFormula;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public class Biconditional
extends AbstractFormula {
    public final Formula left;
    public final Formula right;

    public Biconditional(Formula leftOperand, Formula rightOperand) {
        this.left = leftOperand;
        this.right = rightOperand;
    }

    public static Formula of(Formula leftOperand, Formula rightOperand) {
        if (leftOperand.equals(BooleanConstant.TRUE)) {
            return rightOperand;
        }
        if (leftOperand.equals(BooleanConstant.FALSE)) {
            return rightOperand.not();
        }
        if (rightOperand.equals(BooleanConstant.TRUE)) {
            return leftOperand;
        }
        if (rightOperand.equals(BooleanConstant.FALSE)) {
            return leftOperand.not();
        }
        if (leftOperand.equals(rightOperand)) {
            return BooleanConstant.TRUE;
        }
        if (leftOperand.equals(rightOperand.not())) {
            return BooleanConstant.FALSE;
        }
        return new Biconditional(leftOperand, rightOperand);
    }

    @Override
    public int accept(IntVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <R, P> R accept(BinaryVisitor<P, R> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    @Override
    public boolean allMatch(Predicate<Formula> predicate) {
        return predicate.test(this) && this.left.allMatch(predicate) && this.right.allMatch(predicate);
    }

    @Override
    public boolean anyMatch(Predicate<Formula> predicate) {
        return predicate.test(this) || this.left.anyMatch(predicate) || this.right.anyMatch(predicate);
    }

    @Override
    public boolean isPureEventual() {
        return false;
    }

    @Override
    public boolean isPureUniversal() {
        return false;
    }

    @Override
    public boolean isSuspendable() {
        return false;
    }

    @Override
    public Formula not() {
        return Biconditional.of(this.left.not(), this.right);
    }

    @Override
    public Formula nnf() {
        Formula nnfLeft = this.left.nnf();
        Formula nnfRight = this.right.nnf();
        return Disjunction.of(Conjunction.of(nnfLeft, nnfRight), Conjunction.of(nnfLeft.not(), nnfRight.not()));
    }

    @Override
    public Formula temporalStep(BitSet valuation) {
        return Biconditional.of(this.left.temporalStep(valuation), this.right.temporalStep(valuation));
    }

    @Override
    public Formula temporalStepUnfold(BitSet valuation) {
        return Biconditional.of(this.left.temporalStepUnfold(valuation), this.right.temporalStepUnfold(valuation));
    }

    @Override
    public Formula unfold() {
        return Biconditional.of(this.left.unfold(), this.right.unfold());
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return Biconditional.of(this.left.unfoldTemporalStep(valuation), this.right.unfoldTemporalStep(valuation));
    }

    @Override
    protected boolean equals2(AbstractFormula o) {
        assert (this.getClass() == o.getClass());
        Biconditional that = (Biconditional)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    @Override
    protected int hashCodeOnce() {
        return Objects.hash(Biconditional.class, this.left, this.right);
    }

    public String toString() {
        return "(" + this.left + " <-> " + this.right + ")";
    }
}

