/*
 * Decompiled with CFR 0.152.
 */
package owl.jni;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import owl.ltl.BinaryModalOperator;
import owl.ltl.Conjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UnaryModalOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.PullUpXVisitor;
import owl.ltl.visitors.Collector;

final class FormulaPartition {
    final Clusters cosafetyClusters = new Clusters();
    final List<Formula> dba = new ArrayList<Formula>();
    final List<Formula> dca = new ArrayList<Formula>();
    final List<Formula> dpa = new ArrayList<Formula>();
    final Clusters safetyClusters = new Clusters();
    final Map<Integer, Clusters> singleStepSafetyClusters = new HashMap<Integer, Clusters>();

    FormulaPartition() {
    }

    Set<Formula> safety() {
        HashSet<Formula> safety = new HashSet<Formula>();
        this.safetyClusters.clusterList.forEach(safety::addAll);
        this.singleStepSafetyClusters.forEach((z, x) -> x.clusterList.forEach(safety::addAll));
        return safety;
    }

    Set<Formula> cosafety() {
        HashSet<Formula> cosafety = new HashSet<Formula>();
        this.cosafetyClusters.clusterList.forEach(cosafety::addAll);
        return cosafety;
    }

    static FormulaPartition of(Collection<Formula> input) {
        FormulaPartition partition = new FormulaPartition();
        for (Formula x : input) {
            if (SyntacticFragment.SAFETY.contains(x)) {
                PullUpXVisitor.XFormula rewrittenX = x.accept(PullUpXVisitor.INSTANCE);
                if (FormulaPartition.isSingleStep(rewrittenX.rawFormula())) {
                    partition.singleStepSafetyClusters.computeIfAbsent(rewrittenX.depth(), ignore -> new Clusters()).insert(XOperator.of(rewrittenX.rawFormula(), rewrittenX.depth()));
                    continue;
                }
                partition.safetyClusters.insert(x);
                continue;
            }
            if (SyntacticFragment.CO_SAFETY.contains(x)) {
                partition.cosafetyClusters.insert(x);
                continue;
            }
            if (SyntacticFragments.isDetBuchiRecognisable(x)) {
                partition.dba.add(x);
                continue;
            }
            if (SyntacticFragments.isDetCoBuchiRecognisable(x)) {
                partition.dca.add(x);
                continue;
            }
            partition.dpa.add(x);
        }
        return partition;
    }

    private static boolean isSingleStep(Formula formula) {
        if (formula instanceof Conjunction) {
            return ((Conjunction)formula).children.stream().allMatch(FormulaPartition::isSingleStep);
        }
        return formula instanceof GOperator && SyntacticFragment.SINGLE_STEP.contains(((GOperator)formula).operand);
    }

    static class Clusters {
        private static final Predicate<Formula> INTERESTING_OPERATOR = o -> !(o instanceof XOperator) && (o instanceof UnaryModalOperator || o instanceof BinaryModalOperator);
        List<Set<Formula>> clusterList = new ArrayList<Set<Formula>>();

        Clusters() {
        }

        void insert(Formula formula) {
            HashSet<Formula> cluster = new HashSet<Formula>();
            cluster.add(formula);
            this.clusterList.removeIf(x -> {
                boolean addToCluster;
                boolean bl = addToCluster = !Collections.disjoint(Collector.collect(INTERESTING_OPERATOR, (Iterable<? extends Formula>)x), Collector.collect(INTERESTING_OPERATOR, formula));
                if (addToCluster) {
                    cluster.addAll((Collection<Formula>)x);
                    return true;
                }
                return false;
            });
            this.clusterList.add(cluster);
        }
    }
}

