/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.minimizations;

import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.algorithms.EmptinessCheck;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.minimizations.GeneralizedRabinMinimizations;
import owl.automaton.minimizations.GenericMinimizations;
import owl.automaton.minimizations.Minimization;
import owl.automaton.output.HoaPrinter;
import owl.automaton.transformations.ParityUtil;

public final class MinimizationUtil {
    private static final Logger logger = Logger.getLogger(MinimizationUtil.class.getName());
    private static final List<Minimization<Object, GeneralizedRabinAcceptance>> generalizedRabinDefaultLightList = List.of(GeneralizedRabinMinimizations::minimizeOverlap, GenericMinimizations::removeTransientAcceptance, GeneralizedRabinMinimizations::minimizeComplementaryInf, GeneralizedRabinMinimizations::minimizeGloballyIrrelevant, GeneralizedRabinMinimizations::minimizeEdgeImplications, GeneralizedRabinMinimizations::minimizeSccIrrelevant, GeneralizedRabinMinimizations::minimizeTrivial);
    private static final List<Minimization<Object, GeneralizedRabinAcceptance>> generalizedRabinDefaultAllList = List.of(GeneralizedRabinMinimizations::minimizeOverlap, GeneralizedRabinMinimizations::minimizeMergePairs, GenericMinimizations::removeTransientAcceptance, GeneralizedRabinMinimizations::minimizeComplementaryInf, GeneralizedRabinMinimizations::minimizeGloballyIrrelevant, GeneralizedRabinMinimizations::minimizeEdgeImplications, GeneralizedRabinMinimizations::minimizeSccIrrelevant, GeneralizedRabinMinimizations::minimizeTrivial, GeneralizedRabinMinimizations::minimizePairImplications, GeneralizedRabinMinimizations::minimizeMergePairs, GeneralizedRabinMinimizations::minimizeComplementaryInf, GeneralizedRabinMinimizations::minimizePairImplications, GeneralizedRabinMinimizations::minimizeEdgeImplications, GeneralizedRabinMinimizations::minimizeSccIrrelevant, GeneralizedRabinMinimizations::minimizeGloballyIrrelevant);
    private static final List<Minimization<Object, GeneralizedRabinAcceptance>> rabinDefaultAllList = List.of(GeneralizedRabinMinimizations::minimizeOverlap, GeneralizedRabinMinimizations::minimizeMergePairs, GenericMinimizations::removeTransientAcceptance, GeneralizedRabinMinimizations::minimizeGloballyIrrelevant, GeneralizedRabinMinimizations::minimizeEdgeImplications, GeneralizedRabinMinimizations::minimizeSccIrrelevant, GeneralizedRabinMinimizations::minimizeTrivial, GeneralizedRabinMinimizations::minimizePairImplications, GeneralizedRabinMinimizations::minimizeMergePairs, GeneralizedRabinMinimizations::minimizePairImplications, GeneralizedRabinMinimizations::minimizeEdgeImplications, GeneralizedRabinMinimizations::minimizeSccIrrelevant, GeneralizedRabinMinimizations::minimizeGloballyIrrelevant);
    private static final List<Minimization<Object, ParityAcceptance>> parityDefaultList = List.of(GenericMinimizations::removeTransientAcceptance, ParityUtil::minimizePriorities);

    private MinimizationUtil() {
    }

    public static <S, A extends OmegaAcceptance> void applyMinimization(MutableAutomaton<S, ? extends A> automaton, List<Minimization<S, A>> minimizationList) {
        if (minimizationList.isEmpty()) {
            return;
        }
        logger.log(Level.FINE, "Optimizing automaton with {0}", minimizationList);
        for (Minimization<S, A> minimization : minimizationList) {
            logger.log(Level.FINEST, () -> String.format("Current automaton: %s", HoaPrinter.toString(automaton)));
            logger.log(Level.FINER, "Applying {0}", minimization);
            minimization.minimize(automaton);
            automaton.trim();
        }
        logger.log(Level.FINEST, () -> String.format("Automaton after optimization:%n%s", HoaPrinter.toString(automaton)));
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> minimizeDefault(MutableAutomaton<S, A> automaton, MinimizationLevel level) {
        Object acceptance = automaton.acceptance();
        if (acceptance instanceof RabinAcceptance) {
            MinimizationUtil.applyMinimization(automaton, rabinDefaultAllList);
        } else if (acceptance instanceof GeneralizedRabinAcceptance) {
            MutableAutomaton<S, A> dgra = automaton;
            if (level == MinimizationLevel.ALL) {
                MinimizationUtil.applyMinimization(dgra, generalizedRabinDefaultAllList);
            } else {
                MinimizationUtil.applyMinimization(dgra, generalizedRabinDefaultLightList);
            }
        } else if (acceptance instanceof ParityAcceptance) {
            MutableAutomaton<S, A> dpa = automaton;
            MinimizationUtil.applyMinimization(dpa, parityDefaultList);
        } else {
            logger.log(Level.FINE, "Received unsupported acceptance type {0}", acceptance.getClass());
        }
        return automaton;
    }

    public static <S> void removeAndRemapIndices(MutableAutomaton<S, ?> automaton, IntSet indicesToRemove) {
        if (indicesToRemove.isEmpty()) {
            automaton.trim();
            return;
        }
        int acceptanceSets = ((OmegaAcceptance)automaton.acceptance()).acceptanceSets();
        Int2IntAVLTreeMap remapping = new Int2IntAVLTreeMap();
        remapping.defaultReturnValue(Integer.MAX_VALUE);
        int newIndex = 0;
        for (int index = 0; index < acceptanceSets; ++index) {
            if (indicesToRemove.contains(index)) {
                remapping.put(index, -1);
                continue;
            }
            remapping.put(index, newIndex);
            ++newIndex;
        }
        logger.log(Level.FINER, "Remapping acceptance indices: {0}", remapping);
        automaton.updateEdges((arg_0, arg_1) -> MinimizationUtil.lambda$removeAndRemapIndices$2((Int2IntMap)remapping, arg_0, arg_1));
        automaton.trim();
    }

    public static <S> void removeDeadStates(MutableAutomaton<S, ?> automaton) {
        List<Set<S>> sccs = SccDecomposition.computeSccs(automaton);
        for (Set<S> scc : sccs) {
            if (!SccDecomposition.isTrap(automaton, scc) || !EmptinessCheck.isEmpty(automaton, scc.iterator().next())) continue;
            logger.log(Level.FINER, "Removing scc {0}", scc);
            automaton.removeStateIf(scc::contains);
            automaton.trim();
        }
    }

    static <S> void removeIndices(MutableAutomaton<S, ?> automaton, Set<S> states, BitSet indicesToRemove) {
        if (indicesToRemove.isEmpty() || states.isEmpty()) {
            return;
        }
        logger.log(Level.FINER, "Removing acceptance indices {0} on subset", indicesToRemove);
        IntUnaryOperator transformer = index -> indicesToRemove.get(index) ? -1 : index;
        automaton.updateEdges(states, (state, edge) -> edge.withAcceptance(transformer));
        automaton.trim();
    }

    private static /* synthetic */ Edge lambda$removeAndRemapIndices$2(Int2IntMap remapping, Object state, Edge edge) {
        return edge.withAcceptance((IntUnaryOperator)remapping);
    }

    public static enum MinimizationLevel {
        LIGHT,
        MEDIUM,
        ALL;

    }
}

