/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;

public final class MutableAutomatonUtil {
    private MutableAutomatonUtil() {
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> castMutable(Object automaton, Class<S> stateClass, Class<A> acceptanceClass) {
        Automaton<S, A> castedAutomaton = AutomatonUtil.cast(automaton, stateClass, acceptanceClass);
        Preconditions.checkArgument((boolean)(automaton instanceof MutableAutomaton), (String)"Expected automaton, got %s", (Object)automaton.getClass().getName());
        return (MutableAutomaton)castedAutomaton;
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> asMutable(Automaton<S, A> automaton) {
        if (automaton instanceof MutableAutomaton) {
            return (MutableAutomaton)automaton;
        }
        return MutableAutomatonFactory.copy(automaton);
    }

    public static Optional<Object> complete(MutableAutomaton<Object, ?> automaton) {
        return MutableAutomatonUtil.complete(automaton, Sink.INSTANCE);
    }

    public static <S> Optional<S> complete(MutableAutomaton<S, ?> automaton, S sinkState) {
        Map<S, ValuationSet> incompleteStates;
        if (automaton.initialStates().isEmpty()) {
            automaton.addInitialState(sinkState);
        }
        if ((incompleteStates = AutomatonUtil.getIncompleteStates(automaton)).isEmpty()) {
            return Optional.empty();
        }
        Edge sinkEdge = Edge.of(sinkState, ((OmegaAcceptance)automaton.acceptance()).rejectingSet());
        incompleteStates.forEach((state, valuation) -> automaton.addEdge((Object)state, (ValuationSet)valuation, sinkEdge));
        automaton.addEdge(sinkState, automaton.factory().universe(), sinkEdge);
        return Optional.of(sinkState);
    }

    public static final class Sink {
        public static final Sink INSTANCE = new Sink();

        private Sink() {
        }

        public String toString() {
            return "SINK";
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return Sink.class.hashCode();
        }
    }
}

