/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.tools.ant.BaseJpfTask;
import org.java.plugin.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathTask
extends BaseJpfTask {
    private String pathId;
    private String pathIdRef;
    private String pluginId;
    private String pluginIds;
    private boolean followExports = true;

    public void setPathId(String value) {
        this.pathId = value;
    }

    public void setPathIdRef(String value) {
        this.pathIdRef = value;
    }

    public void setPluginId(String value) {
        this.pluginId = value;
    }

    public void setPluginIds(String value) {
        this.pluginIds = value;
    }

    public void setFollowExports(boolean value) {
        this.followExports = value;
    }

    public void execute() throws BuildException {
        Path path;
        if (this.pathId == null && this.pathIdRef == null) {
            throw new BuildException("pathid or pathidref attribute must be set!", this.getLocation());
        }
        Set<String> ids = this.collectTargetIds();
        if (ids.isEmpty()) {
            throw new BuildException("pluginid or/and pluginids attribute must be set!", this.getLocation());
        }
        this.initRegistry(true);
        HashSet<String> processedIds = new HashSet<String>();
        HashSet<File> result = new HashSet<File>();
        for (PluginDescriptor descr : this.getRegistry().getPluginDescriptors()) {
            if (!ids.contains(descr.getId())) continue;
            this.processDescriptor(result, processedIds, descr, true);
        }
        for (PluginFragment fragment : this.getRegistry().getPluginFragments()) {
            if (!ids.contains(fragment.getId())) continue;
            this.processDescriptor(result, processedIds, this.getRegistry().getPluginDescriptor(fragment.getPluginId()), true);
        }
        if (this.pathIdRef != null) {
            Object ref = this.getProject().getReference(this.pathIdRef);
            if (!(ref instanceof Path)) {
                throw new BuildException("invalid reference " + this.pathIdRef + ", expected " + Path.class.getName() + ", found " + ref, this.getLocation());
            }
            path = (Path)ref;
        } else {
            path = new Path(this.getProject());
            this.getProject().addReference(this.pathId, (Object)path);
        }
        for (File file : result) {
            path.setLocation(file);
        }
        if (this.getVerbose()) {
            this.log("Collected path entries: " + result.size());
        }
    }

    private void processDescriptor(Set<File> result, Set<String> processedIds, PluginDescriptor descr, boolean includePrivate) {
        if (this.followExports && !includePrivate && processedIds.contains(descr.getId())) {
            return;
        }
        processedIds.add(descr.getId());
        for (Library lib : descr.getLibraries()) {
            if (this.followExports && !includePrivate && lib.getExports().isEmpty()) continue;
            URL url = this.getPathResolver().resolvePath(lib, lib.getPath());
            File file = IoUtil.url2file(url);
            if (file != null) {
                result.add(file);
                if (!this.getVerbose()) continue;
                this.log("Collected file " + file + " from library " + lib.getUniqueId());
                continue;
            }
            this.log("Ignoring non-local URL " + url + " found in library " + lib.getUniqueId());
        }
        for (PluginPrerequisite pre : descr.getPrerequisites()) {
            if (!pre.matches()) continue;
            this.processDescriptor(result, processedIds, this.getRegistry().getPluginDescriptor(pre.getPluginId()), false);
        }
    }

    private Set<String> collectTargetIds() {
        HashSet<String> result = new HashSet<String>();
        if (this.pluginId != null) {
            result.add(this.pluginId);
        }
        if (this.pluginIds != null) {
            StringTokenizer st = new StringTokenizer(this.pluginIds, ",", false);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
        }
        return result;
    }
}

